/****************************************************************************** 
 *
 * File:        gsreset.c
 *
 *              Send Roland GS RESET System Exclusive Message to all Synths.
 *
 * Version:     1.0
 * Date:        1994-11-25
 *              1994-12-04
 *
 * Project:     Roland MPU-401 Device driver for Linux 1.1.52 and higher.
 *
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 *
 * Copyrights:  Copyright (c) 1994 Kim Burgaard.
 *
 *	This package is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by the
 *	Free Software Foundation; either version 2, or (at your option) any
 *	later version.
 *
 *	This package is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *	Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License along
 *	with this program; see the file COPYING. If not, write to the Free
 *	Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************
 *
 * Description: This is a ``little'' example application that utilizes my Roland
 *              MPU-401 Device Driver.
 *
 ******************************************************************************/

#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include "mpuioctl.h"

int
main(int arc, char *argv[])
{
  int mpudev = open("/dev/mpu401data", O_RDWR);

  if (mpudev != -1)
    {
      ioctl(mpudev, MPUIOC_GS_RESET, 0);
      close(mpudev);
      return 0;
    };

  return -1;
}

/*** END OF FILE **************************************************************/
