/****************************************************************************** 
 *
 * File:        midiprint.h
 *
 *              Standard MIDI File Pretty Printing
 *
 * Version:     0.1
 * Date:        1994-11-27
 *
 * Project:     MIDI/Sequencer library.
 *
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 *
 * Copyrights:  Copyright (c) 1994 Kim Burgaard.
 *
 *      This package is free software; you can redistribute it and/or modify it
 *      under the terms of the GNU General Public License as published by the
 *      Free Software Foundation; either version 2, or (at your option) any
 *      later version.
 *
 *      This package is distributed in the hope that it will be useful, but
 *      WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *      Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; see the file COPYING. If not, write to the Free
 *      Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************
 *
 * Someday I'll describe the superior features of this library ;-)
 *
 * The short of the long is that it can parse and load a Standard MIDI File
 * and put the resulting events onto some queues. They are defined in
 * midiqueue.h and should be straight forward to understand.
 *
 * The loading can be controlled in some wayes. It can for example be told not
 * to store anything but just run through the file. Thus, it can be used to
 * check a MIDI file for errors or to compute the total playing time. This is
 * exactly what `smfplay' does before it actually plays anything.
 *
 * Save and miscellaneous convertion routines will be added with time...
 *
 * Oh, I forgot - it's bound to be rewritten in C++; MIDI simply cries for
 * an object orientated implementation ;-).
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#ifndef __MIDI_PRINT_H
#define __MIDI_PRINT_H

#include "miditypes.h"
#include "midiqueue.h"

/*** ENUMERATIONS *************************************************************/

enum MIDI_PRINT {
  MIDI_PRINT_NONE,
  MIDI_PRINT_SPARSE, /* sequence name and such */
  MIDI_PRINT_META,   /* all meta events */
  MIDI_PRINT_ALL
};

/*** MIDI FILE PRETTY PRINTING ************************************************/

extern void midi_printdata(int size, char* data);
extern void midi_printtext(int size, char* data);
extern void midi_printunknown(midi_event *event, enum MIDI_PRINT level);
extern void midi_printmeta(midi_event *event, enum MIDI_PRINT level);
extern void midi_printsysex(midi_event *event, enum MIDI_PRINT level);
extern void midi_printevent(midi_event *event, enum MIDI_PRINT level);
extern void midi_printrawevent(byte type, unsigned long time, word size, char *data, enum MIDI_PRINT level);

#endif /* __MIDI_PRINT_H */

/*** END OF FILE **************************************************************/
