/****************************************************************************** 
 *
 * File:        mpuconfig.c
 *
 *              Configuration tool for the MPU-401 Device driver.
 *
 * Version:     1.0
 * Date:        1994-11-20
 *
 * Project:     Roland MPU-401 Device driver for Linux 1.1.64 and higher.
 *
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 *
 * Copyrights:  Copyright (c) 1994 Kim Burgaard.
 *
 *      This package is free software; you can redistribute it and/or modify it
 *      under the terms of the GNU General Public License as published by the
 *      Free Software Foundation; either version 2, or (at your option) any
 *      later version.
 *
 *      This package is distributed in the hope that it will be useful, but
 *      WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *      Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; see the file COPYING. If not, write to the Free
 *      Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#include <errno.h>
#include <stdio.h>

#include "configure.h"

/*** MAIN *********************************************************************/

unsigned int mpu_IRQ = 0x0002;
unsigned int mpu_IOP = 0x0330;

char buf[8] = { 'M', 'P', 'U', '!', 0x00, 0x02, 0x03, 0x30 };
char ch;

FILE *CF = NULL;

int
main(void)
{
  printf("MPU-401 Device driver configuration tool v1.0\n");
  printf("Copyright (c) 1994 Kim Burgaard.\n");
  printf("\n");
  
  if ( !(CF = fopen(MPU_RC_PATH, "rb") ) )
    printf("Creating new configuration file %s\n\n", MPU_RC_PATH);
  else
    {
      printf("Reading existing configuration file\n\n");
      if (fread(&buf[0], 1, 8, CF) == 8 && 
	  buf[0] == 'M' && buf[1] == 'P' && buf[2] == 'U' && buf[3] == '!')
	{
	  mpu_IRQ = (buf[4]<<8) | buf[5];
	  mpu_IOP = (buf[6]<<8) | buf[7];
	  printf("old I/O Port: 0x%04x\n", mpu_IOP);
	  printf("old IRQ:      0x%02x\n\n", mpu_IRQ);
	}
      else
	{
	  fprintf(stderr, "Error while reading old file.\n");
	};
    };

  fclose(CF);

  printf("Valid I/O Port adresses are 0x0330, 0x0332, 0x0334 or 0x0336\n");
  printf("Valid IRQ numbers are 2, 3, 4, 5, 6 or 7\n\n");

  do
    {
      printf("Enter new I/O Port: ");
    }
  while ( scanf("%x", &mpu_IOP) != 1 || mpu_IOP % 2 || mpu_IOP < 0x330 || mpu_IOP > 0x336);
  
  do
    {
      printf("Enter new IRQ number: ");
    }
  while ( scanf("%d", &mpu_IRQ) != 1 || mpu_IRQ < 2 || mpu_IRQ > 7);

  buf[4] = (char)(mpu_IRQ >> 8);
  buf[5] = (char)(mpu_IRQ & 0xff);

  buf[6] = (char)(mpu_IOP >> 8);
  buf[7] = (char)(mpu_IOP & 0xff);

  if ( !(CF = fopen(MPU_RC_PATH, "wb") ) )
    {
      fprintf(stderr, "\nCould not write to configuration file `%s\':", MPU_RC_PATH);
      perror("");
      return -3;
    };

  printf("\n");

  if ( !(fwrite(&buf[0], 1, 8, CF) == 8) ) perror("Error while writing new file");

  fclose(CF);

  return 0;
}

/*** END OF FILE **************************************************************/
