/******************************************************************************
 *
 * File:        mpuioctl.h
 *
 * Date:        1994-11-25
 *
 * Version:     0.1 alpha
 *
 * Project:     Roland MPU-401 Device driver for Linux 1.1.64 and higher.
 *
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 *
 * Copyrights:  Copyright (c) 1994 Kim Burgaard.
 *
 *      This package is free software; you can redistribute it and/or modify it
 *      under the terms of the GNU General Public License as published by the
 *      Free Software Foundation; either version 2, or (at your option) any
 *      later version.
 *
 *      This package is distributed in the hope that it will be useful, but
 *      WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *      Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; see the file COPYING. If not, write to the Free
 *      Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************
 *
 * Demand loading works like this:
 *
 *    Write 2 positive/zero values into the voice and control fields. The values 
 *    reflect the lowest count of events in there may remain before the caller
 *    will be woken up. When woken up, the voice and conduct fields will reflect
 *    exactly how many events that remain (because the voice and conduct queues are
 *    independant that is!). If the value set by you is zero, the call will have no
 *    effect on that particular queue. If both are set to zero, ioctl will return
 *    immediatly.
 *
 *    Be sure to start replaying or perform a check whether there has been removed
 *    any events at all or you might end up in an infinite loop!
 *
 *  !!! IMPORTANT !!! Do not fill more than 50-200 events onto the driver queues at a
 *  time. It cant possibly be played at once and then we would just waste kernel
 *  memory for nothing!
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#ifndef __MPU_IOCTL_H
#define __MPU_IOCTL_H

#include <linux/ioctl.h>
#include <linux/major.h>

#include "miditypes.h"
#include "midiqueue.h"
#include "mpu401.h"

/*** /dev DEFINES ***********************************************************/

#define MPU_DEV_MAJOR SOUND_MAJOR

/* These are the MINOR numbers */

#define MPU_DEV_RW 0
#define MPU_DEV_STATUS 1

/*** I/O CONTROL ************************************************************/

/* reset device *AND* driver */
#define MPUIOC_RESET           _IO('M', 0x00)

/* argument points to a mpu_status structure which the driver
 * will fill out */
#define MPUIOC_GET_STATUS      _IOR('M', 0x01, struct mpu_status)

#define MPUIOC_MIDI_THRU_ON    _IO('M', 0x02)
#define MPUIOC_MIDI_THRU_OFF   _IO('M', 0x03)

#define MPUIOC_BENDER_THRU_ON  _IO('M', 0x04)
#define MPUIOC_BENDER_THRU_OFF _IO('M', 0x05)

/*** sequence commands ******************************************************/

/* the long type argument is *NOT* a pointer! It is the initial time tick count */

#define MPUIOC_INIT_PLAY       _IOW('M', 0x10, long)
#define MPUIOC_CONT_PLAY       _IOW('M', 0x11, long)
#define MPUIOC_STOP_PLAY       _IO('M', 0x12)

#define MPUIOC_INIT_OVERDUB    _IOW('M', 0x13, long)
#define MPUIOC_CONT_OVERDUB    _IOW('M', 0x14, long)
#define MPUIOC_STOP_OVERDUB    _IO('M', 0x15)

#define MPUIOC_INIT_RECORD     _IOW('M', 0x16, long)
#define MPUIOC_CONT_RECORD     _IOW('M', 0x17, long)
#define MPUIOC_STOP_RECORD     _IO('M', 0x18)

#define MPUIOC_STOP_ALL        _IO('M', 0x19)

/* argument is a pointer to an integer (enum MIDI_METRONOME) */
#define MPUIOC_SET_METRONOME   _IOW('M', 0x1a, int)
#define MPUIOC_GET_METRONOME   _IOR('M', 0x1b, int)

/* Wait until the OUT and CTL track queues has been emptiet */
#define MPUIOC_SLEEP2PLAY_END   _IO('M', 0x1c)

/* Demand loading system */
#define MPUIOC_SLEEP2DEMAND     _IOWR('M', 0x1d, struct mpu_demand)

/*** time handling - `tick count's are MIDI clocks ***************************/

#define MPUIOC_GET_OUT_TIME     _IOR('M', 0x20, long)
#define MPUIOC_GET_CTL_TIME     _IOR('M', 0x21, long)
#define MPUIOC_GET_REC_TIME     _IOR('M', 0x22, long)

#define MPUIOC_SET_OUT_TIME     _IOW('M', 0x23, long)
#define MPUIOC_SET_CTL_TIME     _IOW('M', 0x24, long)
#define MPUIOC_SET_REC_TIME     _IOW('M', 0x25, long)

#define MPUIOC_CLR_OUT_TIME     _IO('M', 0x26)
#define MPUIOC_CLR_CTL_TIME     _IO('M', 0x27)
#define MPUIOC_CLR_REC_TIME     _IO('M', 0x28)

/* tempo (in BPM) between 8 and 240 */
#define MPUIOC_SET_TEMPO        _IOW('M', 0x29, byte)
#define MPUIOC_GET_TEMPO        _IOR('M', 0x2a, byte)

/* argument is a pointer to a byte which must be one of
 *    48, 72, 86, 120, 144, 168 or 192
 * The driver currently does *not* accept any other values though
 * fx. a division of 480 is very common nowadays. This will change
 * in the future! */
#define MPUIOC_SET_DIVISION     _IOW('M', 0x2b, word)
#define MPUIOC_GET_DIVISION     _IOR('M', 0x2c, word)

#define MPUIOC_SET_MIDI_METRO   _IOW('M', 0x2d, byte)
#define MPUIOC_GET_MIDI_METRO   _IOR('M', 0x2e, byte)

#define MPUIOC_SET_METRO_MEAS   _IOW('M', 0x2f, byte)
#define MPUIOC_GET_METRO_MEAS   _IOR('M', 0x30, byte)

/*** event handling **********************************************************/

/* Turn MIDI IN recording on/off when not in RECORD or OVERDUB mode */
#define MPUIOC_MIDI_IN_ON       _IO('M', 0x40)
#define MPUIOC_MIDI_IN_OFF      _IO('M', 0x41)
#define MPUIOC_MIDI_IN_STATUS   _IOR('M', 0x42, word)

/* argument is a pointer to a mpu_event, may be VOICE or SYSEX.
 * CONTROL events are not allowed to send as immediate data, but that is not
 * important since all control commands are implemented as ioctl commands too. */
#define MPUIOC_PUT_IMMEDIATE    _IOW('M', 0x43, struct midi_event)

/* returns number of events in queues */
#define MPUIOC_GET_OUT_CNT      _IOR('M', 0x44, long)
#define MPUIOC_GET_CTL_CNT      _IOR('M', 0x45, long)
#define MPUIOC_GET_REC_CNT      _IOR('M', 0x46, long)

/* If the REC queue is not empty, this returns the size of the next event to be
 * retreived. Otherwise this returns zero. This information is needed to do 
 * a MPUIOC_GET_REC_EVENT */
#define MPUIOC_GET_REC_DATASIZE _IOR('M', 0x50, long)

/* Put either a VOICE or CONTROL event onto the respective queue */ 
#define MPUIOC_PUT_EVENT        _IOW('M', 0x51, struct midi_event)

/* argument is a mpu_event with allocated space for data. The allocated space must be
 * written in the size field, since GETEVENT do not write the data field if value is
 * lower than the actual size. You must use MPUIOC_GET_REC_SIZE to determine the size 
 * needed for data. */
#define MPUIOC_GET_REC_EVENT    _IOWR('M', 0x52, struct midi_event)

/*** SysEx messages sent to MIDI OUT ******************************************/ 

/* I'm not sure if they really should belong here... */

#define MPUIOC_GM_ON            _IO('M', 0xe0)
#define MPUIOC_GS_RESET         _IO('M', 0xe1)

/*** debug handling ***********************************************************/ 

#define MPUIOC_DEBUG_DUMP       _IO('M', 0xf0)
#define MPUIOC_SET_DEBUG_LVL    _IOW('M', 0xf1, word)
#define MPUIOC_GET_DEBUG_LVL    _IOR('M', 0xf2, word)

#endif /* __MPU_IOCTL_H */

/*** End of File **************************************************************/
