/* Output to SB DAC using DMA mode (up to 64K only) */

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <alloc.h>
#include <stdlib.h>

#include "sb.h"

extern int optind;    /* index of which argument is next      */
extern char *optarg;  /* pointer to argument of current option */
extern int opterr;    /* allow error message  */
int getopt(int argc, char *argv[], char *optionS);

void main(int argc, char *argv[])
{
    FILE *f;
    signed char far *raw, far *aligned;
    long sample_len;
    unsigned sl, nr, sr=11000;
    unsigned long physical, aligned_physical;
    int stereo = 0, error = 0;
    char ch;

    while((ch = getopt(argc,argv,"sr:")) != EOF)
    {
	switch(ch)
	{
	    case 's':
		stereo = 1;
		break;
	    case 'r':
		sr = atoi(optarg);
		break;
	    case '?':
		error++;
		break;
	}
    }
    if(error || optind == argc)
    {
	puts("Usage: dacdma [-r rate] [-s] sample");
	exit(1);
    }

    if(Sb_Get_Params())
    {
        puts("BLASTER environment variable not set.");
        exit(1);
    }

    if(Sb_Init())
    {
	printf("Could not find Soundblaster!\n");
	exit(1);
    }
    printf("Found Soundblaster at address %xh, IRQ %d, DMA %d.\n",
	SbIOaddr,SbIRQ,SbDMAchan);

    f = fopen(argv[optind],"rb");
    if(f == NULL)
    {
	printf("Could not open sample file %s\n",argv[optind]);
	exit(1);
    }
    sample_len = filelength(fileno(f));
    if(sample_len > 64000U)
        sl = 64000U;
    else
        sl = (int)sample_len;

    /* Allocate a 16 byte aligned block of memory */
    raw = (signed char far *)farmalloc((unsigned long)sl + 65535L);
    physical = ((unsigned long)FP_OFF(raw)) + (((unsigned long)FP_SEG(raw)) << 4);
    aligned_physical = physical+0x0FFFFL;
    aligned_physical &= 0xF0000L;
    aligned=MK_FP((unsigned )((aligned_physical >> 4) & 0xFFFF),0);

    /* Read in the sample */
    nr = fread(aligned,1,sl,f);

    fclose(f);

    Sb_Init_Voice_DMA(NULL);   /* Use default interrupt handler */

    sr = Sb_Sample_Rate(sr,PLAY);
    printf("Sample rate = %u Hz\n",sr);
    printf("Output is %s.\n",(stereo) ? "stereo" : "mono");

    Sb_Voice(1);
    printf("Playing sample\n");

    Sb_Voice_DMA(aligned,nr,stereo,PLAY);

    while(!kbhit() && !Sb_DMA_Complete())
	;
    if(!Sb_DMA_Complete())
    {
	Sb_Halt_DMA();
        Sb_Init(); /* Necessary after early termination of a high-speed xfer */
	getch();
    }

    Sb_Voice(0);

    printf("Done.\n");

    Sb_DeInit_Voice_DMA();

    farfree(raw);

    exit(0);
}
