/* $Id: glib.h,v 1.7 89/05/14 13:48:19 lee Exp $
 *
 * GLIB - a Generic LIBrarian and editor for synths
 * Tim Thompson
 * modifications: Kesti, Lee
 * $Log:	glib.h,v $
 * Revision 1.7  89/05/14  13:48:19  lee
 * new variables for 'V' command
 * 
 * Revision 1.6  89/05/06  17:13:25  lee
 * rel. to comp.sources.misc
 * 
 */

#include <stdio.h>
#include "machdep.h"

#ifdef XGL
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#endif

#ifdef GUS
#define LINUXIO
#else
#ifdef SBLAST
#define LINUXIO
#else
#ifdef OPL3
#define LINUXIO
#else
#ifdef KAWAIIK1
#define LINUXIO
#endif
#endif
#endif
#endif

#define EOX 0xf7
#define MOUSE -2

#ifndef BUFSIZ
#define BUFSIZ 512
#endif

/* If a machine needs to do something special to read/write a binary file, */
/* this is a hook that a machdep.h can override to do what it  needs to. */
/* For example, see the Atari ST version  of machdep.h */
#ifndef OPENBINFILE
#define OPENBINFILE(f,file,mode) f=fopen(file,mode)
#endif


#ifndef OPENTEXTFILE
#define OPENTEXTFILE(f,name,mode) f=fopen(name,mode)
#endif

/* Seconds before we give up trying to read something */
#define TIMEOUT 5

#ifdef XGL
#define NUMONSCREEN 16
#else
#define NUMONSCREEN 12
#endif
/* position of first voice row */
#define FIRSTROW 10
#define LEFTSIDE 2
#define RIGHTSIDE 55
#define YANKROW 12
#define YANKCOL 31
#define LIBBANKS 3
#define NOREDRAW 0
#define REDRAW 1

#define ctl(x) (x&037)

#define CH_REDRAW '\014'

#define CH_INC 'K'
#define CH_INC2 'I'
#define CH_INC3 '>'
#define CH_DEC 'J'
#define CH_DEC2 'M'
#define CH_DEC3 '<'
#define CH_SAME 'S'

#define CH_LEFT 'h'
#define CH_DOWN 'j'
#define CH_UP 'k'
#define CH_RIGHT 'l'
/* for arrow key support to work, next 4 defines
 * can't be changed (unless code in unix-mach.c is modified)
 */
#define ALTCH_LEFT ctl('b')
#define ALTCH_DOWN ctl('n')
#define ALTCH_UP ctl('p')
#define ALTCH_RIGHT ctl('f')

#define SCR_DOWN '\04'
#define SCR_UP '\025'

#define STR_LEFT "h"
#define STR_DOWN "j"
#define STR_UP "k"
#define STR_RIGHT "l"

#define VOICEBYTE(d,v,n) (*((d)+(v)*Voicesize+(n)))

#ifndef XGL
#define Panel_item char *
#define XV_NULL 0
#endif
struct paraminfo {
	char *p_name;
	char *p_label;
	INT16 p_lrow;	/* position for printing name */
	INT16 p_lcol;
	INT16 p_vrow;		/* position for printing value */
	INT16 p_vcol;
	INT16 p_wave;	/* marks value as part of wave envelope */
	Panel_item p_button; /* points Xview panel item for editing value */
	char *((*p_tovis)());
	INT16 p_min;
	INT16 p_max;
	INT16 p_val;
	INT16 p_flags;
};

struct labelinfo {
	INT16 l_row;
	INT16 l_col;
	char *l_text;
};

struct editinfo {
	char *ed_name;		/* Synth name */
	char *ed_suffix;	/* file suffix of library files */
	struct paraminfo *ed_params;	/* list of parameters */
	struct labelinfo *ed_labels;	/* screen labels in edit mode */
	INT16 ed_nvoices;		/* number of voices */
	INT16 ed_vsize;		/* size of each voice data, in bytes */
	INT16 ed_nsize;		/* name size */
	int ed_dataid;		/* data ID */
	int (*ed_din)();	/* copy voice data into paraminfo array */
	int (*ed_dout)();	/* copy voice data out of paraminfo array */
	int (*ed_sedit)();	/* send 1 voice to synth edit buffer */
	int (*ed_sone)();	/* send 1 voice to a synth (permanent) patch*/
	int (*ed_sbulk)();	/* send bulk voice data */
	int (*ed_gbulk)();	/* get bulk voice data */
	char *(*ed_nof)();	/* get name of a voice out of data */
	int (*ed_snof)();	/* set name of a voice in data */
	char *(*ed_numof)();	/* convert voice number to on-screen text */
	int (*ed_cvtnum)();	/* convert visable voice number to std. format */
	int (*ed_cvtanum)();	/* convert alphanumeric voice number to std. format */
};

struct peredinfo {
	char *ed_libdata;	/* memory for library banks */
	char *ed_syndata;	/* memory for synth bank */
	char *ed_yankdata;	/* memory for yank buffer */
	INT16 ed_libindex;	/* voice number of topmost displayed lib voice*/
	INT16 ed_synindex;	/* ditto for synth side */
	INT16 ed_channel;		/* MIDI channel # */
	INT16 ed_erow;
	INT16 ed_ecol;
};

extern struct paraminfo *P;
extern struct labelinfo *L;
extern struct editinfo E[];
extern int Rows, Cols, Channel, Nvoices, Voicesize, Redraw, Negparm, DataID;
extern char *Reason, *Synthname;

char *bankvoice();
void setval();
int getval();
char *malloc(), *alloc(), *nextls();
FILE *fopen();
char *strcat(), *strcpy();
long milliclock();

extern int synthinfileflag;
extern int synthoutfileflag;
extern int fditflag;
