#include <stdio.h>
#include <fcntl.h>
#include "cext.h"
#include "adagio.h"
#include "allphase.h"

void card_init()
{
	int tmp_item;
	int i;

	if ((seq_fd=open("/dev/sequencer", O_WRONLY, 0))==-1) {
		perror("/dev/sequencer");
		exit(-1);
	}

	tmp_item = 1;
	if (drum_mode)
	if (ioctl(seq_fd, SNDCTL_SEQ_PERCMODE, &tmp_item) == -1) {
		fprintf(stderr,"trouble asking for perc mode\n");
		exit(1);
	}

	if (ioctl (seq_fd, SNDCTL_SEQ_NRSYNTHS, &nrsynths) == -1) {
		fprintf(stderr,"there is no soundcard\n");
		exit (1);
	}

	for (i = 0; i < nrsynths; i++) {
		card_info[i].device = i;
		if (ioctl (seq_fd, SNDCTL_SYNTH_INFO, &card_info[i]) == -1) {
			fprintf(stderr,"cannot get info on soundcard\n");
			perror ("/dev/sequencer");
			exit (-1);
		}

		if (card_info[i].synth_type == SYNTH_TYPE_SAMPLE
			&& card_info[i].synth_subtype == SAMPLE_TYPE_GUS)
				gus_dev = i;
		else if (card_info[i].synth_type == SYNTH_TYPE_FM) {
				sb_dev = i;
		}
	}

	if (gus_dev >= 0) {
		if (ioctl(seq_fd, SNDCTL_SEQ_RESETSAMPLES, &gus_dev) == -1)
			perror("Sample reset");
	}

	if (ioctl (seq_fd, SNDCTL_SEQ_NRMIDIS, &nrmidis) == -1) {
		fprintf(stderr,"can't get info about midi ports\n");
		exit (1);
	}

	if (nrmidis > 0) ext_dev = 0;

	if (exclude_gus) gus_dev = -1;
	if (exclude_fm) sb_dev = -1;
	if (!extflag) ext_dev = -1;
}

