
#define BASS_DRM 128
#define FLOORTOM 129
#define CYMBAL_D 130
#define RG_SNARE 131
#define RIM_SHOT 132
#define BONGO_DR 133
#define AC_SNARE 134
#define RIDE_CYM 135

#define TOM__TOM 136
#define CONGA_DR 137
#define BELL_DRM 138
#define LOG_DRUM 139
#define TRIANGLE 140
#define MARACCAS 141
#define TAMBRINE 142
#define TIMBALE_ 143

#define TINKLE_B 112
#define AGOGO_BL 113
#define STEEL_DR 114
#define WOOD_BLK 115
#define TAIKO_DR 116
#define MEL__TOM 117
#define SYNTH_DR 118
#define REV_CYMB 119

#define LOW_DNOTE 36
#define MID_DNOTE 48
#define HGH_DNOTE 60
#define CYM_DNOTE 60

#define LOW_TNOTE 41
#define MID_TNOTE 44
#define MDH_TNOTE 46
#define HGH_TNOTE 48

struct d_type{
	char *dname;
	char dv;
	char dnote;
} d_voice[47] = {
	"Acoustic Bass Drum",	BASS_DRM,  41,
	"Bass Drum 1",		BASS_DRM,  44,
	"Side Stick",		RIM_SHOT,  58,
	"Acoustic Snare",	RG_SNARE,  59, /*60?*/
	"Hand Clap",		RIM_SHOT,  65,
	"Electric Snare",	RG_SNARE,  61,
	"Low Floor Tom",	FLOORTOM,  41,
	"Closed High Hat",	RIDE_CYM,  64,

	"Hi Floor Tom",		FLOORTOM,  48,
	"Pedal High Hat",	RIDE_CYM,  66,
	"Low Tom",		FLOORTOM,  49,
	"Open High Hat",	CYMBAL_D,  79,
	"Low-Mid Tom",		FLOORTOM,  50,
	"High-Mid Tom",		FLOORTOM,  51,
	"Crash Cymbal 1",	CYMBAL_D,  60,
	"High Tom",		FLOORTOM,  53,

	"Ride Cymbal 1",	RIDE_CYM,  60,
	"Chinese Cymbal",	CYMBAL_D,  65,
	"Ride Bell",		BELL_DRM,  60,
	"Tambourine",		TAMBRINE,  62,
	"Splash Cymbal",	CYMBAL_D,  79,
	"Cow Bell",		BELL_DRM,  59,
	"Crash Cymbal 2",	CYMBAL_D,  64,
	"Vibraslap",		FLOORTOM,  52,

	"Ride Cymbal 2",	RIDE_CYM,  58,
	"High Bongo",		BONGO_DR,  50,
	"Low Bongo",		BONGO_DR,  45,
	"Mute High Conga",	CONGA_DR,  44,
	"Open High Conga",	CONGA_DR,  50,
	"Low Conga",		CONGA_DR,  41,
	"High Timbale",		TIMBALE_,  26,
	"Low Timbale",		TIMBALE_,  25,

	"High Agogo",		LOG_DRUM,  MID_DNOTE,
	"Low Agogo",		LOG_DRUM,  LOW_DNOTE,
	"Cabasa",		LOG_DRUM,  MID_DNOTE,
	"Maraccas",		MARACCAS,  50,
	"Short Whistle",	BELL_DRM,  63,
	"Long Whistle",		BELL_DRM,  64,
	"Short Guiro",		BELL_DRM,  61,
	"Long Guiro",		BELL_DRM,  62,

	"Claves",		LOG_DRUM,  69,
	"High Wood Block",	LOG_DRUM,  63,
	"Low Wood Block",	LOG_DRUM,  58,
	"Mute Cuica",		BELL_DRM,  HGH_DNOTE,
	"Open Cuica",		TRIANGLE,  HGH_DNOTE,
	"Mute Triangle",	BELL_DRM,  HGH_DNOTE,
	"Open Triangle",	TRIANGLE,  HGH_DNOTE
};
