/* gusvoice.c, adapted (slightly) from gusload.c by H. Savolainen, --gl */

#include <stdio.h>
#include <sys/ultrasound.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>
#include "cext.h"
#include "adagio.h"
#include "allphase.h"
#include "gusvoice.h"

#ifndef SBDIR
#define SBDIR "/etc"
#endif

struct pat_header {
    char            magic[12];
    char            version[10];
    char            copyright[60];
    char            fill[3];
    char            nr_samples;
};

struct sample_header {
    char            name[6];
    unsigned short  xx;
    long            len;
    long            loop_start;
    long            loop_end;
    unsigned short  base_freq;
    long            low_note;
    long            high_note;
    long            base_note;
    char            detune;
    char            unknown;
    char            panning;
};


struct patch_info *patch;

#ifndef GUSMEMAVAIL
#define GUSMEMAVAIL (256*1024)
#endif

static int patch_mem_used = 0;
static char *vdata = NULL;

#ifndef GUSPATDIR
#define GUSPATDIR "/dos/ultrasnd/midi"
#endif

#define GUSPATSLDIR GUSPATDIR##"/"
#define SBSTDLIB SBDIR##"/"##"std.gus"
#define SBDRUMLIB SBDIR##"/"##"drums.gus"

#define GUSVOICESIZE 646

int
gusvoice(int pgm)
{
	static int std_fd = -1;
	static int drum_fd = -1;
	int lib_fd;
	char *libname;

	int             i, n, patfd, tmp;
	struct pat_header *header;
	struct sample_header *sample;
	char            buf[100];
	long            offset;
	short          *w;
	int             x;
	char		 *fname;
	char		patfname[80];

	if (pgm < 0 || (pgm > 127 && pgm < 128+35) || pgm > 128+81) return(0);
	if (gus_voice[pgm].loaded) return(1);

	if (patch_mem_used + gus_voice[pgm].mem_req > GUSMEMAVAIL) {
		return(0);
	}

	if (pgm <= 127) {
		libname = SBSTDLIB;
		if (std_fd < 0 && (std_fd = open (libname, O_RDONLY, 0)) == -1) {
			perror (libname);
			exit (1);
		}
		lib_fd = std_fd;
		offset = pgm * GUSVOICESIZE;
	}
	else {
		libname = SBDRUMLIB;
		if (drum_fd < 0 && (drum_fd = open (libname, O_RDONLY, 0)) == -1) {
			perror (libname);
			exit (1);
		}
		lib_fd = drum_fd;
		offset = (pgm - 128 - 27) * GUSVOICESIZE;
	}
	if (lseek (lib_fd, offset, 0) == -1) {
		perror (libname);
		exit (1);
	}

	if (vdata == NULL) vdata = (char *)malloc(GUSVOICESIZE);
	if (vdata == NULL) {
		fprintf(stderr, "out of memory\n");
	}
	if (read (lib_fd, vdata, GUSVOICESIZE) != GUSVOICESIZE) {
		fprintf(stderr, "%s: Short file\n", libname);
		exit (1);
	}
	header = (struct pat_header *)vdata;

	fname = header->copyright;
	if (fname == NULL || !*fname) {
		fprintf(stderr, "%s: defective lib\n", libname);
		exit(1);
	}
	strcpy(patfname, GUSPATSLDIR);
	fname += strlen(fname) - 1;
	while (fname > header->copyright && *fname != '/') fname--;
	strcat(patfname, fname+1);

	gus_voice[pgm].rscale = header->version[0];
	gus_voice[pgm].rrate = header->version[1];
	gus_voice[pgm].rtop = header->version[2];
	gus_voice[pgm].rbot = header->version[3];
	gus_voice[pgm].rampmode = header->version[4];
	gus_voice[pgm].sustain = header->version[5];
	gus_voice[pgm].volume = header->version[6];
	if (header->version[7])
		gus_voice[pgm].lowest = gus_voice[pgm].highest = header->version[7] + 12;

	if (gus_voice[pgm].rscale > 3 || gus_voice[pgm].rrate > 63)
		gus_voice[pgm].rrate = 0;
	if (gus_voice[pgm].sustain > 118) gus_voice[pgm].sustain = 118;

/**
printf("gus_voice: pgm %d, rscale %d, rrate %d, rtop %d, rbot %d, rampmode %d\n", pgm,
gus_voice[pgm].rscale,
gus_voice[pgm].rrate,
gus_voice[pgm].rtop,
gus_voice[pgm].rbot,
gus_voice[pgm].rampmode);
**/

	if ((patfd = open (patfname, O_RDONLY, 0)) == -1) {
		perror (patfname);
		exit (-1);
	}

	offset = 0xef;


    for (i = 0; i < header->nr_samples; i++) {

	sample = (struct sample_header *)(vdata + sizeof(*header)
			+ i*sizeof(*sample));

	offset = offset + 96;

	patch = (struct patch_info *) malloc(sizeof(*patch) + sample->len);

	patch->key = GUS_PATCH;
	patch->device_no = gus_dev;
	patch->instr_no = pgm;
	patch->encoding = SAMPLE_SIGNED16;
	patch->mode = 0;
	patch->len = sample->len;
	patch->loop_start = sample->loop_start;
	patch->loop_end = sample->loop_end;
	patch->base_note = sample->base_note;
	patch->high_note = sample->high_note;
	patch->low_note = sample->low_note;
	patch->base_freq = sample->base_freq;
	patch->detuning = 0;
	patch->panning = 0;

	if (lseek (patfd, offset, 0) == -1) {
		perror (patfname);
		exit (-1);
	}

	if (read (patfd, patch->data, sample->len) != sample->len) {
		fprintf (stderr, "%s: Short file\n", patfname);
		exit (-1);
	}

	w = (short *) &(patch->data[0]);

	for (x = 0; x < (sample->len / 2); x++) {
		w[x] = ((unsigned short) w[x]) - 32768;
	}

	if (write(seq_fd, (char*)patch, sizeof(*patch) + sample->len) == -1) {
		patch_mem_used = GUSMEMAVAIL;
		/*perror("/dev/sequencer");*/
		close(patfd);
		free(patch);
		return(0);
	}
	offset += sample->len;
	patch_mem_used += sample->len;
	free(patch);
    }


	close(patfd);
	gus_voice[pgm].loaded = 1;

	if (verbose)
		printf("patch %s, %d mem used of %d, %d still free\n", gus_voice[pgm].vname,
		patch_mem_used, GUSMEMAVAIL, GUSMEMAVAIL-patch_mem_used);
	return(1);
}
