/* phase2.c -- this module plays notes compiled and sorted in phase1 or phasem */

#define THESE_VOICES 24
#define GUS_TUNING (-500)
#define NO_RUNNING_STATUS
#define WAKETHRESH 512
#define TRY_REVERB

#include <stdio.h>
#include <ctype.h>
#include <malloc.h>
#include <fcntl.h>
#include "cext.h"
#include "adagio.h"
#include "userio.h"
#include "cmdline.h"
#include "allphase.h"
#include "pitch.h"
#include "midicode.h"
#include "midi.h"
#include "midifile.h"
#include "sblast.h"
#include "drum.h"

#define MAXTIME 10000000

#define n_t_sw 2
private char *t_switches[n_t_sw] = { "-t", "-trace" };
#define n_m_sw 2
private char *m_switches[n_m_sw] = { "-m", "-midi" };
/**
#define n_e_sw 2
private char *e_switches[n_e_sw] = { "-e", "-external" };
**/
#define nmsw 2
private char *msw[nmsw] = { "-i", "-init" };
private boolean initflag = false;
private boolean v_drum = true;
private boolean use_damper = false;
private int recording_channel = 1;
private int recording_program = 0;

private unsigned long time = 0;	/* time clock */
private unsigned long sb_time = 0; /* time clock */
private unsigned long lasttime = 0;	/* time clock */
private boolean readable = false;

private int stat_cell_on = 0;
private int stat_cell_off = 0;
private int stat_imp_cell_off[MAXCARDS];
private int stat_not_cell_off = 0;
private int stat_note_on[3];
private int stat_note_off[3];

private int user_scale = false; /* true if user-defined scale */
private int bend[num_voices];	/* current pitch bend on channel */
private pitch_table pit_tab[128];	/* scale definition */

private char sblast = true;
/****************************************************************************
* Routines local to this module
****************************************************************************/
private	void	off_init();
private void	tuninginit();
private void	read_tuning();
private	boolean	note_offs();
private long	next_off();
private	void	off_schedule();
private void	f_note();
private void	f_touch();
private void	f_program();
private void	f_ctrl();
private void	f_bend();


#define SBOUTCHUNK 128
static unsigned char sbbuf[SBOUTCHUNK+8];
static char buf[8];
static int sbptr = 0;
static int perc_mode;
static int instr_key[256];
static int sb_trnsps[256];
static int d_dur[256];
static int dnote[256];
#ifdef XVOICE
static int xvoice[256];
#endif

private void midisync(void);
private void fm_program(int,int,int,int);
private void fm_ctrl(int,int,int,int,int);
private void fm_bend(int,int,int);
private void fm_touch(int,int,int);
private void fm_noteon(int,int,int,int,int,int,unsigned long);
private void fm_noteoff(int,int,int,int,int,int,unsigned long);
private int new_cell(int,unsigned long, int, int, int, int);
#ifdef TRY_VIBRATO
private void fm_vibrate(unsigned long);
#endif
#ifdef MIDIIN
private void	listen();
private int	midigetc(void);
private int	midipending(void);
private void	midimessage();
#endif

#define SBMONWAIT 10

void sbflush(void)
{	int room, lastroom;
	int count = SBMONWAIT;

	if (!sbptr) return;

	while ( (ioctl(seq_fd,SNDCTL_SEQ_GETOUTCOUNT,&room) != -1) && (room - (sbptr/4) < 128)) {
		if (count == SBMONWAIT) lastroom = room;
		usleep(200000);
		if (count-- == 0) {
			if (room > lastroom) count = SBMONWAIT;

			else if (room < sbptr/4) {
				printf("problem with output queue ...\n");
				(void)ioctl(seq_fd, SNDCTL_SEQ_RESET, 0);
				exit(1);
				time = sb_time = 0;
				break;

			}

			else  break;
		}
#ifdef MIDIIN
		listen();
#endif
	}

	if (write(seq_fd, sbbuf, sbptr) == -1) {
		perror("write /dev/sequencer");
		exit(-1);
	}
	sbptr=0;
}

void sqwrite(char *msg)
{
	if (sbptr+8>=SBOUTCHUNK) sbflush();
	memcpy(&sbbuf[sbptr], msg, 8);
	sbptr +=8;
}
void sbwrite(char *msg)
{
	if (sbptr+4>=SBOUTCHUNK) sbflush();

	memcpy(&sbbuf[sbptr], msg, 4);
	sbptr +=4;
}

void sb_resync()
{
	buf[0] = SEQ_SYNCTIMER;
	sbwrite(buf);
	sbflush();
	time = sb_time = 0;
}

void midich(char c)
{
	buf[0] = SEQ_MIDIPUTC;
	buf[1] = c;
	buf[2] = ext_dev;
	buf[3] = 0;
	sbwrite(buf);
}

void midicmdch(char c)
{
#ifndef NO_RUNNING_STATUS
	static char lastcmd = 0;
	if (c == lastcmd) return;
	lastcmd = c;
#endif
	midich(c);
	return;
}

#ifdef MIDIIN
int inonenb()
{
	if (!midipending()) {
		usleep(100000);
		if (!midipending()) {
			usleep(1000000);
			if (!midipending()) {
				usleep(10000000);
				if (!midipending()) return(-1);
			}
		}
	}
	return((midigetc()&0xff));
}
#endif

extern struct sub_type{
	char *vname;
	char solo;
	char newv;
	char transpose;
} sub_voice[];

private int main_volume[num_voices] =
	{ 90, 90, 90, 90, 90, 90, 90, 90,
	  90, 90, 90, 90, 90, 90, 90, 90 };
private int expression[16] =
	{ 64, 64, 64, 64, 64, 64, 64, 64,
	  64, 64, 64, 64, 64, 64, 64, 64 };
private int reverberation[16] =
	{ -1, -1, -1, -1, -1, -1, -1, -1,
	  -1, -1, -1, -1, -1, -1, -1, -1 };


#ifdef K1
/* form of a multi patch on the Kawai K1 */
struct patch_multi {
	char name[10];
	char volume;
	char single[8];
	char zonelow[8];
	char zonehigh[8];
	char poly[8];
	char rcvchan[8];
	char transpose[8];
	char tune[8];
	char level[8];
	char checksum;
} kmpatch = {
	'M','i','s','c',' ',' ',' ',' ',' ',' ',
	99,
	0,1,2,3,4,5,6,7,
	0,0,0,0,0,0,0,0,
	127,127,127,127,127,127,127,127,
	0x10, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
	0x40, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	24,24,24,24,24,24,24,24,
	50,50,50,50,50,50,50,50,
	100,100,100,100,100,100,100,100,
	0x74
};

/* send intro to K1 sysex command */
void
k1send1(function, voice)
{
	midich(0xf0);
	midich(0x40);		/* Kawai id */
	midich(0x00);		/* channel = 0 to 15 */
	midich(function);	/* function */
	midich(0x00);		/* group */
	midich(0x03);		/* machine id number of K1 */
	midich(0x00);		/* subcommand 1 = internal */
	midich(voice);	/* subcommand 2 = voice/program */
}

/* byte to K1 and update checksum */
void
mchk(c)
int c;
{
	midich(c);
	kmpatch.checksum += c & 0x7f;
}

/* k1msone - send a single voice to the K1 */
void
k1msone(iv)
int iv;
{
	int n;

	k1send1(0x20, iv);
	kmpatch.checksum = 0xa5;

	for (n = 0; n < 10; n++) mchk(kmpatch.name[n]);
	mchk(kmpatch.volume);
	for (n = 0; n < 8; n++) mchk(kmpatch.single[n]);
	for (n = 0; n < 8; n++) mchk(kmpatch.zonelow[n]);
	for (n = 0; n < 8; n++) mchk(kmpatch.zonehigh[n]);
	for (n = 0; n < 8; n++) mchk(kmpatch.poly[n]);
	for (n = 0; n < 8; n++) mchk(kmpatch.rcvchan[n]);
	for (n = 0; n < 8; n++) mchk(kmpatch.transpose[n]);
	for (n = 0; n < 8; n++) mchk(kmpatch.tune[n]);
	for (n = 0; n < 8; n++) mchk(kmpatch.level[n]);
	midich(kmpatch.checksum & 0x7f);
	if (readable) printf("checksum = 0x%02x\n", kmpatch.checksum & 0x7f);
	midich(MIDI_EOX);

}
/* dk1msone - show what is sent to the K1 */
void
dk1msone(iv)
int iv;
{
	int n;

	printf("kmpatch%d [] = {\n\t", iv);
	for (n = 0; n < 10; n++) printf("'%c'[%d],",kmpatch.name[n],kmpatch.name[n]);
	printf("\n\t%d,\n\t", kmpatch.volume);
	for (n = 0; n < 8; n++) printf("%d,",kmpatch.single[n]);
	printf("\n\t");
	for (n = 0; n < 8; n++) printf("%d,",kmpatch.zonelow[n]);
	printf("\n\t");
	for (n = 0; n < 8; n++) printf("%d,",kmpatch.zonehigh[n]);
	printf("\n\t");
	for (n = 0; n < 8; n++) printf("0x%02x,",kmpatch.poly[n]);
	printf("\n\t");
	for (n = 0; n < 8; n++) printf("0x%02x,",kmpatch.rcvchan[n]);
	printf("\n\t");
	for (n = 0; n < 8; n++) printf("%d,",kmpatch.transpose[n]);
	printf("\n\t");
	for (n = 0; n < 8; n++) printf("%d,",kmpatch.tune[n]);
	printf("\n\t");
	for (n = 0; n < 8; n++) printf("%d,",kmpatch.level[n]);
	printf("\n}\n");

}
#endif

private void crd_init();
private void cells_init();
private void lib_init();
private void voices_init();
private void channel_init();
private void play_score();

private event_type the_score;

FILE *fp;
myputc(c) { return(putc(c,fp));}

int mywritetrack(track)
int track;
{
	play_score();
	return(1);
}

/****************************************************************************
*				    phase2
* Inputs:
*	event_type root: Root of play list
* Effect: 
*	Plays the music
****************************************************************************/

void phase2(score)
	event_type score;
{	char *recording_parms = cl_option("-r");
	void gus_max_voices(int);

	readable = (cl_nswitch(t_switches, n_t_sw) != NULL);
	sblast = (cl_nswitch(m_switches, n_m_sw) == NULL);
	if (ext_dev < 0 || !sblast) extflag = false;
	if (extflag) sblast = true;
	if (readable) sblast = false;
	initflag = (cl_nswitch(msw, nmsw) == NULL);
	if (cl_switch("-s")) use_damper = true;
	if (recording_track) {
		int i;
		recording_channel = atoi(recording_parms);
		for (i = 0; recording_parms[i] != '\0' && recording_parms[i] != ','; i++) ;
		if (recording_parms[i] == ',') recording_program =
			atoi(recording_parms + i + 1);
		if (verbose) printf("recording program %d!\n", recording_program);
		if (recording_channel < 1 || recording_channel > 16)
			recording_channel = 1;
		if (recording_program < 0 || recording_program > 127)
			recording_program = 0;
		if (verbose) printf("recording program is #%d\n", recording_program);
	}

	off_init();
	tuninginit();  
	if (sblast) cells_init();
	if (sblast) crd_init();
	if (sblast) lib_init();
	voices_init();
	if (gus_dev >= 0) {
		gus_max_voices(THESE_VOICES);
		card_info[gus_dev].nr_voices = THESE_VOICES;
	}

	/*sb_resync();*/
	channel_init();
	the_score = score;

	if (recording_track) {
		Mf_putc = myputc;
		Mf_writetrack = mywritetrack;
		if((fp = fopen("mpout.mid","w")) == 0L)
			exit(1);
		mfwrite(0, 1, Mf_division, fp);
	}
	else play_score();

	if (verbose) {
		void hist_report();
/*
		printf("\t%d cells allocated\n", stat_cell_on);
		printf("\t%d cells deallocated\n", stat_cell_off);
		printf("\t%d cells implicitly deallocated\n", stat_imp_cell_off);
		printf("\t%d cells not turned off\n", stat_not_cell_off);
*/
		printf("\n");
	    if (sb_dev >= 0)
		printf("%d sb notes terminated due to conflicts.\n", stat_imp_cell_off[sb_dev]);
	    if (gus_dev >= 0)
		printf("%d gus notes terminated due to conflicts.\n", stat_imp_cell_off[gus_dev]);

		printf("Notes on:  gus %d  sb %d  ext %d\n", stat_note_on[0],
				stat_note_on[1], stat_note_on[2]);
		printf("Notes off: gus %d  sb %d  ext %d\n", stat_note_off[0],
				stat_note_off[1], stat_note_off[2]);
		hist_report();
	}
}


void crd_init()
{
	int n;

#ifdef MIDIIN
	if (ext_dev >= 0) {
		close(seq_fd);
		if ((seq_fd=open("/dev/sequencer", O_RDWR, 0))==-1) {
			fprintf(stderr, "couldn't reopen /dev/sequencer for input\n");
			exit(1);
		}
		n = 1;
		if (drum_mode)
			if (ioctl(seq_fd, SNDCTL_SEQ_PERCMODE, &n) == -1) {
			fprintf(stderr,"trouble asking for perc mode\n");
			exit(1);
		}
	}
#endif
	n = WAKETHRESH;
	ioctl(seq_fd, SNDCTL_SEQ_TRESHOLD, &n);

	if (sb_dev >= 0) perc_mode = card_info[sb_dev].perc_mode;
	else perc_mode = 0;

/*TEST how it works with small instrument bank*/
/*bank_size = 128+16;*/
	/* and if card does not support drum mode, make sure not
	 * to use any percussion channels
	 */
	if (!drum_mode) perc_mode = 0;
	else if (!perc_mode) percsel = 0;

	if (verbose && sb_dev >= 0)
	printf("%d sb voices, %d instruments, %susing percussion mode.\n",
		card_info[sb_dev].nr_voices,
		card_info[sb_dev].instr_bank_size,
		card_info[sb_dev].perc_mode? "" : "not ");
	if (verbose && gus_dev >= 0)
	printf("%d gus voices, %d instruments, %susing percussion mode.\n",
		/*card_info[gus_dev].nr_voices*/ THESE_VOICES,
		card_info[gus_dev].instr_bank_size,
		card_info[gus_dev].perc_mode? "" : "not ");
}

private int subdrum16[16] = {
	128, 134, 142, 131, 132, 153, 133, 144,
	136, 157, 146, 169, 174, 163, 146, 159 };

void lib_init()
{	char libname[80];
	int n, v, f, num_drums, voice_size, data_size;
	int first_voice = 128;
	struct sbi_instrument instr;
	char vbuf[O3VOICESIZE];


	if (sb_dev < 0) return;

	strcpy(libname, SBDIR);
	strcat(libname, "/drums.o3");
	voice_size = O3VOICESIZE;

	if (card_info[sb_dev].instr_bank_size >= 128+47)  num_drums = 47;
	else if (card_info[sb_dev].instr_bank_size >= 128+16) num_drums = 16;
	else {
		fprintf(stderr,"not enough instruments in banksize of %d\n", card_info[sb_dev].instr_bank_size);
		v_drum = false;
		num_drums = 0;
		return;
	}
	if ((f = open(libname, O_RDONLY, 0)) == -1) {
		strcpy(libname, SBDIR);
		strcat(libname, "/drums.sb");
		voice_size = SBVOICESIZE;
		if ((f = open(libname, O_RDONLY, 0)) == -1) {
			if (verbose) fprintf(stderr,"can't find %s or %s/drums.o3 library file\n",
				libname, SBDIR);
			return;
		}
	}

	instr.device = sb_dev;

	for (v = 0; v < 47; v++) {
		if (read(f, vbuf, voice_size) != voice_size) {
			if (verbose) fprintf(stderr,"%s is a short library file\n", libname);
			close(f);
			return;
		}
		if (num_drums == 47) instr.channel = v + first_voice;
		else {
			for (n = 0; n < 16 && v + first_voice != subdrum16[n]; n++) ;
			if (n == 16) continue;
			instr.channel = n + first_voice;
		}

		if (voice_size == SBVOICESIZE) {
			instr.key = FM_PATCH;
			data_size = 11;
		}
		else if ((vbuf[49]&0x3f) == 0x3f && (vbuf[50]&0x3f) == 0x3f ) {
			instr.key = FM_PATCH;
			data_size = 11;
		}
		else {
			instr.key = OPL3_PATCH;
			data_size = 22;
		}

		instr_key[128 + v + 35] = instr.key;

		for (n = 0; n < 32; n++)
			instr.operators[n] = (n < data_size)? vbuf[SBOFFSET+n] : 0;

		if (write(seq_fd, (char*)&instr, sizeof(instr)) == -1) {
			if (verbose) fprintf(stderr,"can't load instrument %d\n", v);
			close(f);
			return;
		}
		if (num_drums == 47) {
			sb_trnsps[instr.channel] = vbuf[32];
			d_dur[instr.channel] = vbuf[33];
#ifdef XVOICE
			xvoice[instr.channel] = vbuf[34];
#endif
			dnote[instr.channel] = vbuf[35];
		}
	}
	close(f);

	strcpy(libname, SBDIR);
	strcat(libname, "/std.o3");
	voice_size = O3VOICESIZE;

	if ((f = open(libname, O_RDONLY, 0)) == -1) {
		strcpy(libname, SBDIR);
		strcat(libname, "/std.sb");
		voice_size = SBVOICESIZE;
		if ((f = open(libname, O_RDONLY, 0)) == -1) {
			if (verbose) fprintf(stderr,"can't find %s or %s/std.o3 library file\n",
				libname, SBDIR);
			return;
		}
	}
	for (v = 0; v < 128; v++) {
		if (read(f, vbuf, voice_size) != voice_size) {
			if (verbose) fprintf(stderr,"%s is a short library file\n", libname);
			close(f);
			return;
		}

		if (voice_size == SBVOICESIZE) instr_key[v] = FM_PATCH;
		else if ((vbuf[49]&0x3f) == 0x3f && (vbuf[50]&0x3f) == 0x3f )
				instr_key[v] = FM_PATCH;
		else instr_key[v] = OPL3_PATCH;

		sb_trnsps[v] = vbuf[32];
		d_dur[v] = vbuf[33];
#ifdef XVOICE
		xvoice[v] = vbuf[34];
#endif
		dnote[v] = vbuf[35];
	}
	close(f);
}

void voices_init()
{   int n;

    for (n = 0; n < num_voices; n++) {
	int v;
	if (!extflag) ext_chan[n] = 0;
	/* "ext_program" has the first program requested for each
	 * channel, or else -1 or 0 if there was no program request
	 * (0 if notes were played on the channel)
	 */
	v = program[n] - 1;
	/* if notes were played but there was no program request, use
	 * program 0, Ac. Gr. Piano, as default
	 */
	if (program[n] == 0) v = 0;
	if ((sb_dev >= 0 || gus_dev >=0) && PERCCHAN(n) && v >= 0) {
		if (verbose) {
		    printf("  channel %2d: %s percussion", n+1,
			(sb_dev >= 0)? "sb":"gus");
		    if (program[n] > 0) printf(" (%s[%d] request ignored)",
			sub_voice[program[n]-1].vname, program[n]-1);
		    printf(".\n");
		}
	}
	else if (sb_dev >= 0 && sysex[n] != NULL) {
		int i;
		struct sbi_instrument instr;

		program[n] = 240+n+1;
		instr.channel = 240+n;
		instr.device = sb_dev;
		instr.key = FM_PATCH;
		for (i = SBOFFSET; i < SBVOICESIZE; i++)
			instr.operators[i - SBOFFSET] = sysex[n][i+8];
		if (write(seq_fd, (char*)&instr, sizeof(instr)) == -1) {
			fprintf(stderr,"can't load instrument\n");
			exit(1);
		}
		if (verbose) printf("  channel %2d: sysex %s\n", n+1, sysex[n]+4+8);
	}
#ifdef K1
	/* which channels shall we send out to the K1? none if the -e flag
	 * was given (extflag is 0), no more than the max (etot keeps track),
	 * and not for a timbre the K1 doesn't have (marked -1 in the array in
	 * vname.h)
	 */
	else if (ext_chan[n]) {
		static char *pan[3] = { "right", "center", "left" };
		int etot = ext_chan[n] - 1;
		int leftright = 1;
		int solo = 0;
		int kbmode = etot? 1 : 2;
		if (ext_pan[n] != -1) {
			if (ext_pan[n] < 64) leftright = 2;
			else if (ext_pan[n] > 64) leftright = 0;
		}
		v = ext_program[etot] - 1;
		/*if (sub_voice[v].solo) solo = 2;*/
		kmpatch.poly[etot] = solo | ((kbmode&1) << 6) | (leftright << 4);
		/*kmpatch.rcvchan[etot] = (0x3f&kmpatch.rcvchan[etot]) | ((kbmode&2) << 5);*/
		/* use transposition marked in vname.h */
		kmpatch.transpose[etot] = sub_voice[v].transpose + 24;
		/* finally, the voice/timbre for the section */
		kmpatch.single[etot] = sub_voice[v].newv;
		if (verbose) {
			printf("  channel %2d: %s[%d] %sto K1 channel %d at %s.\n", n+1,
				sub_voice[v].vname, v, sub_voice[v].solo? "":"(poly) ",
				etot+1, pan[leftright]);
			if (program[n]>0 && v != program[n]-1 && sb_dev >= 0)
				printf("   (also %s[%d], etc. to %s)\n",
					sub_voice[program[n]-1].vname, program[n]-1,
					gus_voice[ program[n]-1 ].loaded? "gus":"sb");
		}
	}
#else
	else if (ext_chan[n] && v >= 0) {
		if (verbose) printf("  channel %2d: %s[%d] external.\n", n+1,
			sub_voice[v].vname, v);
	}
#endif
	else if (program[n] > 0) {
		static char *pan[3] = { "gus at right", "gus at center", "gus at left" };
		int leftright = 1;
		if (ext_pan[n] != -1) {
			if (ext_pan[n] < 64) leftright = 2;
			else if (ext_pan[n] > 64) leftright = 0;
		}
		if (verbose) {
		    printf("  channel %2d: is %s[%d] etc. on %s.\n", n+1,
			sub_voice[program[n]-1].vname, program[n]-1,
			(gus_dev >= 0 && gus_voice[program[n]-1].loaded)? pan[leftright] :
				((sb_dev >= 0)? "sb":"nothing"));
		}
	}
    }

    if (recording_track) {
#ifdef K1
/* The first channel has been reserved for the player; initialize
 * it now to respond to the keyboard and use the program specified
 * on the command line, if any.  Tone down the volume a little.
 */
	int kbmode = 0;
	int prog = sub_voice[recording_program].newv;
	if (prog < 0) prog = 0;
	kmpatch.single[0] = prog;
	kmpatch.rcvchan[0] = (0x3f&kmpatch.rcvchan[0]) | ((kbmode&2) << 5);
	kmpatch.poly[0] = 0 | ((kbmode&1) << 6) | (1 << 4);
	kmpatch.transpose[0] = sub_voice[recording_program].transpose + 24;
	kmpatch.level[0] = 90;
#else
	f_program(0, recording_channel, 1, recording_program);
#endif
    }

#ifdef K1
    if (extflag) {
#ifdef MIDIIN
	unsigned char k1ack[7] = { 0xf0, 0x40, 0x00, 0x40, 0x00, 0x03, 0xf7 };
	int n = 0, tries = 5;

    while (tries--) {
#endif
	/*readable = true;*/
	if (readable) dk1msone(64);
	k1msone(64);
	sbflush();
	usleep(100000);
#ifdef MIDIIN
	if (readable) printf("  (k1 answering: ");
	for (n = 0; n < 7; n++) {
		int c = inonenb();
		if (c == MIDI_CTRL) {
			(void)inonenb(); (void)inonenb();
			c = inonenb();
		}
		if (c == -1) {
			int n;
			if (verbose)
			printf("timed out waiting for k1 to acknowledge patch\n");
			close(seq_fd);
			if ((seq_fd=open("/dev/sequencer", O_RDWR, 0))==-1) {
				perror("/dev/sequencer");
				exit(-1);
			}
			n = 1;
			if (drum_mode)
				if (ioctl(seq_fd, SNDCTL_SEQ_PERCMODE, &n) == -1) {
				fprintf(stderr,"trouble asking for perc mode\n");
				exit(1);
			}
			n = WAKETHRESH;
			ioctl(seq_fd, SNDCTL_SEQ_TRESHOLD, &n);
			break;
		}
		if (readable) printf(" 0x%02x", c);
		if (c != k1ack[n]) {
			while (midipending()) {
				c = inonenb();
				if (readable) printf(" 0x%02x", c);
			}
			if (verbose && !readable)
			printf("k1 did not correctly acknowledge my patch on try %d\n", 5-tries);
			/*(void)ioctl(seq_fd, SNDCTL_SEQ_RESET, 0);*/
			break;
		}
	}
	if (readable) printf(")\n");
	/*readable = false;*/
	if (n == 7) break;
	if (!tries) {
		printf("cannot send patch to k1\n");
		/*(void)ioctl(seq_fd, SNDCTL_SEQ_RESET, 0);*/
		exit(1);
	}
	else {
		usleep(100000);
		while (midipending()) (void)midigetc();
	}
    }
#endif
	midich(PROGRAM + 0);
	midich(64);
	sbflush();
	usleep(200000);
#ifdef MIDIIN
	while(midipending()) {
		int c = midigetc();
		if (verbose) printf(" k1 says 0x%02x for some reason\n", c);
	}
#endif

	if (!recording_track) {
		int n;
		close(seq_fd);
		if ((seq_fd=open("/dev/sequencer", O_WRONLY, 0))==-1) {
			perror("/dev/sequencer");
			exit(-1);
		}
		n = WAKETHRESH;
		ioctl(seq_fd, SNDCTL_SEQ_TRESHOLD, &n);
	}

    }
#endif
}


void channel_init()
{   int i;

    /* Initialize all midi channels with reasonable start values: */
    for (i = 1; i <= num_voices; i++) {
	int card;
	int d = ext_chan[i-1];
	if (d) card = 0;
	else if (sb_dev >= 0) card = sb_dev;
	else if (gus_dev >= 0) card = gus_dev;
	else card = -1;
	program[i-1] = ext_program[i-1];
	if (program[i-1] <= 0) ext_program[i-1] = program[i-1] = 1;
	bend[i-1] = 1 << 13;
	if (!initflag) continue;
	f_program(card, 0, i, program[i-1]);
	f_bend(card, 0, i, 1 << 13);
	f_touch(card, 0, i, 0);
	f_ctrl(card, 0, i, PORTARATE, 99);
	f_ctrl(card, 0, i, PORTASWITCH, 0);
	f_ctrl(card, 0, i, MODWHEEL, 0);
	f_ctrl(card, 0, i, FOOT, 99);
	f_ctrl(card, 0, i, VOLUME, 90);
	if (!d || ext_dev < 0) continue;
	f_program(card, d, i, program[i-1]);
	f_bend(card, d, i, 1 << 13);
	f_touch(card, d, i, 0);
	f_ctrl(card, d, i, PORTARATE, 99);
	f_ctrl(card, d, i, PORTASWITCH, 0);
	f_ctrl(card, d, i, MODWHEEL, 0);
	f_ctrl(card, d, i, FOOT, 99);
	f_ctrl(card, d, i, VOLUME, 116);
    }
}

#ifdef MIDIIN

unsigned long getdelta()
{	static double last_ticks = 0;
	double ticks = ((double)sb_time * 10000 * (double)Mf_division) / (double)Mf_currtempo;
	unsigned long delta_ticks = (unsigned long)(ticks - last_ticks);
	last_ticks = ticks;
	return(delta_ticks);
}

void listen()
{
    while (midipending()) {
	if (recording_track) midimessage();
	else (void)midigetc();
    }
}
#endif

void play_score()
{   event_type event;

    event = the_score;

#ifdef MIDIIN
    if (recording_track) {
	unsigned char data[4];
	(void)mf_write_tempo(0, Mf_currtempo);
	data[0] = recording_program;
	(void)mf_write_midi_event(getdelta(),program_chng,recording_channel-1,data,1);
    }
#endif

    if (sblast) sb_resync();

    while (event != NULL) { /* play it, Sam */
	int d = event->ndest;
	int card = event->ncard;
	int chan = vc_voice(event->nvoice);
#ifdef TRY_VIBRATO
	unsigned long new_time = event->ntime;
#else
	time = event->ntime;
#endif
	if (!ext_chan[chan]) d = 0;
	if (!d && card < 0) {
		event = event->next;
		continue;
	}

#ifdef TRY_VIBRATO
	while (time < new_time) {
		fm_vibrate(time);
		time ++;
		note_offs(time);
	}
#else
	note_offs(time);
#endif

#ifdef MIDIIN
	listen();
#endif

	if (is_note(event)) { /* play a note */
		int prog = event->u.note.nprogram;
		int pitch = event->u.note.npitch;
		int vel = event->u.note.nloud;
		int dur = event->u.note.ndur;

		/* this is to give time for note releases */
		if (!d && card == gus_dev && !PERCCHAN(chan) ) {
			int grace = gus_voice[ prog-1 ].sustain;
			if (grace > 118 || grace < 1) grace = 0;
			if (grace) grace = (118-grace)/4;
			dur -= grace;
			if (dur < 2) dur = 2;
		}

		if (!d && card == sb_dev && pitch != NO_PITCH) {
			if (!card_info[sb_dev].perc_mode && PERCCHAN(chan)) {
				if (d_dur[128 + pitch - 35])
					dur = d_dur[128 + pitch - 35];
			}
			if (!PERCCHAN(chan)) {
				if (d_dur[prog-1]) dur = d_dur[prog-1];
				if (dnote[prog-1]) pitch = dnote[prog-1];
				if (sb_trnsps[prog-1]) pitch += sb_trnsps[prog-1] - 64;
			}
		}
		if (pitch < 0 || pitch > 127 || dur < 1) {
			event = event->next;
			continue;
		}

		/* check for correct program (preset) */
		if ( (d || !PERCCHAN(chan)) && prog != program[chan]) {
			f_program(card, d, chan+1, prog);
			 program[chan] = prog;
		}
		/* if it is a note (not a rest) play it */
		if (pitch != NO_PITCH) {
			int cell = 0;
			if (!d) cell = new_cell(card, time, chan, prog-1, pitch, vel);
			if (cell == -1) {
				event = event->next;
				continue;
			}
			f_note(card, d, chan+1, cell, pitch, vel, time);
			off_schedule(card, d, time + dur, chan, cell, pitch, time);
#ifdef XVOICE
			if (!d && sb_dev >= 0 && card == sb_dev) {
			  int xprogram = xvoice[prog-1];
			  if (xprogram) {
			    cell = new_cell(card, time, chan, prog-1, pitch, vel);
			    if (cell == -1) {
				event = event->next;
				continue;
			    }
			    f_program(card, d, chan+1, xprogram);
			    f_note(card, d, chan+1, cell, pitch, vel, time);
			    off_schedule(card, d, time + dur, chan, cell, pitch, time);
			    f_program(card, d, chan+1, prog);
			  }
			}
#endif
		}
	} else {	/* send control info */
		int val = event->u.ctrl.value;
		switch (vc_ctrl(event->nvoice)) {
			case 1: f_ctrl(card, d, chan + 1, PORTARATE, val);
				break;
			case 2: f_ctrl(card, d, chan + 1, PORTASWITCH, val);
				break;
			case 3: f_ctrl(card, d, chan + 1, MODWHEEL, val);
				break;
			case 4: f_touch(card, d, chan + 1, val);
				break;
			case 5: if (use_damper) f_ctrl(card, d, chan + 1,
					     FOOT, val);
				break;
			case 6: f_bend(card, d, chan + 1, val);
				break;
			/* when d=0 should I also set volume external channel? */
			case 7: f_ctrl(card, d, chan + 1, VOLUME, val);
				main_volume[chan] = val;
				break;
			case 8: f_ctrl(card, d, chan + 1, PAN, val);
				ext_pan[chan] = val;
				break;
			case 9: f_ctrl(card, d, chan + 1, EXPRESSION, val);
				expression[chan] = val;
				break;
			/* pass through any other controls */
			case 15: f_ctrl(card, d, chan + 1,
					     event->u.ctrl.control, val);
				if (event->u.ctrl.control == 91)
					reverberation[chan] = val;
				break;
			default: break;
		}
	}

	event = event->next;
    } /* play it, Sam */

    note_offs(MAXTIME);

    if (sblast) {
	int room;
	sbflush();
#ifdef MIDIIN
	listen();
#endif
	while ( (ioctl(seq_fd,SNDCTL_SEQ_GETOUTCOUNT,&room) != -1) && (room < 512)) {
		usleep(100000);
#ifdef MIDIIN
		listen();
	}
	if (recording_track)
		(void)mf_write_meta_event(getdelta(),end_of_track,NULL,0);
#else
	}
#endif
	if (gus_dev >= 0) sleep(1);
    }
}


/* noteoff.c -- this module keeps track of pending note offs for adagio */

/*****************************************************************************
*	    Change Log
*  Date	    | Change
*-----------+-----------------------------------------------------------------
* 31-Dec-85 | Created changelog
* 31-Dec-85 | Add c:\ to include directives
*  1-Jan-86 | Declare malloc char * for lint consistency
* 21-Jan-86 | note_offs can now turn off more than one note per call
*****************************************************************************/


/* off_type is a structure containing note-off information */

typedef struct off_struct {
    unsigned long when;
    int voice;
    int pitch;
    char dest;
    char card;
    int cell;
    unsigned long stime;
    struct off_struct *next;
} *off_type;

private off_type free_off;		/* free list of off_type structures */
private off_type off_events = NULL;	/* active list */

/****************************************************************************
*	Routines declared in this module
****************************************************************************/

private off_type	off_alloc();
private void		off_free();

/****************************************************************************
*				note_offs
* Inputs:
*	long time: the current time
* Outputs:
*	return true if off list has more notes 
* Effect: turn off notes if it is time 
* Assumes:
* Implementation:
*	Find scheduled note off events in off_events, compare with time
****************************************************************************/

private boolean note_offs(mtime)
unsigned long mtime;
{
    off_type temp;
    while (off_events != NULL && (time=off_events->when) <= mtime) {
	f_note(off_events->card, off_events->dest, (off_events->voice) + 1,
		off_events->cell, off_events->pitch, 0, off_events->stime);
	temp = off_events;
	off_events = off_events->next;
	off_free(temp);
    }
    if (mtime < MAXTIME) time = mtime;
    return (off_events != NULL);
}

/****************************************************************************
*				off_alloc
* Outputs:
*	returns off_type: an allocated note off structure
* Effect:
*	allocates a structure using malloc
****************************************************************************/

private off_type off_alloc()
{
    return (off_type) malloc(sizeof(struct off_struct));
}

/****************************************************************************
*				off_free
* Inputs:
*	off_type off: a structure to deallocate
* Effect: 
*	returns off to freelist
****************************************************************************/

private void off_free(off)
    off_type off;
{
    off->next = free_off;
    free_off = off;
}

/****************************************************************************
*				off_init
* Effect: initialize this module
* Assumes:
*	only called once, otherwise storage is leaked
****************************************************************************/

private void off_init()
{
    int i;
    for (i = 0; i < 50; i++) off_free(off_alloc());
}

/****************************************************************************
*				off_schedule
* Inputs:
*	long offtime: time to turn note off
*	int voice: the midi channel
*	int pitch: the pitch
* Effect: 
*	schedules a note to be turned off
* Assumes:
*	note_offs will be called frequently to actually turn off notes
****************************************************************************/

private void off_schedule(card, dest, offtime, voice, cell, pitch, stime)
    unsigned long offtime;
    int card, dest, voice, cell, pitch;
    unsigned long stime;
{
    off_type off, ptr, prv;
    /* allocate off */
    if ((off = free_off) == NULL) {
	off = off_alloc();
    } else free_off = off->next;

    if (off == NULL) {
	fprintf(stderr, "out of space for note off events");
	exit(1);
    }

    off->when = offtime;
    off->voice = voice;
    off->pitch = pitch;
    off->dest = dest;
    off->card = card;
    off->cell = cell;
    off->stime = stime;
    /* insert into list of off events */
    ptr = off_events;
    if (ptr == NULL || offtime <= ptr->when) {
	off->next = ptr;
	off_events = off;
    } else {
	while (ptr != NULL && offtime > ptr->when) {
	    prv = ptr;
	    ptr = ptr->next;
	}
	prv->next = off;
	off->next = ptr;
    }
/*
 *    printf("off_schedule(%ld, %d, %d): \n", offtime, voice, pitch);
 *    for (ptr = off_events; ptr != NULL; ptr = ptr->next) {
 *	printf("    %ld: %d, %d\n", ptr->when, ptr->voice, ptr->pitch);
 *    }
 */
}

AWriteVarLen (value)
register long value;
{
	register long buffer;

	buffer = value & 0x7f;
	while ((value >>= 7) > 0)
	{
		buffer <<= 8;
		buffer |= 0x80;
		buffer += (value & 0x7f);
	}

	while (true)
	{
		putchar(buffer);
		if (buffer & 0x80)
			buffer >>= 8;
		else
			break;
	} 
}

deltatime()
{
	float csecs = (float)(time - lasttime);

	AWriteVarLen( (long)(((csecs * 10.0) / 4.0 * 96) / 120) );
	lasttime = time;
}

/****************************************************************************
*				   f_note
* Inputs:
*	int channel: midi channel on which to send data
*	int pitch: midi pitch code
*	int velocity: velocity with which to sound it (0=> release)
* Effect: 
*	Prints a midi note-play request out
****************************************************************************/

private void f_note(card, d, channel, cell, pitch, velocity, stime)
    int card, d, channel, cell, pitch, velocity;
    unsigned long stime;
{
    if (readable)
    printf("Time=%d  Note %s, chan=%d pitch=%d vol=%d\n",
	    time, velocity? "on":"off", channel, pitch, velocity);
    else if (sblast) fm_noteon(card, d, channel-1, cell, pitch, velocity, stime);
    else {
	deltatime();
	putchar(NOTEON + channel - 1);
	putchar(pitch);
	putchar(velocity);
    }

    if (user_scale) {
	/* check for correct pitch bend */
	if ((pit_tab[pitch].pbend != bend[MIDI_CHANNEL(channel)]) &&
	    (velocity != 0)) {
	    f_bend(card, d, channel, pit_tab[pitch].pbend);
	    bend[channel] = pit_tab[pitch].pbend;
	}
	pitch = pit_tab[pitch].ppitch;
    }
}

/****************************************************************************
*				   f_bend
* Inputs:
*	int channel: midi channel on which to send data
*	int value: pitch bend value
* Effect: 
*	Prints a midi pitch bend message
****************************************************************************/

private void f_bend(card, d, channel, value)
    int card, d, channel, value;
{
    int i;

    if (readable)
	printf("Time=%d  Pitchbend, chan=%d value=%d\n",
		time, channel, value);
    else if (sblast) {
	if (d) {
		midisync();
		midicmdch(PITCHBEND + d - 1);
		midich(value & 0x7f);
		midich((value>>7) & 0x7f);
	}
	/*else*/ fm_bend(card, channel - 1, value - 8192);
    }
    else {
	deltatime();
	putchar(PITCHBEND + channel - 1);
	putchar(value & 0x7f);
	putchar((value>>7) & 0x7f);
    }

	bend[MIDI_CHANNEL(channel)] = value;
}

/****************************************************************************
*				   f_ctrl
* Inputs:
*	int channel: midi channel on which to send data
*	int control: control number
*	int value: control value
* Effect: 
*	Prints a midi control change message
****************************************************************************/

private void f_ctrl(card, d, channel, control, value)
    int card, d, channel, control, value;
{
    if (readable)
	printf("Time=%d  Parameter, chan=%d ctrl=%d value=%d\n", 
		time, channel, control, value);
    else if (sblast) fm_ctrl(card, d, channel-1, control, value);
    else {
	deltatime();
	putchar(CONTROLLER + channel - 1);
	putchar(control);
	putchar(value);
    }
}

/****************************************************************************
*				 f_program
* Inputs:
*	int channel: Channel on which to send midi program change request
*	int program: Program number to send (decremented by 1 before
*			being sent as midi data)
* Effect: 
*	Prints a program change request out the channel
****************************************************************************/

private void f_program(card, d, channel, program)
    int card, d;		/* destination */
    int channel;	/* midi channel */
    int program;	/* the program number */
{
    if (readable)
	printf("Time=%d  Program, chan=%d program=%d\n",
		time, channel, program);
    else if (sblast) fm_program(card, d, channel-1, program-1);
    else {
	deltatime();
	putchar(PROGRAM + channel - 1);
	putchar(program - 1);
    }
}

/****************************************************************************
*				   f_touch
* Inputs:
*	int channel: midi channel on which to send data
*	int value: control value
* Effect: 
*	Prints a midi after touch message
****************************************************************************/

private void f_touch(card, d, channel, value)
    int card, d, channel, value;
{
    if (readable)
	printf("Time=%d  Channel pressure, chan=%d value=%d\n",
		time, channel, value);
    else if (sblast) {
	if (d) {
		midisync();
		midicmdch(CHANPRESSURE + d - 1);
		midich(value);
	}
	else fm_touch(card, channel-1, value);
    }
    else {
	deltatime();
	putchar(CHANPRESSURE + channel - 1);
	putchar(value);
    }
}

/*****************************************************************
*			set_pitch_default
*****************************************************************/
private void set_pitch_default()
{
    int i;

    for (i = 0; i < 128; i++) {
	pit_tab[i].pbend = 8192;
	pit_tab[i].ppitch = i;
    }
}

/*****************************************************************
*			read_tuning
*****************************************************************/

private void read_tuning(filename)
    char *filename;
{
    int index, pit, lineno = 0;
    float bend;
    FILE *fpp;

    user_scale = true;
    set_pitch_default();
    fpp = fileopen(filename, "tun", "r", "Tuning definition file");
    while ((fscanf(fpp, "%d %d %f\n", &index, &pit, &bend) > 2) &&
	   (lineno < 128)) {
	lineno++;
	if (index >= -12 && index <= 115) {
	    pit_tab[index+12].pbend = (int)(8192 * bend/100 + 8192);
	    pit_tab[index+12].ppitch = pit;
	}
    }
}


/****************************************************************************
*				   tunginginit
* Effect: 
* Read tuning file
****************************************************************************/

private void tuninginit()
{
    int i;
    char *filename;

    filename = cl_option("-tune");
    if (filename != NULL) {
	    read_tuning(filename);
    }
/*
    if (user_scale) {
	for (i = 0; i < num_voices; i++) {
	    f_bend(0, i+1, 8192);
	    bend[i] = 8192;
	}
    }
*/

}

/*
 * some of following code was adapted from:
 * 
 * fmplay by Hannu Savolainen (hsavolai@cs.helsinki.fi)
 * Modifications, bugfixes, and ANSIfied by Rob Hooft (hooft@chem.ruu.nl)
 *
 */
#include <sys/ultrasound.h>

#define Bit8 0
#define Bit16 4 
#define LoopOff 0
#define LoopOn 8
#define UniDir 0
#define BiDir 16
#define Forw 0
#define Backw 64
#define Up 0
#define Down 64

static int chn_pgm[MAXCARDS][16];
static int chn_bend[MAXCARDS][16];
static int chn_press[MAXCARDS][16];

#define N_CELL	32
static int cell_alloc[MAXCARDS][N_CELL];
static long cell_time[MAXCARDS][N_CELL];
static long cell_endtime[MAXCARDS][N_CELL];
static int cell_chan[MAXCARDS][N_CELL];
static int cell_prog[MAXCARDS][N_CELL];
static int cell_pitch[MAXCARDS][N_CELL];
static int cell_vel[MAXCARDS][N_CELL];
static int cell_hist[MAXCARDS][N_CELL];
#ifdef TRY_VIBRATO
static int cell_vibrato[MAXCARDS][N_CELL];
#endif

void
hist_report()
{	int i;

	if (sb_dev >= 0) {
		printf("fm cells: |");
		for (i = 0; i < card_info[sb_dev].nr_voices; i++)
			printf("%4d |", cell_hist[sb_dev][i]);
		printf("\n          |");
		for (i = 0; i < card_info[sb_dev].nr_voices; i++)
			printf("%4d |", i);
		printf("\n");
	}
	if (gus_dev >= 0) {
		printf("\nwv cells: |");
		for (i = 0; i < card_info[gus_dev].nr_voices / 2; i++)
			printf("%4d |", cell_hist[gus_dev][i]);
		printf("\n          |");
		for (i = 0; i < card_info[gus_dev].nr_voices / 2; i++)
			printf("%4d |", i);
		printf("\n           -----------------------------------------------");
		printf("\n          |");
		for (i = card_info[gus_dev].nr_voices / 2; i < card_info[gus_dev].nr_voices; i++)
			printf("%4d |", cell_hist[gus_dev][i]);
		printf("\n          |");
		for (i = card_info[gus_dev].nr_voices / 2; i < card_info[gus_dev].nr_voices; i++)
			printf("%4d |", i);
		printf("\n");
	}
}

void
cells_init()
{	int i, j;
	/*void gus_tune(int);*/

	for (i = 0; i < MAXCARDS; i++) {
		for (j = 0; j < N_CELL; j++) {
			cell_alloc[i][j] = false;
			cell_prog[i][j] = cell_endtime[i][j] = cell_time[i][j] =
				cell_chan[i][j] = cell_pitch[i][j] = -1;
		}
	}
}

int
new_cell(int card, unsigned long stime, int chan, int prog, int pitch, int vel)
{	int i, best = 0, bperc = 0, perc = 0, oldest = 0, same = -1;
	int o3_mode = 0;

	/* sb cells not used up in perc mode */
	if (card == sb_dev && card_info[card].perc_mode && PERCCHAN(chan)) return(0);

	if (card == sb_dev && instr_key[ (PERCCHAN(chan))? pitch+128 : prog ] == OPL3_PATCH)
		o3_mode = 1;

	for (i = 0; i < card_info[card].nr_voices; i++) {
		if (o3_mode && i > 5) break;
		if (cell_chan[card][i] == chan && cell_prog[card][i] == prog &&
			sub_voice[ cell_prog[card][i] ].solo )
				same = i;
		if (cell_alloc[card][i]) {
			if (cell_time[card][i] < cell_time[card][oldest]) oldest = i;
			if (PERCCHAN(cell_chan[card][i])) {
				if (perc && cell_time[card][i] < cell_time[card][bperc])
					bperc = i;
				else {
					perc = 1;
					bperc = i;
				}
			}
		}
		else if (cell_endtime[card][i] < cell_endtime[card][best]) best = i;
	}
	if (cell_alloc[card][best]) best = oldest;
	if (cell_alloc[card][best] && perc) best = bperc;
	if (same >= 0 && reverberation[chan] < 127) best = same;
	if (cell_alloc[card][best]) {
		stat_imp_cell_off[card]++;
		fm_noteon(card, 0, cell_chan[card][best], best, cell_pitch[card][best], 0,
			(unsigned long)cell_time[card][best]);

	}
	cell_time[card][best] = (long)stime;
	cell_endtime[card][best] = MAXTIME;
	if (cell_time[card][best] < 0) fprintf(stderr, "internal error in new_cell()\n");
	cell_chan[card][best] = chan;
	if (PERCCHAN(chan)) {
		if (card == sb_dev) {
			if (card_info[sb_dev].instr_bank_size <= 128 + 81 - 35)
				cell_prog[card][best] = d_voice[pitch - 35].dv;
			else cell_prog[card][best] = pitch + 128 - 35;
		}
		else cell_prog[card][best] = pitch + 128;
	}
	else cell_prog[card][best] = prog;
	cell_pitch[card][best] = pitch;
	cell_vel[card][best] = vel;
	cell_alloc[card][best] = true;
#ifdef TRY_VIBRATO
	cell_vibrato[card][best] = 0;
#endif
	cell_hist[card][best]++;
	stat_cell_on++;
	return(best);
}

void fm_drumon(int drum, int vol)
{
	buf[0] = SEQ_DRUMON;
	buf[1] = 0;
	buf[2] = drum;
	buf[3] = vol;
	sbwrite(buf);
}

void fm_drumoff(int drum, int vol)
{
	buf[0] = SEQ_DRUMOFF;
	buf[1] = 0;
	buf[2] = drum;
	buf[3] = vol;
	sbwrite(buf);
}

#include "vol2.h"

void
gus_max_voices(int num)
{
	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_NUMVOICES;
	buf[3] = 0;
	*(unsigned short*)&buf[4] = num;
	buf[6] = buf[7] = 0; 
	sqwrite(buf);
}

void
card_bend(int card, int chan, int cell)
{
	buf[0] = SEQ_EXTENDED;
	buf[1] = SEQ_CONTROLLER;
	buf[2] = card;
	buf[3] = cell;
	buf[4] = CTRL_PITCH_BENDER;
#ifdef TRY_VIBRATO
	*(short *)&buf[5] = chn_bend[card][chan] + cell_vibrato[card][cell];
#else
	*(short *)&buf[5] = chn_bend[card][chan];
#endif
	buf[7] = 0;
	sqwrite(buf);
}

#ifdef TRY_VIBRATO
void
fm_vibrate(unsigned long ctime)
{	int prog, chan, curr_bend, i, vs, period, depth;

	period = 8;
	depth = 300;
	if (gus_dev >= 0) for (i = 0; i < card_info[gus_dev].nr_voices; i++)
	    if (cell_alloc[gus_dev][i]) {
		chan = cell_chan[gus_dev][i];
		if (PERCCHAN(chan)) continue;
		prog = cell_prog[gus_dev][i];
		if (prog != 68 && prog != 73) continue;
		curr_bend = chn_bend[gus_dev][chan];
		vs = ctime - cell_time[gus_dev][i];
		if (vs < 1) continue;
		if ( (vs%2) == 0 ) continue;
		vs = (vs % period);
		if (vs > period/4) {
			if (vs < (3*period)/4) vs = period/2 - vs;
			else vs = period - vs;
		}
		vs = (vs*depth)/(period/4);
		cell_vibrato[gus_dev][i] = vs;
		card_bend(gus_dev, chan, i);
	}
}
#endif

void
fm_bend(int card, int chan, int value)
{
	int i;

	if (sb_dev >= 0) {
		chn_bend[sb_dev][chan] = value;
		for (i = 0; i < card_info[sb_dev].nr_voices; i++)
			if (cell_alloc[sb_dev][i] && cell_chan[sb_dev][i] == chan)
				card_bend(sb_dev, chan, i);
	}
	if (gus_dev >= 0) {
		chn_bend[gus_dev][chan] = value + GUS_TUNING;
		for (i = 0; i < card_info[gus_dev].nr_voices; i++)
			if (cell_alloc[gus_dev][i] && cell_chan[gus_dev][i] == chan)
				card_bend(gus_dev, chan, i);
	}
}


void
card_touch(int card, int chan, int cell)
{
	buf[0] = SEQ_EXTENDED;
	buf[1] = SEQ_AFTERTOUCH;
	buf[2] = card;
	buf[3] = cell;
	buf[4] = chn_press[card][chan];
	buf[5] = buf[6] = buf[7] = 0;
	sqwrite(buf);
}

void
fm_touch(int card, int chan, int value)
{
	int i;

	if (sb_dev >= 0) {
		chn_press[sb_dev][chan] = value;
		for (i = 0; i < card_info[sb_dev].nr_voices; i++)
			if (cell_alloc[sb_dev][i] && cell_chan[sb_dev][i] == chan)
				card_touch(sb_dev, chan, i);
	}
	if (gus_dev >= 0) {
		chn_press[gus_dev][chan] = value + GUS_TUNING;
		for (i = 0; i < card_info[gus_dev].nr_voices; i++)
			if (cell_alloc[gus_dev][i] && cell_chan[gus_dev][i] == chan)
				card_touch(gus_dev, chan, i);
	}
}

void
gus_vol(int chan, int prog, int cell, int vol)
{
	/*vol += expression[chan];*/
	if (vol < 0 || vol > 255) {
		fprintf(stderr, "vol out of range\n");
		exit(1);
	}
	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_VOICEVOL;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = vol2vol[vol] +
		5*expression[chan] +
		2*main_volume[chan] +
		8*(gus_voice[prog].volume-64);
	buf[6] = buf[7] = 0; 
	sqwrite(buf);
}


void
gus_rampon(int chan, int prog, int cell, int vol)
{
	int top = gus_voice[prog].rtop;
	int bot = gus_voice[prog].rbot;

	if (!gus_voice[prog].rrate) return;

	top = vol + top;
	if (top > 127) top = 127;
	bot = top - (127 - bot);
	if (bot < 0) bot = 0;

	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_RAMPRANGE;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = vol2vol[bot] +
		5*expression[chan] +
		2*main_volume[chan] +
		8*(gus_voice[prog].volume-64);
	*(unsigned short*)&buf[6] = vol2vol[top] +
		5*expression[chan] +
		2*main_volume[chan] +
		8*(gus_voice[prog].volume-64);
	sqwrite(buf);

	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_RAMPRATE;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = gus_voice[prog].rscale;
	*(unsigned short*)&buf[6] = gus_voice[prog].rrate;
	sqwrite(buf);
	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_RAMPON;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = gus_voice[prog].rampmode;
	*(unsigned short*)&buf[6] = 0;
	sqwrite(buf);
}

void
gus_offrampon(int chan, int prog, int cell, int vol)
{	int rate = gus_voice[prog].sustain;
	int scale = 3;

#ifdef TRY_REVERB
	if (reverberation[chan] >= 0) {
		rate = (137 - reverberation[chan] + rate) / 2;
		if (rate < 1 || rate > 118) return;
	}
	/*rate = ( ((128 - reverberation[chan]) / 2) + rate ) / 2;*/
#endif
	if (rate > 63) {
		rate -= 55;
		scale = 2;
	}

	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_RAMPRANGE;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = vol2vol[0] +
		5*expression[chan] +
		2*main_volume[chan] +
		8*(gus_voice[prog].volume-64);
	*(unsigned short*)&buf[6] = vol2vol[vol] +
		5*expression[chan] +
		2*main_volume[chan] +
		8*(gus_voice[prog].volume-64);
	sqwrite(buf);
	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_RAMPRATE;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = scale;
	*(unsigned short*)&buf[6] = rate;
	sqwrite(buf);

	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_RAMPON;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = Down;
	*(unsigned short*)&buf[6] = 0;
	sqwrite(buf);

}


void
gus_rampoff(int cell)
{
	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_RAMPOFF;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = 0;
	*(unsigned short*)&buf[6] = 0;
	sqwrite(buf);
}

void
gus_pan(int cell, int pan)
{
	pan = ((pan+1) >> 3) - 1;
	if (pan < 0) pan = 0;
	if (pan > 15) {
		printf("warning: pan out of range\n");
		return;
	}
	buf[0] = SEQ_PRIVATE;
	buf[1] = gus_dev;
	buf[2] = _GUS_VOICEBALA;
	buf[3] = cell;
	*(unsigned short*)&buf[4] = pan;
	*(unsigned short*)&buf[6] = 0;
	sqwrite(buf);
}

void
fm_noteon(int card, int d, int chan, int cell, int pitch, int vol, unsigned long stime)
{
	int dv, nominal_pitch;

	midisync();

	if (d) {
		if (vol) stat_note_on[2]++;
		else stat_note_off[2]++;
		midicmdch(NOTEON + d - 1);
		midich(pitch);
		midich(vol);
		return;
	}

	if (card == sb_dev && vol && main_volume[chan] >= 0) {
		float vol_factor = (float)main_volume[chan];
		if (expression[chan] >= 0) vol_factor *=
			((float)expression[chan]/128.0);
		vol = vol * (vol_factor/128.0);
	}

	nominal_pitch = pitch;
	dv = chn_pgm[card][chan];

	if (card == sb_dev && PERCCHAN(chan)) {
		if (card_info[card].perc_mode) {
			if (!vol) fm_drumoff(pitch, vol);
			else fm_drumon(pitch, vol);
			return;
		}
		else if (v_drum) {
			if (pitch >= 35 && pitch <= 81) {
				if (card_info[sb_dev].instr_bank_size <= 128 + 81 - 35) {
					dv = d_voice[pitch - 35].dv;
					pitch = d_voice[pitch - 35].dnote;
				} else {
					dv = 128 + pitch - 35;
					pitch = dnote[dv];
				}
			}
			else {
			/* should not happen */
				dv = 130;
				pitch = 50;
			}
		}
	}
	else if (card == gus_dev && PERCCHAN(chan)) {
		if (gus_voice[pitch+128].loaded) {
			dv = pitch+128;
			pitch = gus_voice[dv].lowest - 12;
		}
		else return;
	}

	if (!vol) {
		if (!cell_alloc[card][cell]
		    || cell_time[card][cell] != (long)stime
		    || cell_chan[card][cell] != chan
		    || cell_pitch[card][cell] != nominal_pitch) {
			stat_not_cell_off++;
			return;
		}
		fm_noteoff(card,chan,dv,cell,pitch,vol,stime);
		return;
	}
	buf[0] = SEQ_EXTENDED;
	buf[1] = SEQ_PGMCHANGE;
	buf[2] = card;
	buf[3] = cell;
	buf[4] = dv;
	buf[5] = buf[6] = buf[7] = 0;
	sqwrite(buf);

	if (card == gus_dev) gus_rampoff(cell);
	if (chn_bend[card][chan]) card_bend(card, chan, cell);
	if (chn_press[card][chan]) card_touch(card, chan, cell);

	stat_note_on[card]++;
	buf[0] = SEQ_EXTENDED;
	buf[1] = SEQ_NOTEON;
	buf[2] = card;
	buf[3] = cell;
	buf[4] = pitch;
	buf[5] = vol;
	buf[6] = buf[7] = 0;
	sqwrite(buf);
	if (card == gus_dev) {
		gus_vol(chan, dv, cell, vol);
		gus_rampon(chan, dv, cell, vol);
	}

	if (ext_pan[chan] >= 0) gus_pan(cell, ext_pan[chan]);
	else gus_pan(cell, 64);
}

void fm_noteoff(int card, int chan, int prog, int cell, int pitch, int vol, unsigned long stime)
{
	midisync();
	stat_note_off[card]++;
	if (card == gus_dev && gus_voice[prog].sustain)
		gus_offrampon(chan, prog, cell, cell_vel[card][cell]);
	else {
		buf[0] = SEQ_EXTENDED;
		buf[1] = SEQ_NOTEOFF;
		buf[2] = card;
		buf[3] = cell;
		buf[4] = pitch;
		buf[5] = vol;
		buf[6] = buf[7] = 0;
		sqwrite(buf);
	}
	cell_alloc[card][cell] = false;
	cell_endtime[card][cell] = (long)stime;
}

void
fm_ctrl(int card, int d, int chan, int control, int value)
{
	int i;

	if (d) {
#ifdef K1
/* no expression controller for K1, so use volume */
		if (control == EXPRESSION) {
			control = VOLUME;
			value = (main_volume[chan] * value)/128;
		}
#endif
		midisync();
		midicmdch(CONTROLLER + d - 1);
		midich(control);
		midich(value);
		return;
	}
	if (card != gus_dev) return;

	if (control == EXPRESSION) 
		for (i = 0; i < card_info[card].nr_voices; i++)
			if (cell_alloc[card][i] && cell_chan[card][i] == chan)
				gus_vol(chan, cell_prog[card][i], i, cell_vel[card][i]);

	if (control == PAN) 
		for (i = 0; i < card_info[card].nr_voices; i++)
			if (cell_alloc[card][i] && cell_chan[card][i] == chan)
				gus_pan(i, value);
}

void fm_program(int card, int d, int chan, int program)
{
	chn_pgm[card][chan] = program;
#ifndef K1
/* K1 can't remember channel programs */
	if (d) {
		midicmdch(PROGRAM + d);
		midich(program);
		return;
	}
#endif
}

void midisync(void)
{
	unsigned long jiffies;

	static unsigned long prevtime = 0;
	int i;

	jiffies = time;
	if (jiffies&0xff000000) {
		printf("time is forever\n");
		exit(1);
	}
	if (jiffies > prevtime)
	{
/*if (jiffies - prevtime > 200) printf("(%dcsec time delta)\n", jiffies-prevtime);*/
		prevtime = jiffies; 
		jiffies = (jiffies << 8) | SEQ_WAIT;
		sbwrite((char*)&jiffies);
	}
	else if (jiffies < prevtime)  {
		fprintf(stderr, "(%dcsec negative time)\n", prevtime - jiffies);
		prevtime = jiffies;
	}
}

#ifdef MIDIIN

int midipending(void)
{
 	int tmp;
	if (ext_dev < 0) return(0);
	ioctl(seq_fd, SNDCTL_SEQ_GETINCOUNT, &tmp);
	return tmp;
}

int midigetc(void)
{	int l, havemidi;
	int attempts;

attempts = 0;
	havemidi = 0;
	while (!havemidi) {
attempts++;
if (attempts > 2) printf("%d attempts\n", attempts);
		if ((l=read(seq_fd, buf, 4))==-1) {
			perror("/dev/sequencer");
			exit(-1);
		}
		if (l != 4) {
			fprintf(stderr,"could only read %d bytes\n", l);
			exit(-1);
		}
		if (buf[0] == SEQ_WAIT) {
			sb_time = buf[1] + (buf[2] << 8) + (buf[3] << 16);
#ifdef DEBUG
			printf("sb_time %x (%x %x %x %x)\n",
				sb_time, buf[0],buf[1],buf[2],buf[3]);
#endif
		}
		else if (buf[0] == SEQ_MIDIPUTC) havemidi = 1;
	}
	return(buf[1]);
}

int midigetnb()
{
	if (midipending()) return(midigetc());
	return(-1);
}
/* following 2 routines adapted from midifile.c,
 * by Tim Thompson and M. Czeisperger
 */
static
chanmessage(status,c1,c2)
int status;
int c1, c2;
{
    /*int chan = status & 0xf;*/
    int chan = recording_channel - 1;
    unsigned char data[2];

    data[0] = c1;
    data[1] = c2;

    switch ( status & 0xf0 ) {
    case 0x80:
	mf_write_midi_event(getdelta(),note_off,chan,data,2);
	break;
    case 0x90:
	mf_write_midi_event(getdelta(),note_on,chan,data,2);
	break;
    case 0xa0:
	mf_write_midi_event(getdelta(),poly_aftertouch,chan,data,2);
	break;
    case 0xb0:
	if (c1 != 123)
	mf_write_midi_event(getdelta(),control_change,chan,data,2);
	break;
    case 0xc0:
	mf_write_midi_event(getdelta(),program_chng,chan,data,1);
	break;
    case 0xd0:
	mf_write_midi_event(getdelta(),channel_aftertouch,chan,data,1);
	break;
    case 0xe0:
	mf_write_midi_event(getdelta(),pitch_wheel,chan,data,2);
	break;
    }
}

static
void midimessage()
{
	/* This array is indexed by the high half of a status byte.  It's */
	/* value is either the number of bytes needed (1 or 2) for a channel */
	/* message, or 0 (meaning it's not  a channel message). */
	static int chantype[] = {
		0, 0, 0, 0, 0, 0, 0, 0,		/* 0x00 through 0x70 */
		2, 2, 2, 2, 1, 1, 2, 0		/* 0x80 through 0xf0 */
	};
	static int c = -1, c1 = -1, c2 = -1;
	static int running = 0;	/* 1 when running status used */
	static int status = 0;		/* status value (e.g. 0x90==note-on) */
	int needed;


	if (c == -1) {
		c = midigetnb();
		if (c == -1) return;
	}
	if ( (c & 0x80) == 0 ) {	 /* running status? */
		if ( status == 0 )
			mferror("unexpected running status");
		running = 1;
	}
	else {
		status = c;
		running = 0;
	}

	needed = chantype[ (status>>4) & 0xf ];

	if ( needed ) {		/* ie. is it a channel message? */

		if ( running ) c1 = c;
		else if (c1 = -1) {
			c1 = midigetnb();
			if (c1 == -1) return;
		}
		if (needed>1) {
			if (c2 == -1) c2 = midigetnb();
			if (c2 == -1) return;
		}
		else c2 = 0;

		chanmessage( status, c1, c2 );
		c = c1 = c2 = -1;
	}
	else mferror("apparent non-channel message");
}
#endif

