/*
 * names and info for general-midi instruments
 * "solo" flags voices which should be cut off when the next
 *   note on the same track starts
 * "newv" and "transpose" have Kawai-K1 idiosyncratic data:
 *   "newv" is -1 when this timbre is not available, otherwise it has
 *      the general-midi number of the timbre which should actually be used;
 *   "transpose" has the number of semi-tones to shift up (neg. if down).
 */
struct sub_type{
	char *vname;
	char solo;
	char newv;
	char transpose;
} sub_voice[] = {
/* 0*/	"Acoustic Grand Piano",	0, 0,   0,
/* 1*/	"Bright Acoustic Grand",0, 1,   0,
/* 2*/	"Electric Grand Piano",	0, 2,   0,
/* 3*/	"Honky-tonk Piano",	0, 3,   0,
/* 4*/	"Rhodes Piano",		0, 4,   0,
/* 2*/	"Chorused Piano",	0, -1,   0, /*Banjo*/
/* 6*/	"Harpsichord",		0, 6,   0,
/* 7*/	"Clavinet",		0, 7,   0,
/* 8*/	"Celesta",		0, 8,   0,
/* 9*/	"Glockenspiel",		0, 9,   0,
/* 10*/	"Musicbox",		0, 10,  0,
/* 11*/	"Vibraphone",		0, 11,  0,
/* 12*/	"Marimba",		0, 12,  0,
/* 13*/	"Xylophone",		0, 13,  0,
/* 14*/	"Tubular Bells",	0, 14,  0,
/* 15*/	"Dulcimer",		0, 15,  0,
/* 16*/	"Hammond Organ",	0, 16,  0,
/* 17*/	"Percussive Organ",	0, -1,  0,
/* 18*/	"Rock Organ",		0, 18,  0,
/* 19*/	"Church Organ",		0, 17,  0, /*Unmaze*/
/* 20*/	"Reed Organ",		0, 20,  0,
/* 21*/	"Accordion",		0, 21,  0,
/* 22*/	"Harmonica",		1, 22,  0,
/* 23*/	"Tango Accordion",	0, 23,  0,
/* 24*/	"Nylon Guitar",		0, 24,  0,
/* 25*/	"Steel Guitar",		0, -1,  0, /*Whistle*/
/* 26*/	"Jazz Guitar",		1, 28,  0, /*Melodic Tom*/
/* 27*/	"Clean Guitar",		1, -1,  0, /*Chiffit*/
/* 28*/	"Muted Guitar",		1, -1,  0,
/* 29*/	"Overdriven Guitar",	1, 29,  0,
/* 30*/	"Distortion Guitar",	1, -1,  0, /*Woodblock*/
/* 31*/	"Guitar Harmonics",	1, -1,  0, /*bottles*/
/* 32*/	"Acoustic Bass",	1, 32,  0,
/* 33*/	"Finger Bass",		1, 33,  0,
/* 34*/	"Pick Bass",		1, 34,  0,
/* 35*/	"Fretless Bass",	1, 35,  0,
/* 36*/	"Slap Bass 1",		1, 36,  0,
/* 37*/	"Slap Bass 2",		1, -1,  0, /*Soundtrak*/
/* 38*/	"Synth Bass 1",		1, 38,  0,
/* 39*/	"Synth Bass 2",		1, 39,  0,
/* 40*/	"Violin",		1, -1, 12, /*Atmosphere,Breath Noise*/
/* 41*/	"Viola",		1, 42, 12, /*Glassy*/
/* 42*/	"Cello",		1, 42,  0,
/* 43*/	"Contrabass",		1, 42,-12, /*Steel Drums*/
/* 44*/	"Tremolo Strings",	1, -1,  0, /*Shamisen*/
/* 45*/	"Pizzicato String",	1, 45,  0,
/* 46*/	"Orchestral Harp",	0, 46,  0,
/* 47*/	"Timpani",		1, 47,  0,
/* 48*/	"String Ensemble 1",	1, 48,  0,
/* 49*/	"String Ensemble 2",	1, 49,  0,
/* 50*/	"Synth Strings 1",	1, 50,  0,
/* 51*/	"Synth Strings 2",	1, -1,  0, /*Kalimba*/
/* 52*/	"Choir Aahs",		0, 52,  0,
/* 53*/	"Voice Oohs",		1, -1,  0, /*Airy*/
/* 54*/	"Synth Voice",		1, -1,  0, /*Koto*/
/* 55*/	"Orchestra Hit",	0, -1,  0, /*Sitar*/
/* 56*/	"Trumpet",		1, 56,  0,
/* 57*/	"Trombone",		1, 56,-12, /*Saxophones*/
/* 58*/	"Tuba",			1, 56,-24, /*Oboe, etc*/
/* 59*/	"Muted Trumpet",	1, 56,  0, /*Clarinet, Ocarina*/
/* 60*/	"French Horn",		1, 60,  0,
/* 61*/	"Brass Section",	1, -1,  0, /*Flute,Piccolo*/
/* 62*/	"Synth Brass 1",	1, -1,  0, /*Pan Flute*/
/* 63*/	"Synth Brass 2",	1, -1,  0, /*Bottle Blow*/

/* 64*/	"Soprano Sax",		1, 57, 24,
/* 65*/	"Alto Sax",		1, 57, 12,
/* 66*/	"Tenor Sax",		1, 57,  0,
/* 67*/	"Baritone Sax",		1, 57,-12,
/* 68*/	"Oboe",			1, 58,  0,
/* 69*/	"English Horn",		1, 58,-12,
/* 70*/	"Bassoon",		1, 58,-24,
/* 71*/	"Clarinet",		1, 59,  0,
/* 72*/	"Piccolo",		1, 61, 12,
/* 73*/	"Flute",		1, 61,  0,
/* 74*/	"Recorder",		1, -1,  0,
/* 75*/	"Pan Flute",		1, 62,  0,
/* 76*/	"Bottle Blow",		1, 63,  0,
/* 77*/	"Shakuhachi",		1, -1,  0,
/* 78*/	"Whistle",		1, 25,  0,
/* 79*/	"Ocarina",		1, 59, 12,
/* 80*/	"Lead1 squareea",	1, -1,  0,
/* 81*/	"Lead2 sawtooth",	1, -1,  0,
/* 82*/	"Lead3 calliope",	1, -1,  0,
/* 83*/	"Lead4 chiff",		1, 27,  0,
/* 84*/	"Lead5 charang",	1, -1,  0,
/* 85*/	"Lead6 voice",		1, -1,  0,
/* 86*/	"Lead7 fifths",		1, -1,  0,
/* 87*/	"Lead8 brass+ld",	1, -1,  0,
/* 88*/	"Pad1 newage",		0, -1,  0,
/* 89*/	"Pad2 warm",		0, -1,  0,
/* 90*/	"Pad3 polysynth",	0, -1,  0,
/* 91*/	"Pad4 choir",		0, -1,  0,
/* 92*/	"Pad5 bowed",		0, -1,  0,
/* 93*/	"Pad6 metallic",	0, -1,  0,
/* 94*/	"Pad7 halo",		0, -1,  0,
/* 95*/	"Pad8 sweep",		0, -1,  0,
/* 96*/	"FX1 rain",		0, -1,  0,
/* 97*/	"FX2 soundtrack",	0, 37,  0,
/* 98*/	"FX3 crystal",		1, 41,  0,
/* 99*/	"FX4 atmosphere",	1, -1,  0, /* "Breathe" */
/*100*/	"FX5 brightness",	1, 53,  0,
/*101*/	"FX6 goblins",		1, 19,  0,
/*102*/	"FX7 echoes",		0, -1,  0,
/*103*/	"FX8 sci-fi",		1, -1,  0,
/*104*/	"Sitar",		0, 55,  0,
/*105*/	"Banjo",		0,  5,  0,
/*106*/	"Shamisen",		0, 44,  0,
/*107*/	"Koto",			0, 54,  0,
/*108*/	"Kalimba",		0, 51,  0,
/*109*/	"Bagpipe",		0, 19, 12, /*->Church Organ*/
/*110*/	"Fiddle",		0, -1,  0,
/*111*/	"Shanai",		0, -1,  0,
/*112*/	"Tinkle Bell",		1, -1,  0,
/*113*/	"Agogo Bells",		1, -1,  0, /* bottles?? */
/*114*/	"Steel Drums",		1, 43,  0,
/*115*/	"Woodblock",		1, 30,  0,
/*116*/	"Taiko Drum",		1, -1,  0,
/*117*/	"Melodic Tom",		1, 26,  0,
/*118*/	"Synth Drum",		1, -1,  0,
/*119*/	"Reverse Cymbal",	1, -1,  0,
/*120*/	"Guitar Fret Noise",	1, -1,  0,
/*121*/	"Breath Noise",		1, 40,  0,
/*122*/	"Seashore",		1, -1,  0,
/*123*/	"Bird Tweet",		1, -1,  0,
/*124*/	"Telephone Ring",	1, -1,  0,
/*125*/	"Helicopter Blade",	1, -1,  0,
/*126*/	"Applause/Noise",	1, -1,  0,
/*127*/	"Gunshot",		1, -1,  0
};
