%{
/* $Id: ctomenu.l,v 1.6 89/05/06 17:13:13 lee Exp $
 * Greg Lee, lee@uhccux.uhcc.hawaii.edu, 3/7/89
 *
 * Ctomenu helps translate a synthesizer-specific C file into .menu
 * form by generating the '#MENU ... #END' part for the labelinfo
 * array and the '#O' lines for the paraminfo array.
 *
 * $Log:	ctomenu.l,v $
 * Revision 1.6  89/05/06  17:13:13  lee
 * rel. to comp.sources.misc
 * 
 */
#include <string.h>

#define SCOLS 81
#define SROWS 24
#define MAXPARAM 300

	int i, j, offset, reservesize = 20;
	int row = -2, col = -2 , coord;
	char labelname[30];
	char paramname[30];
	char temps[30];
	char *screen;
	char paraml[MAXPARAM][30];
	char paramv[MAXPARAM][20];
	int paramcoord[MAXPARAM][6];
	int paramno = 0, pcount = 0;
	int havename = 0;
	char paramtemps[80];
	int paramtemplen;
%}

%s A B C D E
wh [ \t\n]*

%%

<A>^"#define"[ \t]+"RESERVESIZE"[ \t]*[0-9]+ {
		for (i=0; yytext[i] != 'Z'; i++) ;
		reservesize = atoi(yytext+i+2);
};

<A>^"struct labelinfo".*\n  {
		for (i=0; i < 30 && yytext[i+16] != '{'; i++)
			labelname[i] = yytext[i+16];
		labelname[i] = 0;
		BEGIN(B);
};

<C>^"struct paraminfo".*\n  {
		for (i=0; i < 30 && yytext[i+16] != '{'; i++)
			paramname[i] = yytext[i+16];
		paramname[i] = 0;
		havename = 0;
		BEGIN(D);
};

<B,D>{wh}		;
<B,D>","		;
<D>"-1"			;
<D>"NULL"		;

<B,D>[0-9]+	{
		coord = atoi(yytext);
		if (row == -2) row = coord;
		else if (col == -2) col = coord;
		else {
			fprintf(stderr, "coordinate mixup\n");
			exit(1);
		}

		if (havename == 2 && row != -2 && col != -2) {
			strncpy(screen+(row*SCOLS)+col,paramtemps,paramtemplen);
			row = col = -2;
			havename = 0;
		}
};

<B>\"[^\"\n]*\"  {
		if (row == -2 || col == -2) {
			fprintf(stderr, "missing coord before %s\n", yytext);
			exit(1);
		}

		strncpy(screen+(row*SCOLS)+col, yytext+1, yyleng-2);
		row = col = -2;
};

<D>\"[^\"\n]*\"  {
		if (!havename) {
			strncpy(paraml[paramno], yytext+1, yyleng-2);
			paraml[paramno][yyleng-2] = 0;
			havename = 1;
		} else {
			strncpy(paramtemps, yytext+1, yyleng-2);
			paramtemplen = yyleng - 2;
			havename = 2;
		}
};

<D>"vis"[0-9A-Za-z_]+  {
		if (row == -2 || col == -2) {
			fprintf(stderr, "missing coord before %s\n", yytext);
			fprintf(stderr, "param no. %d, havename %d\n",
				paramno, havename);
			exit(1);
		}
		strncpy(paramv[paramno], yytext+3, yyleng-3);
		paramcoord[paramno][0] = row;
		paramcoord[paramno][1] = col;
		row = col = -2;
		BEGIN(E);
};

<D>^"NULL".*\n		;

<E>[ \t,]		;

<E>[0-9]+	{
		if (pcount > 3) {
			fprintf(stderr, "extra value\n");
			exit(1);
		}
		paramcoord[paramno][2 + pcount++] = atoi(yytext);
};

<E>\n  {
		pcount = 0;
		paramno++;
		if (paramno > MAXPARAM) {
			fprintf(stderr, "too many parameters\n");
			exit(1);
		}
		havename = 0;
		BEGIN(D);
};

<B>.*"NULL".*\n 	;

<B,D>^"};"  {
		BEGIN(C);
};

<C>^[ \t]*"data[RESERVESIZE"[ \+]*[0-9]+"]"[ \t]*"="[ \t]*"getval(".*\n  {
		for (i=0; yytext[i] != '+'; i++) ;
		offset = atoi(yytext+i+1);
		while (yytext[i++] != '"')  ;
		for (j=0; yytext[i] != '"'; i++,j++)
			temps[j] = yytext[i];
		temps[j] = 0;
		for (i=0; i<paramno; i++)
			if (strcmp(temps, paraml[i]) == 0) break;
		if (i < paramno)
			paramcoord[i][5] = offset + reservesize;
		/* else error ? */
};


<C>^[ \t]*"data["[0-9]+"]"[ \t]*"="[ \t]*"getval(".*\n  {
		for (i=0; yytext[i] != '['; i++) ;
		offset = atoi(yytext+i+1);
		if (offset < reservesize) {
			fprintf(stderr, "offset < RESERVESIZE\n");
			exit(1);
		}
		while (yytext[i++] != '"')  ;
		for (j=0; yytext[i] != '"'; i++,j++)
			temps[j] = yytext[i];
		temps[j] = 0;
		for (i=0; i<paramno; i++)
			if (strcmp(temps, paraml[i]) == 0) break;
		if (i < paramno)
			paramcoord[i][5] = offset;
		/* else error ? */
};

<A,C>.|\n	;

%%
main()
{	int i;
	char *s;
	char *malloc();

	if ( (screen = malloc(SROWS * SCOLS)) == NULL) {
		fprintf(stderr, "not enough memory\n");
		exit(1);
	}
	s = screen;
	for (i=0; i < SROWS*SCOLS; i++) *s++ = ' ';

	BEGIN(A);
	yylex();

	printf("\n#define RESERVESIZE %d\n\n", reservesize);
	menudump();
	paramdump();
}

menudump()
{	int i, j;

	for (i=0; i<paramno; i++) {
		row = paramcoord[i][0];
		col = paramcoord[i][1];
		if (row >= SROWS || col >= SCOLS) {
			fprintf(stderr, "bad coords\n");
			exit(1);
		}
		screen[row*SCOLS + col] = '%';
	}

	printf("struct labelinfo %s {\n", labelname);
	printf("#MENU\n");
	for (i=0; i<SROWS; i++) {
		for (j=SCOLS-1; j>=0 && screen[i*SCOLS+j] == ' '; j--)
			screen[i*SCOLS+j] = 0;
		printf("%s\n", screen+i*SCOLS);
	}
	printf("#END\n");
	printf("-1,-1,NULL\n};\n\n");
}

paramdump()
{	int i, j, notdone, colmin, rowmin;
	char *fmt;

	printf("struct paraminfo %s {\n", paramname);
	printf("/*\nNAME\t\tTYPE\t\tPOS\tMAX\tOFFSET\tMASK\tSHIFT\tADHOC\n");
	printf(" */\n");

	notdone = 1;
	while (notdone) {
		colmin = rowmin = 1000;
		for (i = 0; i < paramno; i++)
			if (paramcoord[i][0] < rowmin)
				rowmin = paramcoord[i][0];
		if (rowmin < 1000) {
		    for (i = 0; i < paramno; i++)
			if (paramcoord[i][0] == rowmin) {
				if (paramcoord[i][1] < colmin) {
				    colmin = paramcoord[i][0];
				    j = i;
				}
			}
		    if (colmin < 1000) {
			fmt = "#O %s\t%s\t%%%%\t%d\t%d";
			if (strlen(paraml[j]) < 5)
				fmt = "#O %s\t\t%s\t%%%%\t%d\t%d";
			if (paramcoord[j][4])
				paramcoord[j][5] = reservesize-paramcoord[j][4];
			printf(fmt,
				paraml[j], paramv[j],
				paramcoord[j][3],
				paramcoord[j][5] - reservesize);
			if (paramcoord[j][2] == 1)
				printf("\t*5");
			printf("\n");
			paramcoord[j][0] = 1000;
			paramcoord[j][1] = 1000;
		    }
		} else notdone = 0;
	}

	printf("NULL,NULL,-1,-1,-1,-1,visnum,0,0,0,0\n};\n\n");
}
