/* $Id: cz.h,v 1.6 89/05/06 17:13:13 lee Exp $
 * CZ Synthesizer Family Parameter Definitions
 *
 *  Filename:   cz.h
 *  Date:       03/25/89, Mark R. Rinfret
 * 
 *
 *  Note:   One of the preprocessor flags, CZ1 or CZ101, must be defined
 *          by the source file including this package.
 * $Log:	cz.h,v $
 * Revision 1.6  89/05/06  17:13:13  lee
 * rel. to comp.sources.misc
 * 
 */

#ifdef CZ101
#define CZ_NAME "CZ-101"
#endif


#ifdef CZ1
#ifdef CZ_NAME
#include "You may not define CZ1 and CZ101 in the same compile!"
#endif
#define CZ_NAME "CZ-1"
#endif

#ifndef CZ_NAME
#include "You MUST define either CZ1 or CZ101!"
#endif

#ifndef UBYTE
#define UBYTE   unsigned char
#define USHORT  unsigned short
#endif

#define ENVELOPESIZE            16      /* 8 rate/level pairs */
#define END_SYSTEM_EXCLUSIVE    0xF7

/* MIDI note-on and note-off commands */

#define MIDI_NOTE_ON            0x90
#define MIDI_NOTE_OFF           0x80

#define MIDI_STATUS_MASK        0x80


#ifdef CZ101
struct ToneData {
    UBYTE lineselect_octave;

    UBYTE detune_sign;
    UBYTE detune_fine;
    UBYTE detune_course;

    UBYTE vibrato_wave;
    UBYTE vibrato_time[3];
    UBYTE vibrato_rate[3];
    UBYTE vibrato_depth[3];

    UBYTE DCO1_wave_form[2];
    UBYTE DCA1_key_follow[2];
    UBYTE DCW1_key_follow[2];
    UBYTE DCA1_end_step;
    UBYTE DCA1_envelope[ENVELOPESIZE];
    UBYTE DCW1_end_step;
    UBYTE DCW1_envelope[ENVELOPESIZE];
    UBYTE DCO1_end_step;
    UBYTE DCO1_envelope[ENVELOPESIZE];

    UBYTE DCO2_wave_form[2];
    UBYTE DCA2_key_follow[2];
    UBYTE DCW2_Key_follow[2];
    UBYTE DCA2_end_step;
    UBYTE DCA2_envelope[ENVELOPESIZE];
    UBYTE DWA2_end_step;
    UBYTE DWA2_envelope[ENVELOPESIZE];
    UBYTE DCO2_end_step;
    UBYTE DCO2_envelope[ENVELOPESIZE];
};
#endif

#ifdef CZ1

#define MIDI_CHANNEL_MASK       0x0f
#define MIDI_FUNCTION_MASK      0xf0

/* Misc. MIDI status definitions */

#define MIDI_PITCH_BEND         0xe0

/* MIDI note-on and note-off commands */

#define MIDI_NOTE_ON            0x90
#define MIDI_NOTE_OFF           0x80

#define MIDI_STATUS_MASK        0x80

#define FIRST_INTERNAL          0x00
#define LAST_INTERNAL           0x3F
#define FIRST_CARTRIDGE         0x40
#define LAST_CARTRIDGE          0x4F
#define SOUND_DATA              0x60

/* CZ-1 Tone Data Structure.
 * The only major difference between this and CZ101 is the addition of
 * the "name" field.
 */

struct ToneData {
    UBYTE lineAndOctave;

    UBYTE detuneSign;
    UBYTE detuneFine;
    UBYTE detuneCoarse;

    UBYTE vibratoWave;
    UBYTE vibratoTime[3];
    UBYTE vibratoRate[3];
    UBYTE vibratoDepth[3];

/* What follows is a very unfortunate KLUDGE!  Though we would like to
 * represent the two sets of waveform data as a two-item array, the MANX
 * compiler forces word alignment (somewhere), giving us a total structure
 * size of 146 bytes when what we really want is 144 bytes.  ARGH!
 */

    UBYTE waveForms1[2];                  /* ugly, packed format */

    /* NOTE: The key follow entries actually comprise a two-byte
       word but, again, the compiler won't let us do that.  The
       top 4 bits of the first byte (d) represents the level value,
       using the formula d = 15 - level. The bottom 4 bits of the
       first byte represents the "visual" key follow value, in the
       range 0 - 9.  The second byte is some magic mapping of the
       visual value to an internal value.                           */
    UBYTE DCA1_KeyFollow[2];
    UBYTE DCW1_KeyFollow[2];
    UBYTE DCA_EndStep1;                         /* DCA velocity */
    UBYTE DCA_Envelope1[ENVELOPESIZE];
    UBYTE DCW_EndStep1;                         /* DCW velocity */
    UBYTE DCW_Envelope1[ENVELOPESIZE];
    UBYTE DCO_EndStep1;                         /* DCO1 velocity */
    UBYTE DCO_Envelope1[ENVELOPESIZE];

    UBYTE waveForms2[2];           /* slightly different than waveForms1! */
    UBYTE DCA2_KeyFollow[2];
    UBYTE DCW2_KeyFollow[2];
    UBYTE DCA_EndStep2;                         /* DCA velocity */
    UBYTE DCA_Envelope2[ENVELOPESIZE];
    UBYTE DCW_EndStep2;                         /* DCW velocity */
    UBYTE DCW_Envelope2[ENVELOPESIZE];
    UBYTE DCO_EndStep2;                         /* DCO1 velocity */
    UBYTE DCO_Envelope2[ENVELOPESIZE];

    UBYTE name[16];
};
#endif

