/* $Id: d10tva.mnu,v 1.6 89/05/06 17:13:18 lee Exp $
 * GLIB - a Generic LIBrarian and editor for synths
 *
 * D10 Tone Amplifier Librarian
 *
 * Code started 24 JAN 89 --  Michael R. Kesti mrk@gvgspd.GVG.TEK.COM
 * modified by Greg Lee
 * $Log:	d10tva.mnu,v $
 * Revision 1.6  89/05/06  17:13:18  lee
 * rel. to comp.sources.misc
 * 
 */

#include "glib.h"
#include "vis.h"

#define D10TONSIZE 246
#define RESERVESIZE 20

char *visnum();

/* This array contains arbitrary screen labels */
struct labelinfo Ldtva[] = {
3,0,"COMMON",
3,41,"AMPLIFIER",
3,59,"1    2    3    4",
4,0,"-----------------",
4,41,"-------------------------------------",
5,44,"Level",
6,3,"Structures",
6,44,"Vel Sens",
7,3,"Partial Ena",
7,44,"Bias Pnt 1",
8,3,"Env Mode",
8,44,"Bias Lev 1",
9,44,"Bias Pnt 2",
10,44,"Bias Lev 2",
11,44,"Time KF",
12,44,"Time Vel Fol",
13,44,"Attack",
14,44,"Decay",
15,44,"Recover",
16,44,"Release",
17,44,"Attack Lev",
18,44,"Decay Lev",
19,44,"Sustain Lev",
23,1,"Press SPACE BAR to sound note",
23,35,"at volume",
23,49,"for duration",
23,65,"on channel",
23,78,".",
# line 50 "d10tva.mnu"
-1,-1,NULL
};

struct paraminfo  Pdtva[] =  {
/*
NAME		TYPE		POS	MAX	OFFSET	MASK	SHIFT	ADHOC
 */
"tva_level1",NULL,-1,-1,5,58,visnum,0,100,0,0,
"tva_level2",NULL,-1,-1,5,63,visnum,0,100,0,0,
"tva_level3",NULL,-1,-1,5,68,visnum,0,100,0,0,
"tva_level4",NULL,-1,-1,5,73,visnum,0,100,0,0,
"struct12",NULL,-1,-1,6,20,visstruct,0,12,0,0,
"struct34",NULL,-1,-1,6,30,visstruct,0,12,0,0,
"tva_vel_sens1",NULL,-1,-1,6,58,visenvlev,0,100,0,0,
"tva_vel_sens2",NULL,-1,-1,6,63,visenvlev,0,100,0,0,
"tva_vel_sens3",NULL,-1,-1,6,68,visenvlev,0,100,0,0,
"tva_vel_sens4",NULL,-1,-1,6,73,visenvlev,0,100,0,0,
"parmute",NULL,-1,-1,7,18,vispmute,0,15,0,0,
"tva_bias_pnt_11",NULL,-1,-1,7,58,visbiaspd,0,127,0,0,
"tva_bias_pnt_12",NULL,-1,-1,7,63,visbiaspd,0,127,0,0,
"tva_bias_pnt_13",NULL,-1,-1,7,68,visbiaspd,0,127,0,0,
"tva_bias_pnt_14",NULL,-1,-1,7,73,visbiaspd,0,127,0,0,
"envmode",NULL,-1,-1,8,18,visenvmode,0,1,0,0,
"tva_bias_lev_11",NULL,-1,-1,8,58,vistvablev,0,12,0,0,
"tva_bias_lev_12",NULL,-1,-1,8,63,vistvablev,0,12,0,0,
"tva_bias_lev_13",NULL,-1,-1,8,68,vistvablev,0,12,0,0,
"tva_bias_lev_14",NULL,-1,-1,8,73,vistvablev,0,12,0,0,
"tva_bias_pnt_21",NULL,-1,-1,9,58,visbiaspd,0,127,0,0,
"tva_bias_pnt_22",NULL,-1,-1,9,63,visbiaspd,0,127,0,0,
"tva_bias_pnt_23",NULL,-1,-1,9,68,visbiaspd,0,127,0,0,
"tva_bias_pnt_24",NULL,-1,-1,9,73,visbiaspd,0,127,0,0,
"tva_bias_lev_21",NULL,-1,-1,10,58,vistvablev,0,12,0,0,
"tva_bias_lev_22",NULL,-1,-1,10,63,vistvablev,0,12,0,0,
"tva_bias_lev_23",NULL,-1,-1,10,68,vistvablev,0,12,0,0,
"tva_bias_lev_24",NULL,-1,-1,10,73,vistvablev,0,12,0,0,
"tva_time_kf1",NULL,-1,-1,11,58,visnum,0,4,0,0,
"tva_time_kf2",NULL,-1,-1,11,63,visnum,0,4,0,0,
"tva_time_kf3",NULL,-1,-1,11,68,visnum,0,4,0,0,
"tva_time_kf4",NULL,-1,-1,11,73,visnum,0,4,0,0,
"tva_time_vel_fol1",NULL,-1,-1,12,58,visnum,0,4,0,0,
"tva_time_vel_fol2",NULL,-1,-1,12,63,visnum,0,4,0,0,
"tva_time_vel_fol3",NULL,-1,-1,12,68,visnum,0,4,0,0,
"tva_time_vel_fol4",NULL,-1,-1,12,73,visnum,0,4,0,0,
"tva_attack1",NULL,-1,-1,13,58,visnum,0,100,0,0,
"tva_attack2",NULL,-1,-1,13,63,visnum,0,100,0,0,
"tva_attack3",NULL,-1,-1,13,68,visnum,0,100,0,0,
"tva_attack4",NULL,-1,-1,13,73,visnum,0,100,0,0,
"tva_decay1",NULL,-1,-1,14,58,visnum,0,100,0,0,
"tva_decay2",NULL,-1,-1,14,63,visnum,0,100,0,0,
"tva_decay3",NULL,-1,-1,14,68,visnum,0,100,0,0,
"tva_decay4",NULL,-1,-1,14,73,visnum,0,100,0,0,
"tva_recover1",NULL,-1,-1,15,58,visnum,0,100,0,0,
"tva_recover2",NULL,-1,-1,15,63,visnum,0,100,0,0,
"tva_recover3",NULL,-1,-1,15,68,visnum,0,100,0,0,
"tva_recover4",NULL,-1,-1,15,73,visnum,0,100,0,0,
"tva_release1",NULL,-1,-1,16,58,visnum,0,100,0,0,
"tva_release2",NULL,-1,-1,16,63,visnum,0,100,0,0,
"tva_release3",NULL,-1,-1,16,68,visnum,0,100,0,0,
"tva_release4",NULL,-1,-1,16,73,visnum,0,100,0,0,
"tva_attack_lev1",NULL,-1,-1,17,58,visnum,0,100,0,0,
"tva_attack_lev2",NULL,-1,-1,17,63,visnum,0,100,0,0,
"tva_attack_lev3",NULL,-1,-1,17,68,visnum,0,100,0,0,
"tva_attack_lev4",NULL,-1,-1,17,73,visnum,0,100,0,0,
"tva_decay_lev1",NULL,-1,-1,18,58,visnum,0,100,0,0,
"tva_decay_lev2",NULL,-1,-1,18,63,visnum,0,100,0,0,
"tva_decay_lev3",NULL,-1,-1,18,68,visnum,0,100,0,0,
"tva_decay_lev4",NULL,-1,-1,18,73,visnum,0,100,0,0,
"tva_sustain_lev1",NULL,-1,-1,19,58,visnum,0,100,0,0,
"tva_sustain_lev2",NULL,-1,-1,19,63,visnum,0,100,0,0,
"tva_sustain_lev3",NULL,-1,-1,19,68,visnum,0,100,0,0,
"tva_sustain_lev4",NULL,-1,-1,19,73,visnum,0,100,0,0,
"autopitch",NULL,-1,-1,23,31,visnum,0,127,60,0,
"autovol",NULL,-1,-1,23,45,visnum,0,127,63,0,
"autodur",NULL,-1,-1,23,62,visnum,1,20,5,0,
"autochan",NULL,-1,-1,23,76,visnum,1,16,1,0,
NULL,NULL,-1,-1,-1,-1,visnum,0,0,0,0
};


/*
 * dtvadin
 *
 * Take library bank 'data' and stuff values in the P array, by using
 * the setval function.
 */

dtvadin(data)
char *data;
{
	/* The first RESERVESIZE bytes are reserved (arbitrarily) for the voice name */
setval("tva_level1",(INT16)data[RESERVESIZE+55]);
setval("tva_level2",(INT16)data[RESERVESIZE+113]);
setval("tva_level3",(INT16)data[RESERVESIZE+171]);
setval("tva_level4",(INT16)data[RESERVESIZE+229]);
setval("struct12",(INT16)data[RESERVESIZE+10]);
setval("struct34",(INT16)data[RESERVESIZE+11]);
setval("tva_vel_sens1",(INT16)data[RESERVESIZE+56]);
setval("tva_vel_sens2",(INT16)data[RESERVESIZE+114]);
setval("tva_vel_sens3",(INT16)data[RESERVESIZE+172]);
setval("tva_vel_sens4",(INT16)data[RESERVESIZE+230]);
setval("parmute",(INT16)data[RESERVESIZE+12]);
setval("tva_bias_pnt_11",(INT16)data[RESERVESIZE+57]);
setval("tva_bias_pnt_12",(INT16)data[RESERVESIZE+115]);
setval("tva_bias_pnt_13",(INT16)data[RESERVESIZE+173]);
setval("tva_bias_pnt_14",(INT16)data[RESERVESIZE+231]);
setval("envmode",(INT16)data[RESERVESIZE+13]);
setval("tva_bias_lev_11",(INT16)data[RESERVESIZE+58]);
setval("tva_bias_lev_12",(INT16)data[RESERVESIZE+116]);
setval("tva_bias_lev_13",(INT16)data[RESERVESIZE+174]);
setval("tva_bias_lev_14",(INT16)data[RESERVESIZE+232]);
setval("tva_bias_pnt_21",(INT16)data[RESERVESIZE+59]);
setval("tva_bias_pnt_22",(INT16)data[RESERVESIZE+117]);
setval("tva_bias_pnt_23",(INT16)data[RESERVESIZE+175]);
setval("tva_bias_pnt_24",(INT16)data[RESERVESIZE+233]);
setval("tva_bias_lev_21",(INT16)data[RESERVESIZE+60]);
setval("tva_bias_lev_22",(INT16)data[RESERVESIZE+118]);
setval("tva_bias_lev_23",(INT16)data[RESERVESIZE+176]);
setval("tva_bias_lev_24",(INT16)data[RESERVESIZE+234]);
setval("tva_time_kf1",(INT16)data[RESERVESIZE+61]);
setval("tva_time_kf2",(INT16)data[RESERVESIZE+119]);
setval("tva_time_kf3",(INT16)data[RESERVESIZE+177]);
setval("tva_time_kf4",(INT16)data[RESERVESIZE+235]);
setval("tva_time_vel_fol1",(INT16)data[RESERVESIZE+62]);
setval("tva_time_vel_fol2",(INT16)data[RESERVESIZE+120]);
setval("tva_time_vel_fol3",(INT16)data[RESERVESIZE+178]);
setval("tva_time_vel_fol4",(INT16)data[RESERVESIZE+236]);
setval("tva_attack1",(INT16)data[RESERVESIZE+63]);
setval("tva_attack2",(INT16)data[RESERVESIZE+121]);
setval("tva_attack3",(INT16)data[RESERVESIZE+179]);
setval("tva_attack4",(INT16)data[RESERVESIZE+237]);
setval("tva_decay1",(INT16)data[RESERVESIZE+64]);
setval("tva_decay2",(INT16)data[RESERVESIZE+122]);
setval("tva_decay3",(INT16)data[RESERVESIZE+180]);
setval("tva_decay4",(INT16)data[RESERVESIZE+238]);
setval("tva_recover1",(INT16)data[RESERVESIZE+65]);
setval("tva_recover2",(INT16)data[RESERVESIZE+123]);
setval("tva_recover3",(INT16)data[RESERVESIZE+181]);
setval("tva_recover4",(INT16)data[RESERVESIZE+239]);
setval("tva_release1",(INT16)data[RESERVESIZE+67]);
setval("tva_release2",(INT16)data[RESERVESIZE+125]);
setval("tva_release3",(INT16)data[RESERVESIZE+183]);
setval("tva_release4",(INT16)data[RESERVESIZE+241]);
setval("tva_attack_lev1",(INT16)data[RESERVESIZE+68]);
setval("tva_attack_lev2",(INT16)data[RESERVESIZE+126]);
setval("tva_attack_lev3",(INT16)data[RESERVESIZE+184]);
setval("tva_attack_lev4",(INT16)data[RESERVESIZE+242]);
setval("tva_decay_lev1",(INT16)data[RESERVESIZE+69]);
setval("tva_decay_lev2",(INT16)data[RESERVESIZE+127]);
setval("tva_decay_lev3",(INT16)data[RESERVESIZE+185]);
setval("tva_decay_lev4",(INT16)data[RESERVESIZE+243]);
setval("tva_sustain_lev1",(INT16)data[RESERVESIZE+71]);
setval("tva_sustain_lev2",(INT16)data[RESERVESIZE+129]);
setval("tva_sustain_lev3",(INT16)data[RESERVESIZE+187]);
setval("tva_sustain_lev4",(INT16)data[RESERVESIZE+245]);
# line 141 "d10tva.mnu"
}

/*
 * dtvadout
 *
 * Take (possibly changed) parameters values out of the P array and
 * put them back into the library bank 'data'.
 */

dtvadout(data)
char *data;
{
data[RESERVESIZE+55] = getval("tva_level1");
data[RESERVESIZE+113] = getval("tva_level2");
data[RESERVESIZE+171] = getval("tva_level3");
data[RESERVESIZE+229] = getval("tva_level4");
data[RESERVESIZE+10] = getval("struct12");
data[RESERVESIZE+11] = getval("struct34");
data[RESERVESIZE+56] = getval("tva_vel_sens1");
data[RESERVESIZE+114] = getval("tva_vel_sens2");
data[RESERVESIZE+172] = getval("tva_vel_sens3");
data[RESERVESIZE+230] = getval("tva_vel_sens4");
data[RESERVESIZE+12] = getval("parmute");
data[RESERVESIZE+57] = getval("tva_bias_pnt_11");
data[RESERVESIZE+115] = getval("tva_bias_pnt_12");
data[RESERVESIZE+173] = getval("tva_bias_pnt_13");
data[RESERVESIZE+231] = getval("tva_bias_pnt_14");
data[RESERVESIZE+13] = getval("envmode");
data[RESERVESIZE+58] = getval("tva_bias_lev_11");
data[RESERVESIZE+116] = getval("tva_bias_lev_12");
data[RESERVESIZE+174] = getval("tva_bias_lev_13");
data[RESERVESIZE+232] = getval("tva_bias_lev_14");
data[RESERVESIZE+59] = getval("tva_bias_pnt_21");
data[RESERVESIZE+117] = getval("tva_bias_pnt_22");
data[RESERVESIZE+175] = getval("tva_bias_pnt_23");
data[RESERVESIZE+233] = getval("tva_bias_pnt_24");
data[RESERVESIZE+60] = getval("tva_bias_lev_21");
data[RESERVESIZE+118] = getval("tva_bias_lev_22");
data[RESERVESIZE+176] = getval("tva_bias_lev_23");
data[RESERVESIZE+234] = getval("tva_bias_lev_24");
data[RESERVESIZE+61] = getval("tva_time_kf1");
data[RESERVESIZE+119] = getval("tva_time_kf2");
data[RESERVESIZE+177] = getval("tva_time_kf3");
data[RESERVESIZE+235] = getval("tva_time_kf4");
data[RESERVESIZE+62] = getval("tva_time_vel_fol1");
data[RESERVESIZE+120] = getval("tva_time_vel_fol2");
data[RESERVESIZE+178] = getval("tva_time_vel_fol3");
data[RESERVESIZE+236] = getval("tva_time_vel_fol4");
data[RESERVESIZE+63] = getval("tva_attack1");
data[RESERVESIZE+121] = getval("tva_attack2");
data[RESERVESIZE+179] = getval("tva_attack3");
data[RESERVESIZE+237] = getval("tva_attack4");
data[RESERVESIZE+64] = getval("tva_decay1");
data[RESERVESIZE+122] = getval("tva_decay2");
data[RESERVESIZE+180] = getval("tva_decay3");
data[RESERVESIZE+238] = getval("tva_decay4");
data[RESERVESIZE+65] = getval("tva_recover1");
data[RESERVESIZE+123] = getval("tva_recover2");
data[RESERVESIZE+181] = getval("tva_recover3");
data[RESERVESIZE+239] = getval("tva_recover4");
data[RESERVESIZE+67] = getval("tva_release1");
data[RESERVESIZE+125] = getval("tva_release2");
data[RESERVESIZE+183] = getval("tva_release3");
data[RESERVESIZE+241] = getval("tva_release4");
data[RESERVESIZE+68] = getval("tva_attack_lev1");
data[RESERVESIZE+126] = getval("tva_attack_lev2");
data[RESERVESIZE+184] = getval("tva_attack_lev3");
data[RESERVESIZE+242] = getval("tva_attack_lev4");
data[RESERVESIZE+69] = getval("tva_decay_lev1");
data[RESERVESIZE+127] = getval("tva_decay_lev2");
data[RESERVESIZE+185] = getval("tva_decay_lev3");
data[RESERVESIZE+243] = getval("tva_decay_lev4");
data[RESERVESIZE+71] = getval("tva_sustain_lev1");
data[RESERVESIZE+129] = getval("tva_sustain_lev2");
data[RESERVESIZE+187] = getval("tva_sustain_lev3");
data[RESERVESIZE+245] = getval("tva_sustain_lev4");
# line 154 "d10tva.mnu"
}

/* end */
