#include <sys/types.h>
#include <fcntl.h>
#include <sys/midi.h>

static int Midifd = -1;

#define MIDIDEVICE "/dev/midi"

initmidi()
{
	Midifd = open(MIDIDEVICE,O_RDWR);
	if ( Midifd >= 0 ) {
		ioctl(Midifd,MIDIRESET);
		/* ioctl(Midifd,MIDITHRU); */
	}
	return Midifd;
}

#define MSIZE 32
static char midibuff[MSIZE];
static int midibsize = 0;

statnmidi()
{
	long t;

	if ( midibsize > 0 )
		return 1;
	midibsize = read(Midifd,midibuff,MSIZE);
	return midibsize > 0;
}

char * getnmidi(an)
int *an;
{

	if ( midibsize > 0 ) {
		*an = midibsize;
		midibsize = 0;
		return midibuff;
	}
	if ( (midibsize=read(Midifd,midibuff,MSIZE)) > 0 ) {
		*an = midibsize;
		midibsize = 0;
		return midibuff;
	}
	*an = 0;
	return (char *)0;
}

void putnmidi(n,p)
char *p;
{
	write(Midifd,p,n);
}

void
resetclock()
{
	ioctl(Midifd,MIDITIMERESET);
}

long
milliclock()
{
	long t;

	ioctl(Midifd,MIDITIME,&t);
	return t;
}
