/*
d10join -- glib format files into a Roland D-10 sysex dump file

Compile: cc -o d10join d10join.c

Usage: d10join <list of names of dump files>
	For each file in the list, seven files are read
	with names created by suffixing to the name of the
	dump file ".id", ".tim", ".pat", ".ton", ".rsu",
	".urp", ".tra".  With the exception of the .id file,
	these correspond to files with the same suffix in the
	Thompson-Kesti distribution of glib.  The .id file is
	created by msplit.

		Greg Lee, lee@uhccux.uhcc.hawaii.edu
*/

#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{	int k;

	for (k = 1; --argc; k++) {
		undump(argv[k]);
	}
}

#define ID  1
#define TIM 2
#define PAT 3
#define TON 4
#define RSU 5
#define URP 6
#define TRA 7

#define TIMBASEADDR 0x050000
#define PATBASEADDR 0x070000
#define TONBASEADDR 0x080000
#define RSUBASEADDR 0x090000
#define URPBASEADDR 0x0a0000
#define TRABASEADDR 0x0c0000
#define  IDBASEADDR 0x100000

FILE *fopen(), *fo;
int which = 0, togo = 0, r = 0, rs = 0, dataid = 0;
char foname[80];
long curradd = 0x100000;

undump(name)
char *name;
{	FILE *f;
	int check, next, count = 0;

	if ( (f = fopen(name, "w")) == NULL ) {
		fprintf(stderr, "can't open file %s\n", name);
		exit(1);
	}

	while ( (next = mfin(name)) != EOF ) {
		if (count == 256 || next == 0xf0) {
			/* checksum */
			putc(-check & 0x7f, f); putc(0xf7, f);
			count = 0;
		}
		if (next == 0xf0) continue;
		if (count == 0) {
			check = 0;
			/* header */
			putc(0xf0, f);
			putc(0x41, f);
			putc(0x10, f);
			putc(0x16, f);
			putc(0x12, f);
			putc((curradd >> 16) & 0x7f, f);
			check += (curradd >> 16) & 0x7f;
			putc((curradd >> 8) & 0x7f, f);
			check += (curradd >> 8) & 0x7f;
			putc(curradd & 0x7f, f);
			check += curradd & 0x7f;
		}
		putc(next, f);
		count++;
		nextadr();
		check += next;
	}
	if (count) { putc(-check & 0x7f, f); putc(0xf7, f); }

	if (r || togo || which < 7)
		fprintf(stderr, "file %s was incomplete\n");
	fclose(f);
}

nextadr()
{
	curradd++;

	if (curradd & 0x80) {
		curradd &= 0x7fff7f;
		curradd += 0x100;
	}
	if (curradd & 0x8000) {
		curradd &= 0x7f7f7f;
		curradd += 0x10000;
	}
}

#define PATDATAID 0xf1
#define TIMDATAID 0xf2
#define TONDATAID 0xf3
#define RSUDATAID 0xf4
#define URPDATAID 0xf5
#define TRADATAID 0xf6

int
mfin(name)
char *name;
{	char *suf;
	int i, c;

	c = '\0';

	if (togo == 0) {
		if (r == 0) /* next in file */ {
			if (which) fclose(fo);
			which++;
			switch (which) {
			    case  ID: suf = ".id";  rs = 50; r = 1;
					curradd = IDBASEADDR;
					dataid = 0xf0; break;
			    case TIM: suf = ".tim"; rs = 8; r = 128;
					curradd = TIMBASEADDR;
					c = 0xf0; dataid = 0xf2; break;
			    case PAT: suf = ".pat"; rs = 38; r = 128;
					curradd = PATBASEADDR;
					dataid = 0xf1; break;
			    case TON: suf = ".ton"; rs = 256; r = 64;
					curradd = TONBASEADDR;
					dataid = 0xf3; break;
			    case RSU: suf = ".rsu"; rs = 4; r = 85;
					curradd = RSUBASEADDR;
					c = 0xf0; dataid = 0xf4; break;
			    case URP: suf = ".urp"; rs = 588; r = 32;
					curradd = URPBASEADDR;
					c = 0xf0; dataid = 0xf5; break;
			    case TRA: suf = ".tra"; rs = 502; r = 1;
					curradd = TRABASEADDR;
					c = 0xf0; dataid = 0xf6; break;
			    default: rs = 0; break;
			}
			if (rs) {
				strcpy(foname, name);
				strcat(foname, suf);
				if ((fo = fopen(foname, "r")) == NULL) {
					fprintf(stderr, "missing file %s\n",
						foname);
					exit(1);
				}
				if (getc(fo) != dataid) {
					fprintf(stderr, "bad type byte in %s\n",
						foname);
					exit(1);
				}
			}
		}
		if (r) /* set togo to recsize */ {
			int padc = 0;

			togo = rs;
			r--;
			/* and read pad at begin of record */
			for (i=0; i<20 && padc != EOF; i++)
				padc = getc(fo); /* should be 0's*/
			if (padc == EOF) {
				fprintf(stderr, "sudden eof in %s\n", foname);
				exit(1);
			}
		}
	}

	if (c) return(c);

	if (togo) {
		if (which != 4 || togo > 10) c = getc(fo);
		else c = '\0';
		togo--;
	} else c = EOF;

	return(c);
}
