/*
d10split -- convert a Roland D-10(?)  sysex dump in a certain format
	(name unknown, but mostly 256 byte blocks) to glib
	format files.

Compile: cc -o d10split d10split.c

Usage: d10split [-c] <list of names of dump files>
	For each file in the list, seven new files are created
	with names created by suffixing to the name of the
	dump file ".id", ".tim", ".pat", ".ton", ".rsu",
	".urp", ".tra".  With the exception of the .id file,
	these correspond to files with the same suffix in the
	Thompson-Kesti distribution of glib.  The .id file is
	of no use so far as I know.

	Use the '-c' flag for cakewalk files.  For these, only
	.tim, .pat, .ton files are created.

		Greg Lee, lee@uhccux.uhcc.hawaii.edu
*/

#include <stdio.h>

int cakeflag = 0;

main(argc, argv)
int argc;
char *argv[];
{	int k;

	for (k = 1; --argc; k++) {
		if (argv[k][0] == '-')
			switch (argv[k][1]) {
				case 'c': cakeflag = 1; break;
				default: break;
			}
		else dump(argv[k]);
	}
}

FILE *fopen(), *fo;
int which = 0, togo = 0, r = 0, rs = 0, dataid = 0;
char foname[80];

dump(name)
char *name;
{	FILE *f;
	int c, next, ign = 0;

	if ( (f = fopen(name, "r")) == NULL ) {
		fprintf(stderr, "no file %s\n", name);
		exit(1);
	}

	if ( (c = getc(f)) == EOF ) {
		fprintf(stderr, "file %s is empty\n", name);
		exit(1);
	}

	if (cakeflag) while ( (c = getc(f)) != EOF && c != 0xf0 ) ;

	while ( (next = getc(f)) != EOF ) {
		if (next == 0xf7) ign = 2;
		else if (c == 0xf0) ign = 8;
		if (ign) ign--;
		else out(c, name);
		c = next;
	}
	if (!ign) out(c, name);

	if (!cakeflag)
	    if (r || togo || which < 7)
		fprintf(stderr, "file %s was incomplete\n");
	fclose(f);
}

#define PATDATAID 0xf1
#define TIMDATAID 0xf2
#define TONDATAID 0xf3
#define RSUDATAID 0xf4
#define URPDATAID 0xf5
#define TRADATAID 0xf6

out(c, name)
int c;
char *name;
{	char *suf;
	int i;

	if (togo == 0) {
		if (r == 0) /* next out file */ {
			if (which) fclose(fo);
			which++;
			if (cakeflag && which == 1) which = 2;
			switch (which) {
			    case 1: suf = ".id";  rs = 50; r = 1;
					dataid = 0xf0; break;
			    case 2: suf = ".tim"; rs = 8; r = 128;
					dataid = 0xf2; break;
			    case 3: suf = ".pat"; rs = 38; r = 128;
					dataid = 0xf1; break;
			    case 4: suf = ".ton"; rs = 256; r = 64;
					dataid = 0xf3; break;
			    case 5: suf = ".rsu"; rs = 4; r = 85;
					dataid = 0xf4; break;
			    case 6: suf = ".urp"; rs = 588; r = 32;
					dataid = 0xf5; break;
			    case 7: suf = ".tra"; rs = 502; r = 1;
					dataid = 0xf6; break;
			    default: rs = 0; break;
			}
			if (cakeflag && which > 4) r = rs = 0;

			if (rs) {
				strcpy(foname, name);
				strcat(foname, suf);
				if ((fo = fopen(foname, "w")) == NULL) {
					fprintf(stderr, "can't open file\n");
					exit(1);
				}
				putc(dataid, fo);
			}
		}
		if (r) /* set togo to recsize */ {
			togo = rs;
			r--;
			/* and pad begin of record */
			for (i=0; i<20; i++) putc('\0', fo);
		}
	}
	if (togo) {
		if (which != 4 || togo > 10) putc(c, fo);
		togo--;
	}
}
