
                                                           GLIB(1) LOCAL



NAME
     glib - patch editor and librarian for synthesizers

SYNOPSIS
     glib

DESCRIPTION
     Glib (one syllable) is a text-screen-oriented librarian and patch
     editor for electronic synthesizers.  It is structured in an attempt
     to make it easy to add support for new synthesizers.  Glib presents
     three types of menu screens:  synthesizer selection, patch
     librarian, and patch editor.  However, depending on choices made
     when glib was compiled, there may be no synthesizer selection menu,
     or it may be used to select different sub-parts of a single synth,
     rather than among different synths.  From the outermost selection
     menu you descend to the librarian.  If there is no synth selection
     menu, you see the librarian screen immediately after invoking glib.

     The librarian part of the program manipulates 1 synth bank of
     voices (which can be uploaded to or downloaded from the synth), and
     3 banks of library voices (which can be read/written to disk).
     When you exit the librarian and select a different synth, the
     contents of the library banks and other settings (e.g. midi
     channel) for each are retained.

     From the librarian screen you can descend to the patch editor
     screen to change or create an individual patch for a given
     synthesizer.  Details about using the librarian and the patch
     editor are given below.

     The glib distribution includes support files for various PCs --
     IBM, Atari ST, Macintosh, Amiga.  And you can run glib on Unix (it
     uses curses), although obviously most Unix machines don't have midi
     I/O.  Trying it out on Unix will give you a feel for what the
     program does, so you can decide whether or not it's worth the
     trouble to port it to your midi-capable PC.  Or your could edit
     patch files on a Unix system and download them to a PC.

     The current version of glib, version 1.6, supports the
     synthesizers:  DX100, TX81, DEP5, DW8000, Roland D-10, Kawaii K1
     K5, DX7, and Casio CZ1.

Using glib - Moving around
     Both the librarian and editor parts of glib make use of arrow keys,
     <CTRL/B> <CTRL/N> <CTRL/P> <CTRL/F> or h j k l to move the cursor
     around.  (The arrow keys may not work on non-Unix versions,
     though.) <CTRL/L> redraws the screen.  These keys are #defined in
     glib.h, so you can change them if you want.  To quit from any mode,
     use q. In the librarian screen, ? gives a command summary.  Esc or
     grave accent key sends an all-notes-off (though the support for
     arrow keys may interfere with this use of esc ).


Using glib - The librarian
     The screen shows the synth bank on the left, and the current (1 of
     3) library bank on the right.  A * identifies the `current' voice,
     and you use the arrow keys to move it around.  As soon as you move
     to a different voice, it is sent to the `edit buffer' of the synth,
     so it is very easy to roam around and see what each voice sounds
     like.  Commands:

     b -  Cycle through the (3) library banks, displayed on the right
          side of the screen.

     c -  Set the midi channel for sending/receiving voices.

     d -  Download from the (real) synthesizer, replacing the current
          contents of the synth bank.

     D -  Download from a file, replacing the current contents of the
          synth bank.  Same as above, except input comes from file
          instead of the synth.  (Implemented only for Unix version.)

     e -  Edit the current voice (see editor description below).

     f -  List the files on the disk.

     p -  Put the yank buffer, replacing the contents of the current
          voice.

     q -  Quit, going back to `choose a synth'.

     r -  Read a bank of voices from a file, replacing entirely the
          current library bank.

     R -  Read a bank of voices from a text file (created with the W
          command).

     s -  Swap the current voice with the yank buffer.  2 swaps is a
          no-op.

     t -  Transfer all voices, either from the current library bank to
          the synth bank, or vice versa.

     u -  Upload the current contents of the synth bank to the synth.
          You are given a choice of sending the entire bank or just the
          current voice.

     U -  Upload the current contents of the synth bank to a file.  Same
          as above, except output goes to file instead of the synth.
          (Implemented only for Unix version.)

     w -  Write the current library bank to a file.

     W -  Write the current library bank to an editable text file.  This
          is slow, and is meant for use in some special circumstance -
          for instance if you changed the binary format of files, you
          might want to convert your old patches.

     y -  Yank the current voice into the yank buffer, shown in the
          middle of the screen.


Using glib - The editor
     In the editor part, arrow keys move the cursor among the parameter
     values.  The cursor will only land on parameter values.  Once on a
     parameter value, the following keys will affect it:

     K -  increase value by 1

     J -  decrease value by 1

     I -  increase value by 4

     M -  decrease value by 4

     < -  decrease value to its minimum

     > -  increase value to its maximum

     S -  assign same value as last assigned

     These keys are defined in glib.h, and should be changed to suit
     your own tastes.  I'm not thrilled with these choices, myself, but
     I had to use something, and at least the hand may stay in one
     place.

     To change the name of a voice, use `N'.

     The `auto-note' is played whenever you press the space bar.  This
     is a convenient way of playing a note as soon as you make a change
     (ie.  you can do everything from the computer keyboard).  You can
     change the auto-note parameters (pitch, duration, volume, channel)
     the same way as all the other parameters.

Synthesizers
     Here is a list of the sample patch files for each synthesizer in
     the 1.6 release of glib, together with occasional notes on the
     current implementation.

     DX100
          Sample patches:  fact1.dx1

     TX81 Sample patches:  fact1.t8p fact1.tx8

     DEP5 Sample patches:  fact1.dp5

     DW8000
          Sample patches:  fact1.dw8

     Roland D-10
          Sample patches:  d10fact.pat d10fact.rsu d10fact.tim
          d10fact.ton d10fact.tra d10fact.urp

     Kawaii K1
          Sample patches:  k1fact.mlt k1fact.sgl

          Voices are not sent to the K1's edit buffer.
          For Kawai K1 multi patches, names of single patches referred
          to are displayed when they can be found in the synth voice
          bank of the single patches module.  The names are updated
          whenever a new bank of voices is transferred into this bank.

     Kawaii K5
          Sample patches:  card1.k5m card1.k5s
          Editing of voices is not implemented.

     DX7  Sample patches:  n001.dx7 rom1.d7s

          Some of the parameters on the DX7s editing screen are
          `multiplexed'.  Move the cursor to the `Modulation Wheel'
          legend, then `increment' and `decrement' this field:  the
          fields below it will cycle through the `Modulation Wheel',
          `Aftertouch', `Breath Control', `Foot Control', and `MIDI
          Control' parameters.

     Casio CZ1
          Sample patches:  bank1.cz1

          The performance parameters given on the lower part of the
          editing screen, Glib, Portamento, etc., are just there pro
          forma.  In the current version, setting them doesn't
          accomplish anything.

AUTHORS

     original version for dx100, tx81z, dep5:  Tim Thompson,
          ...twitch!glimmer!tjt

     Macintosh and dw1000 support:  Steve Falco.

     d10 support:  Michael Kesti, mrk@gvgspd.GVG.TEK.COM

     Amiga and k5 support:  Alan Bland, mab@druwy.ATT.COM
          or att!druwy!mab

     K1 support and menu mods:  Greg Lee, lee@uhccux.uhcc.hawaii.edu

     DX7 support:  Scott Snyder, ssnyder@citjulie.bitnet,
          ssnyder@juliet.caltech.edu (addresses valid until mid-June)

     CZ1 support:  Mark R. Rinfret, mrr@amanpt1.Newport.RI.US,
          ...!rayssd!galaxia!amanpt1!mrr

     arp file requester, Amiga version:  Dave Weiler

     Some of the code was originally written by Steve Frysinger
     (moss!spf), John Helton, and James Gosling.
