/* $Id: mac-glib.r,v 1.6 89/05/06 17:13:31 lee Exp $
 * glib.r - glib resources
 *
 * SAF 3/7/88 (Steven Falco)
 * $Log:	mac-glib.r,v $
 * Revision 1.6  89/05/06  17:13:31  lee
 * rel. to comp.sources.misc
 * 
 */

#include "Types.r"

/* These define's are used in the MENU resources to disable specific
   menu items. */
#define AllItems	0b1111111111111111111111111111111	/* 31 flags */
#define MenuItem1	0b00001
#define MenuItem2	0b00010
#define MenuItem3	0b00100
#define MenuItem4	0b01000
#define MenuItem5	0b10000

type 'GLIB' as 'STR ';

resource 'GLIB' (0) {
	"GLib Version 1.0";
};

resource 'BNDL' (128) {
	'GLIB',				/* our signature */
	0,
	{
		'ICN#',
		{
			0, 128;		/* glib's icon */
			1, 129		/* dumps' icon */
		};
		'FREF',
		{
			0, 128;		/* glib's type */
			1, 129		/* dumps' type */
		}
	}
};

resource 'ICN#' (128) {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 0000 0000 0000 0000 0000 003F 8000"
		$"007F C000 00E0 E000 0180 3000 0180 1800"
		$"0398 CC00 0700 0E00 0707 0E00 0710 4E00"
		$"0388 8C00 11C7 1800 18F0 3000 1C3F E000"
		$"0E0F C000 0706 0000 03FF FF00 01FF FF80"
		$"0006 0180 0006 0180 0006 0000 001F F000"
		$"003F F800 0070 1C00 00E0 0C00 00C0 0C00"
		$"00C0 0C00 00F0 0F00 00F0 0F00 0000 0000",
		/* [2] */
		$"0000 0000 007F C000 00FF E000 01FF F000"
		$"03FF F800 07FF FC00 0FFF FE00 1FFF FF00"
		$"3FFF FF80 7FFF FF80 7FFF FF80 7FFF FF80"
		$"7FFF FF80 7FFF FF80 7FFF FF80 7FFF FFC0"
		$"7FFF FFE0 7FFF FFE0 3FFF FFE0 1FFF FFE0"
		$"0FFF FFE0 07FF FFE0 03FF FFE0 03FF FFE0"
		$"03FF FFE0 03FF FFE0 03FF FFE0 03FF FFE0"
		$"03FF FFE0 03FF FFE0 03FF FFE0 03FF FFE0"
	}
};

resource 'ICN#' (129) {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0003 F000 0043 FFC0 0063 0FC0"
		$"01F3 0000 01FB 0000 01F3 F000 0063 FFC0"
		$"0043 0FC0 0003 0000 0003 0000 0003 0000"
		$"0003 0400 0003 0C00 007B 1FC0 00FF 3FC0"
		$"01FF 1FC0 01FF 0C00 01FF 0400 00FE 0000"
		$"007C 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000",
		/* [2] */
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"03FF FFE0 03FF FFE0 03FF FFE0 03FF FFE0"
		$"03FF FFE0 03FF FFE0 03FF FFE0 03FF FFE0"
		$"03FF FFE0 03FF FFE0 03FF FFE0 03FF FFE0"
		$"03FF FFE0 03FF FFE0 03FF FFE0 03FF FFE0"
		$"03FF FFE0 03FF FFE0 03FF FFE0 03FF FFE0"
		$"03FF FFE0 03FF FFE0 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
	}
};

resource 'FREF' (128) {
	'APPL', 0, ""
};

resource 'FREF' (129) {
	'TEXT', 1, ""
};

resource 'DLOG' (128, "About GLibI") {
	{66, 102, 224, 400},
	dBoxProc, visible, noGoAway, 0x0, 128, ""
};

resource 'DITL' (128) {
	 {
/* 1 */ {130, 205, 150, 284},
		button {
			enabled,
			"Continue"
		};
/* 2 */ {94, 28, 115, 301},				/* memory amount */
		staticText {
			disabled,
			""
		};
/* 3 */ {8, 14, 27, 169},
		staticText {
			disabled,
			"GLib Version 1.0"
		};
/* 4 */ {32, 29, 50, 195},
		staticText {
			disabled,
			"Author: Tim Thompson"
		};
/* 5 */ {55, 28, 73, 299},
		staticText {
			disabled, "Macintosh conversion: Steven A. Falco"
		}
	}
};

resource 'MENU' (128, "Apple", preload) {
	128, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, apple,
	{
		"About GLibI",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (129, "File", preload) {
	129, textMenuProc,
	allEnabled,
	enabled, "File",
	{
		"Quit",
			noicon, "Q", nomark, plain
	}
};

resource 'MENU' (130, "Edit", preload) {
	130, textMenuProc,
	allEnabled,
	enabled, "Edit",
	 {
		"Undo",
			noicon, "Z", nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Cut",
			noicon, "X", nomark, plain;
		"Copy",
			noicon, "C", nomark, plain;
		"Paste",
			noicon, "V", nomark, plain;
		"Clear",
			noicon, nokey, nomark, plain
	}
};

resource 'SIZE' (-1) {
	dontSaveScreen,
	ignoreSuspendResumeEvents,
	enableOptionSwitch,
	canBackground,				/* sort-of :-) */
	notMultiFinderAware,
	300032,						/* preferred size */
	300032						/* minimum size */
};
