/* $Id: mac-vt.h,v 1.6 89/05/06 17:13:35 lee Exp $
 * vt.h - definitions for the vt100-like console device handler
 *
 * Steven A. Falco  4/30/87
 * $Log:	mac-vt.h,v $
 * Revision 1.6  89/05/06  17:13:35  lee
 * rel. to comp.sources.misc
 * 
 */

#ifndef EOF
#define EOF		-1
#endif

/* this structure defines one member of the _StdDevs array.  This is
 * similar to the Unix concept of bdevsw and cdevsw.
 */
typedef struct {
	int name;			/* 'CONS' for the console */
	int (*l_access)();	/* NOT the same as open - can do mv or rm also */
	int (*l_close)();	/* close */
	int (*l_read)();	/* read */
	int (*l_write)();	/* write */
	int (*l_ioctl)();	/* ioctl */
} DEVSW;

extern DEVSW _StdDevs[];

/* this structure defines one member of the file table.  I believe
 * the table is dynamically allocated for 200 bytes at a time or
 * 10 entries.  But _lockedHandle may return words or something else.
 */
typedef struct {
	short flags;	/* high byte sometimes has fileno */
	short errcode;	/* a MacOS error code */
	DEVSW *handler;	/* a pointer to our _StdDevs array entry */
	int z;			/* unknown */
	int count;		/* read or write count desired. <-- --> */
	char *buffer;	/* buffer pointer to use. <-- --> */
} IOSTR;

/* look up a file number in the file table and return a pointer to the
 * entry.  Pass in -1 to get a new entry.  NOTE - the ADDRESS of the
 * file number is passed - NOT the file number itself.  I wonder why?
 */
IOSTR *_getIOPort();

/* these are the low-level entry points to link the driver (handler)
 * into the system.  They require strange input arguments and always
 * return 0 on success.  Don't call them directly...
 */
extern	vt_faccess();
extern	vt_close();
extern	vt_read();
extern	vt_write();
extern	vt_ioctl();

/* these are the ultra-low level calls that do all the work.  You can
 * call them directly to avoid all the IntEnv overhead.  See vt.c for
 * the input and output specifications.
 */
extern	vt_open();
extern	vt_getch();
extern	vt_peekch();
extern	vt_putch();
extern	vt_cooked();
extern	vt_raw();
