/* $Id: pc-mach.h,v 1.6 89/05/06 17:13:40 lee Exp $
 *
 * Machine-dependent stuff for DOS.  Has only been tested with Turbo C 2.0.
 * $Log:	pc-mach.h,v $
 * Revision 1.6  89/05/06  17:13:40  lee
 * rel. to comp.sources.misc
 * 
 */

#include <dos.h>
#include <dir.h>
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>

#define TURBOC

#define MIDIABLE

#define OPENBINFILE(f,name,mode) f=fopen(name,mode[0]=='r'?"rb":"wb")
#define OPENTEXTFILE(f,name,mode) f=fopen(name,mode[0]=='r'?"rt":"wt")

extern unsigned long hzcount;
extern int wrt_index, rd_index;
extern int Nextpcchar;

#define INT16 int

#define STATMIDI (wrt_index==rd_index?0:1)
#define STATCONSOLE (Nextpcchar!=EOF?1:(kbhit()?(Nextpcchar=getch(),1):0))
#define RTSTART rtstart()
#define RTEND rtend()
#define KEYCHECK keycheck()
#define TTYISRAW
#define NEEDSECHO

#define SEPARATOR "\\"
#define CORELEFT coreleft
/* fake ones for a fake signal() */
#define SIGINT 1
#define SIG_IGN 0

/* CLOCK DEFINES */

#define MASTER_CLOCK_RATE	96		/* 96 CLOCKS PER BEAT */
#define MIDI_CLOCKS_PER_BEAT	24

/* MISC INTERNAL DEFINES */

#define REC_CTRL_ALL	  1
#define REC_CTRL_NO_BEND  0	
#define REC_CTRL_NO_PRESS 2

#define COMMAND_MSG 	0
#define READ_MSG 	1
#define WRITE_MSG	2

#define SHELL_USE_INTERNAL_CLOCK 0
#define SHELL_USE_TAPE_CLOCK 1
#define SHELL_USE_MIDI_CLOCK 2

/* CODES FOR THE COMMANDS THAT ARE SENT TO THE MIC */

#define PLAY_STOP		0x05
#define PLAY_START		0x0A
#define REC_STOP		0x11
#define OVERDUB_STOP		0x15
#define RECORD_STANDBY		0x20
#define REC_START		0x22
#define OVERDUB_START		0x2A
#define NO_ALL_NOTES_OFF	0x30
#define NO_REAL_TIME		0x32
#define THRU_DEAD		0x33
#define COMMON_TO_HOST		0x38
#define REAL_TIME_IN		0x39
#define UART			0x3f
#define SET_REFA		0x40
#define USE_INTERNAL_CLOCK	0x80
#define USE_TAPE_CLOCK		0x81
#define USE_MIDI_CLOCK		0x82
#define METRONOME_ON_NORMAL	0x83
#define METRONOME_OFF		0x84
#define METRONOME_ON_DOUBLE	0x85
#define BENDER_OFF		0x86
#define BENDER_ON		0x87
#define THRU_OFF 		0x88
#define THRU_ON			0x89
#define INHIBIT_MEASURE_END	0x8C
#define REQUEST_MEASURE_END	0x8D
#define CONDUCTOR_OFF		0x8e
#define CONDUCTOR_ON		0x8f
#define RTM_AFFECT_OFF		0x90
#define RTM_AFFECT_ON		0x91
#define FSK_TO_INT		0x92
#define FSK_TO_MIDI		0x93
#define CLOCK_TO_HOST_OFF	0x94
#define CLOCK_TO_HOST_ON	0x95
#define CREFA_OFF		0x98
#define READ_RESET_RECORD_CTR	0xAB
#define TEMPO_REQUEST		0xAF
#define CLEAR_PLAY_COUNTERS	0xB8
#define CLEAR_PLY		0xb9
#define SET_CLOCK_RES		0xc2
#define SEND_DATA		(0xd0 + 7)	/* send on track 7 */
#define SEND_SYSTEM		0xdf
#define SET_TEMPO		0xE0
#define CLOCKS_PER_BEAT		0xE4
#define BEATS_PER_MEASURE	0xE6
#define CLOCK_TO_HOST_RATE	0xe7
#define ACTIVE_TRACKS		0xEC
#define ACCEPT_CHANNELS_LOW	0xEE
#define ACCEPT_CHANNELS_HIGH	0xEF
#define TIMING_OVERFLOW		0xF8
#define SEND_NULL		0xF8
#define MEASURE_END		0xf9
#define DATA_END		0xfc
#define RESET			0xFF

/* CODES FOR THE MESSAGES THAT ARE READ FROM THE MIC */

#define REQUEST_PLAY_DATA	0xF0
#define TIMING_OVERFLOW		0xF8
#define DATA_END_MARK		0xFC
#define ALL_END			0xFC
/* #define MEASURE_END		0xF9  avoid redefinition */
#define CONDUCT_REQ		0xf9
#define CLOCK_TO_HOST		0xFD
#define ACK			0Xfe
#define SYSTEM_MSG		0xff

/* HARDWARE LEVEL ACCESS TO THE MIC, FROM 'C' */

#define BASE_ADDRESS_MIC	0X0330
#define STATUS_PORT_MIC		BASE_ADDRESS_MIC + 1
#define COMMAND_PORT_MIC	BASE_ADDRESS_MIC + 1
#define DATA_OUT_PORT_MIC	BASE_ADDRESS_MIC + 0
#define DATA_IN_PORT_MIC	BASE_ADDRESS_MIC + 0
#define INT_MIC			2
#define INT2 			10
#define DATA_READY_MIC_MASK	0x40
#define DATA_AVAILABLE_MIC_MASK 0x80
#define INT_RESET_PORT		0x20
#define INT_RESET_CODE		0x20
#define PC_INTERRUPT_MASK_REGISTER 0x21


/* INPUT/OUTPUT LOW LEVEL MACROS */

#define NOT_READY_FOR_DATA_MIC() (inportb(STATUS_PORT_MIC) & \
				    DATA_READY_MIC_MASK)
#define NOT_DATA_AVAILABLE_MIC() (inportb(STATUS_PORT_MIC) & \
				    DATA_AVAILABLE_MIC_MASK)
#define COMMAND_OUT_MIC(com) 	outportb(COMMAND_PORT_MIC, com)
#define DATA_OUT_MIC(dat) 	outportb(DATA_OUT_PORT_MIC, dat)
#define READ_DATA_MIC() 	inportb(DATA_IN_PORT_MIC)

/* define the graphics drawing characters for showstr */

#define DRAW_VERT	179	/* vertical line */
#define DRAW_HORIZ	196	/* horizontal line */
#define DRAW_CROSS	197	/* vertical line intersecting horizontal */
#define DRAW_UPTEE	194	/* 'T' */
#define DRAW_DOWNTEE	193	/* upside-down 'T' */
#define DRAW_LEFTTEE	195	/* 'T' on its left side */
#define DRAW_RIGHTTEE	180	/* 'T' on its right side */
#define DRAW_UPLEFT	218	/* upper-left corner */
#define DRAW_UPRIGHT	191	/* upper-right corner */
#define DRAW_DOWNLEFT	192	/* lower-left corner */
#define DRAW_DOWNRIGHT	217	/* lower-right corner */
