# $Id: pc-tcc.mak,v 1.6 89/05/06 17:13:41 lee Exp $
#
# Glib, Turbo C version for Kawai K1, etc.
# Scott Snyder
# $Log:	pc-tcc.mak,v $
# Revision 1.6  89/05/06  17:13:41  lee
# rel. to comp.sources.misc
# 
# added defs for CZ1
# 
# adapted from Tim Thompson's program
# with modifications by Michael Kesti and Greg Lee

# works with TC v2.0

MODEL=l

LEX = flex
LEXLIB =
# to use lex instead of flex:
#LEX = lex
#LEXLIB = -ll

# defines for CFLAGS (below):
#	BSD for fopen with mode 'r'/'w' instead of 'rb'/'wb'
#	ULTRIX enables curses no()/nonl() fix
#	ARROW for use of arrow keys (probably only bsd)
# and uncomment one set of the following for supported synths:

# Remove '#' from next 5 lines for Roland D-10:
#SYNTHS = -DROLANDD10
#SYNTHOBJ = vis.obj d10pat.obj d10tim.obj d10ton.obj d10wfg.obj d10tvf.obj \
#       d10tva.obj d10rsu.obj d10urp.obj d10tra.obj
#SYNTHC = d10pat.c d10tim.c d10wfg.c d10tvf.c d10tva.c \
#	d10rsu.c d10urp.c d10tra.c # vis.h

# Remove '#' from next 4 lines for various Yamaha, K5, etc.:
#SYNTHS = -DTX81Z -DTX81ZPERF -DDX100 -DDW8000 -DKAWAIK5 -DDEP5
#SYNTHOBJ = dx100.obj tx81z.obj tx81p.obj dw8000.obj yama_com.obj
#       k5single.obj k5multi.obj dep5.obj
#SYNTHC = dx100.c tx81z.c tx81p.c dw8000.c k5single.c k5multi.c dep5.c

# Remove '#' from next group of lines for Yamaha DX7, DX7s:
SYNTHS = -DDX7 -DDX7S
SYNTHOBJ = dx7.obj dx7s.obj
SYNTHC = dx7.c dx7s.c

# Remove '#' from next 3 lines for Kawai K1:
#SYNTHS = -DKAWAIK1
#SYNTHOBJ = k1vis.o k1multi.o k1single.o
#SYNTHC = k1multi.c k1single.c # k1vis.h

# Remove '#' from next 3 lines for CZ1:
#SYNTHS = -DCZ1
#SYNTHOBJ = cz1.o
#SYNTHC = cz1.c

#
# Define SSS to enable speed-up code in glib.c
#

CFLAGS = -N -m$(MODEL) -DSSS $(SYNTHS)

GLIBOBJ = glib.obj machdep.obj list.obj pc-ints.obj

OBJ = $(GLIBOBJ) $(SYNTHOBJ)

H = glib.h machdep.h vis.h

.mnu.c:
	menutoc $*.mnu $*.c

.c.obj:
	tcc -c $(CFLAGS) $.

.c.exe:
	tcc -N $.

glib.exe : menutoc.exe $(SYNTHC) $(OBJ)
	tcc -m$(MODEL) $(OBJ)

machdep.c: pc-mach.c
	copy pc-mach.c machdep.c

machdep.h: pc-mach.h
	copy pc-mach.h machdep.h

machdep.obj: machdep.c $(H)

glib.obj: glib.c $(H)

list.obj: list.c $(H)

dx100.obj: dx100.c $(H)

tx81z.obj: tx81z.c $(H)

tx81p.obj: tx81p.c $(H)

dw8000.obj: dw8000.c $(H)

yama_com.obj: yama_com.c $(H)

dx7.obj: dx7.c $(H)

dx7s.obj: dx7s.c $(H)

k5single.obj: k5single.c $(H)

k5multi.obj: k5multi.c $(H)

pc-ints.obj: pc-ints.asm
	masm /mx pc-ints;
