#ifndef DMA8CNTRL_H
#  define DMA8CNTRL_H

#include<stdio.h>

//Some dma I/O ports.
//~~~~~~~~~~~~~~~~~~~~
enum _8_BITS_DMA_PORTS {
                         DMA8_MASK_REGISTER = 0x0A,
                         DMA8_MODE_REGISTER = 0x0B,
                         DMA8_CLEAR_BYTE    = 0x0C
                       };


//Struct for data pointer.
//~~~~~~~~~~~~~~~~~~~~~~~~
typedef struct ptrCmp{
                        unsigned nbOfPage;
                        unsigned usedPage[16];
                        unsigned nbOfByte[16];
                        unsigned startAddr[16];
                     };

//Control class for dma 8 bits.
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class DMA_8_BITS
{
   public:
          DMA_8_BITS( int dmaCh = -1, unsigned long bufLen = 0L,unsigned char *dataPTR = NULL );
          void DmaInput( void );
          void DmaOutput( void );
          void EnableDma( void );
          int  GetDmaChanel( void ){ return dmaChanel;};
          int  GetNbOfPage( void ){return ptrInfo.nbOfPage;};
          unsigned GetPageCount( int page ){ return ptrInfo.nbOfByte[page];};
          unsigned char * GetDataPtr( void ){ return songPTR; };

          void CalculAddr( void );
          void SelectDma( void );
          void SetCount( void );
          void SetDmaChanel( int chanel ){ dmaChanel = chanel; };
          void SetDataAddr( unsigned long bufLen,unsigned char *dataPTR );
          void SetMemoryAddress( void );

   protected:
             int dmaChanel,flagMore,indBuf;

             unsigned char *songPTR;

             unsigned long songLength;
             unsigned char dmaCommand;
             struct ptrCmp ptrInfo;
};
#endif