#ifndef DSP8_H
#define DSP8_H


//Return code for InitDsp.
//~~~~~~~~~~~~~~~~~~~~~~~~
enum DSP_RETURN {
                  dsp_INIT_FAILLED = 0,
                  dsp_INIT_OK      = 1
                };


//Type of output. N.B:DSP_16_BITS not implemented yet.
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
enum DSP_MODE {
                 DSP_8_BITS            = 0,
                 DSP_8_BITS_HIGH_SPEED = 1,
                 DSP_16_BITS           = 2
              };


//Control class for sound blaster dsp.
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class DSP_CONTROL
{
   public:
          DSP_CONTROL( unsigned port = 0, unsigned irq = 0, unsigned mode = DSP_8_BITS );

          void Continue( void ){SetRate();DspWrite(0xD4);};
          void GetDspVersion( unsigned char *major, unsigned char *minor );
          void Pause( void ){DspWrite(0xD0);};
          void SelectDspMode( void );
          void SetDspCount( unsigned length );
          void SetRate( unsigned samplingRate = 0);
          void SetIoPort( unsigned port ){ ioPort = port; };
          void SetIrq( unsigned irq )    { interNo = irq; };
          void TurnSpeakerOff( void );
          void TurnSpeakerOn( void );

          unsigned InitDsp( void );
          unsigned GetIoPort( void )     { return ioPort; };
          unsigned GetIrq( void )        { return interNo; };
          unsigned GetRate( void ) {return rate;};
          unsigned GetMode( void ) {return dspMode;};




   protected:
             void DspWrite( unsigned char byte );
             unsigned char DspRead( void );
             unsigned ioPort, interNo,transfertType, dspMode, rate;
             unsigned char timeConstant;
};

#endif