/*Example 4.
  Jouer un fichier .wav
  Play from a wave file.
*/

/* Include pour C++ */
#include <sys\stat.h>
#include <fcntl.h>
#include <io.h>
#include <stdlib.h>
#include <dir.h>
#include <stdio.h>
#include <conio.h>

/* Include pour la librairie. */
/* Include for library. */
#include "type.h"
#include "sbdsp.h"
#include "status.h"


/*
  Fonction KbHit. Verifie si une touche a ete pesee.
  retourne 0 si une touche est pesee,
  retourne 1 si aucune touche pesee.
  --
  KbHit Function. Check for a key press.
  return 0 if a key pressed,
  otherwise 1.

*/
int KbHit( void )
{
   int retour = 1;

   asm mov ah,1;
   asm int 016h;
   if( (_FLAGS & 64) == 64 )
      retour = 0;

   return retour;
}


/*
  Fonction PrintCardInfo. Affiche les informations contenues
  dans la structure stc_CARD_INFO.
  ---
  PrintCardInfo functions. Display stc_CARD_INFO

*/
void PrintCardInfo( stc_CARD_INFO *card )
{

   printf("   Card Info.");
   printf("\n\r   ----------");


   printf("\n\n\n\rCard Name:%s",card->cardName);
   printf("\n\rI/O port:%x",card->ioPort);
   printf("\n\rIRQ     :%u",card->irq);
   printf("\n\r8 bits dma:%u",card->dmaChanel8);
   if( card->dmaChanel16 != sta_NOT_DEFINED )
      printf("\n\r16 bits dma:%u",card->dmaChanel16);
   else
      printf("\n\r16 bits dma:N/A");
   printf("\n\rDSP version:%u.%u",card->dspMaj, card->dspMin);
   printf("\n\rCurrent Sampling rate:%u",card->samplingRate);
   printf("\n\rMinimum Sampling rate:%u",card->minSamplingRate);
   printf("\n\rMaximum Sampling rate:%u",card->maxSamplingRate);
   getch();


}


main()
{
   SB_DSP dsp;
   int handle;
   unsigned flagFin = 0;


   clrscr();
   /* Ouverture du fichier .wav */
	 /* Wave file open */
   handle = open("c:/windows/tada.wav",O_RDONLY | O_BINARY,S_IREAD);

   if( dsp.Set8BitsDma(1) == err_VALID_DMA )
   {
      if( dsp.SetIOPort(0x220) == err_VALID_PORT )
      {
	 if( dsp.SetIrq(5) == err_VALID_IRQ )
	 {
	    if( dsp.InitCard() == err_INIT_DONE )
	    {
	       if( dsp.SetOutputWaveHandle(handle) == err_VALID_HANDLE )
	       {
		  /* Donne l'adresse du flag qui
		     nous indiquera la fin du playback.
		     ---------------------------------- */
		  /* Set flag address.
		     ----------------- */

		  dsp.SetUserFlag(&flagFin);
		  PrintCardInfo(dsp.GetCardInfo());

		  /* On fait jouer le fichier jusqu'a la fin
		     ou jusqu'a ca qu'une touche soit peser.
		     --------------------------------------- */
		  dsp.Start();
		  while( !KbHit() && (flagFin == 0) );
		  dsp.Stop();
	       }
	       else
		  printf("Handle de fichier invalide.");
	    }
	    else
	       printf("Pas de carte trouve.");
	 }
	 else
	    printf("Invalide IRQ pour cette carte");
      }
      else
	 printf("Invalide IO port pour cette carte");
   }
   else
      printf("Canal DMA 8 bits invalide pour cette carte");
   close(handle);
}