#ifndef SB_DSP_H
#define SB_DSP_H

#include "soundca.h"
#include "structur.h"
#include "dsp8.h"
#include "dma8cnt.h"
#include "sbirq.h"


class SB_DSP : public SOUNDCARD_DSP
{
   public:
          SB_DSP( void );
          virtual ~SB_DSP( void );

          virtual stc_CARD_INFO * GetCardInfo( void );
          virtual CARD_STATUS GetCurrentStatus( void );
          virtual ERROR InitCard( void );
          virtual ERROR Set8BitsDma( unsigned theDma );
          virtual ERROR Set16BitsDma( unsigned theDma );
          virtual ERROR SetIOPort( unsigned theIOPort );
          virtual ERROR SetIrq( unsigned theIRQ );
          virtual ERROR SetOutputBuffer( char *outBufPTR, unsigned length );
          virtual ERROR SetOutputRawHandle( int handle );
          virtual ERROR SetOutputWaveHandle( int handle );
          virtual ERROR SetOutputVocHandle( int handle );
          virtual ERROR SetSamplingRate( unsigned theSamplingRate );
          virtual void  SetUserFlag( unsigned *flag );
          virtual ERROR Start( void );
          virtual ERROR Stop( void );


   protected:
             int FindSmpRate( int handle,unsigned *smpRate,            \
                              unsigned char *pack,unsigned char *mode );


             unsigned valid8BitsDmaChanel[3], validIOPort[6];
             unsigned validIrq[4];
             unsigned maxDma,maxIO, maxIrq;
             DSP_CONTROL *sb8PTR;
             DMA_8_BITS  *sb8DmaPTR;
             SB_IRQ      *sb8IrqPTR;



};



#endif