#ifndef IRQ_H
#  define IRQ_H

#include "dsp8.h"
#include "dma8cnt.h"
#include "type.h"



//8259 irq controller mask.
//~~~~~~~~~~~~~~~~~~~~~~~~~
#define IRQ2_MASK   0xFB
#define IRQ3_MASK   0xF7
#define IRQ5_MASK   0xDF
#define IRQ7_MASK   0x7F


#define IRQ2        0x0A
#define IRQ3        0x0B
#define IRQ5        0x0D
#define IRQ7        0x0F


//Sound blaster irq manager.
//~~~~~~~~~~~~~~~~~~~~~~~~~~
class SB_IRQ
{
   public:
          SB_IRQ( DMA_8_BITS *dma, DSP_CONTROL *dsp );
          ~SB_IRQ( void ){};

          bool AllocBuffer( void );
          void FreeBuffer( void );
          void InstallIrq( void );
          void SetBuffer( char *buffer, long length );
          void SetRawHandle( int hd );
          void SetWaveHandle( int hd );
          void SetVocHandle( int hd );
          void SetEndOfOutputFlag( unsigned *endOfOutput );
          void SetIrq( int irqNum );
          void StartRawPlay( unsigned rate );
          void StartWavePlay( unsigned rate );
          void StartBufferPlay( unsigned rate );
          void StartVocPlay( unsigned rate );
          void UninstallIrq( void );

   protected:

          /* Interrupt handler.
             ------------------ */
          static void interrupt DspWaveFileIntr( ... );
          static void interrupt DspRawFileIntr( ... );
          static void interrupt DspBufferIntr( ... );
          static void interrupt DspVocFileIntr( ... );

          unsigned char oldState;

          /* Pour les fichiers voc.
             ---------------------- */
          unsigned long dataLength;

          unsigned mask, *voiceEnd;
          char *dataPTR, *dataPTR2;

          int irq, handle, ind, flag;
          long nbBytePtr1, nbBytePtr2;

          bool isFile;

          DMA_8_BITS   *intrDmaPTR;
          DSP_CONTROL  *intrDspPTR;
          FILE_TYPE    fType;
};

#endif