#ifndef SOUNDCARD_H
#define SOUNDCARD_H

#include "error.h"
#include "structur.h"
#include "type.h"


class SOUNDCARD_DSP
{
   public:
          SOUNDCARD_DSP( void ){};
          virtual ~SOUNDCARD_DSP( void ){};

          virtual stc_CARD_INFO *GetCardInfo( void )  = 0;
          virtual CARD_STATUS GetCurrentStatus( void )     = 0;
          virtual ERROR InitCard( void )                   = 0;
          virtual ERROR Set8BitsDma( unsigned theDma )     = 0;
          virtual ERROR Set16BitsDma( unsigned theDma )    = 0;
          virtual ERROR SetIOPort( unsigned theIOPort )    = 0;
          virtual ERROR SetIrq( unsigned theIRQ )          = 0;
          virtual ERROR SetOutputBuffer( char *outBufPTR, unsigned length ) = 0;
          virtual ERROR SetOutputRawHandle( int handle )   = 0;
          virtual ERROR SetOutputWaveHandle( int handle )  = 0;
          virtual ERROR SetOutputVocHandle( int handle )   = 0;
          virtual ERROR SetSamplingRate( unsigned theSamplingRate )       = 0;
          virtual void  SetUserFlag( unsigned *flag ) = 0;
          virtual ERROR Start( void )                      = 0;
          virtual ERROR Stop( void )                       = 0;


   protected:
             stc_CARD_INFO cardInfoSTC;
             CARD_STATUS currentStatus;
             RIFF_STC chk;
             WAVE_STC  wv;


};

#endif