#ifndef STRUCTUR_H
#define STRUCTUR_H

#include "type.h"

#include "status.h"
#include "cardtype.h"


typedef struct stc_CARD_INFO
{
   /* Le port IO de la carte.
      ----------------------- */
   unsigned ioPort;

   /* L'irq de la carte.
      ------------------ */
   unsigned irq;

   /* Le canal DMA pour le transfer 8 bits.
      ------------------------------------- */
   unsigned dmaChanel8;

   /* Le canal DMA pour le transfer 16 bits.
      ------------------------------------- */
   unsigned dmaChanel16;

   /* La version du dsp de la carte.
      ------------------------------ */
   unsigned char dspMin;
   unsigned char dspMaj;

   /* La vitesse d'echantillonage courante.
      ------------------------------------- */
   unsigned samplingRate;

   /* Les sampling rate minimum et maximum.
      ------------------------------------- */
   unsigned minSamplingRate;
   unsigned maxSamplingRate;

   /* Le type de carte et le nom de la carte.
      --------------------------------------- */
   CARDTYPE cardType;
   char    *cardName;

   /* L'adresse du  buffer de donnee a jouer
      ainsi que sa longueur.
      -------------------------------------- */
   char    *outBufPTR;
   unsigned outBufLength;

   /* Le file handle a utilise lorsque l'on
      joue un fichier.
      ------------------------------------- */
   int      handle;

   /* Le type de fichier a jouer.
      --------------------------- */
   FILE_TYPE fType;

   /* L'evenement courrant.
      --------------------- */
   CARD_STATUS event;
};

#endif