/*--------------------------------------------------------------------------*/
/*          Header file for SoftJeff modules. Copyright 1994.               */
/*                                                                          */
/*Date   :10-04-1994                                                        */
/*Version:1.0                                                               */
/*Author :Jean-Francois Belleau                                             */
/*File Name:TYPE.H                                                          */
/*--------------------------------------------------------------------------*/
#ifndef TYPE_H
#define TYPE_H


/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

                         W A V E  F I L E  F O R M A T
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
*/

typedef struct RIFF_STC
{
   unsigned long id;
   unsigned long size;
};


typedef struct FORMAT_STC
{
   unsigned char id[4];
   unsigned long size;
   unsigned tag;
   unsigned nbChannel;
   unsigned long smpRate;
   unsigned long avgByteSec;
   unsigned blockallign;
   unsigned format;
};

typedef struct DATA_STC
{
   unsigned char id[4];
   unsigned long size;
};

typedef struct WAVE_STC
{
   unsigned char id[4];
   FORMAT_STC   fmt;
   DATA_STC     wav;
};




/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

                           V O C  F I L E  F O R M A T
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
*/


typedef struct VOC_HEADER_STC
{
   char signature[19];
   char eof;
   unsigned dataBlockOffset;
   unsigned version;
   unsigned idCode;
};

typedef struct VOC_VOICE_DATA_STC
{
   unsigned char rate;
   unsigned char pack;
};

typedef struct VOC_VOICE_CONTINUATION_STC
{
   unsigned char length1;
   unsigned char length2;
   unsigned char length3;
};

typedef struct VOC_SILENCE_STC
{
   unsigned period;
   unsigned char rate;
};

typedef struct VOC_MARKER_STC
{
   unsigned period;
};

typedef struct VOC_REPEAT_LOOP_STC
{
   unsigned count;
};


typedef struct VOC_EXTENDED_BLOCK_STC
{
   unsigned rate;
   unsigned char pack;
   unsigned char mode;
};



#define VOC_V1     0x010A

#define voc_TERMINATOR           0
#define voc_VOICE_DATA           1
#define voc_VOICE_CONTINUATION   2
#define voc_SILENCE              3
#define voc_MARKER               4
#define voc_ASCII_TEXT           5
#define voc_REPEAT_LOOP          6
#define voc_END_REPEAT_LOOP      7
#define voc_EXTENDED_BLOCK       8

#define voc_8_BITS                0
#define voc_4_BITS                1
#define voc_2_6_BITS              2
#define voc_2_BITS                3




/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

                           M I S C. D E F I N E
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
*/



enum bool { FALSE = 0,
            TRUE  = 1
          };


enum FILE_TYPE
{
   NO_TYPE = 0,
   RAW,
   WAVE,
   VOC
};

#define MONO       0
#define STEREO     1



#endif