/******************************************************************************

Copyright (C) 1992,1993 Tony Robinson

Permission is granted to use this software for non-commercial purposes.  It
may be copied and distributed freely, provided that this notice is copied and
distributed with it.  Modified versions may be distributed with the same
permissions and restrictions, provided that clear notice of the alterations
is given.  This software carries no warranty, expressed or implied.  The user
assumes all risks, known or unknown, direct or indirect, which involve this
software in any way.

Dr Tony Robinson
Cambridge University Engineering Department
Trumpington Street, Cambridge, CB2 1PZ, UK.
ajr@eng.cam.ac.uk     voice: +44-223-332815

******************************************************************************/

# include <stdio.h>
# include "shorten.h"

unsigned char linear2ulaw(/* int */);
int ulaw2linear(/* unsigned char */);

# define USIZE 256
# define HUSIZE 128
# define SHIFTSIZE 13

long **long2d(n0, n1) int n0, n1; {
  long **array0;

  if((array0 = (long**) malloc(n0 * sizeof(long*) +n0*n1*sizeof(long)))!=NULL){
    long *array1 = (long*) (array0 + n0);
    int i;
    
    for(i = 0; i < n0; i++)
      array0[i] = array1 + i * n1;
  }
  return(array0);
}

int main() {
  int shift, i;
  int tab[USIZE];
  long **forwardmap = long2d(SHIFTSIZE, USIZE);
  long **reversemap = long2d(SHIFTSIZE, USIZE);

  for(i = 0; i < USIZE; i++) tab[i] = 0;

  for(shift = 0; shift < SHIFTSIZE; shift++)
    for(i = -(1 << 15); i < (1 << 15); i += 1 << (shift + 3))
      tab[linear2ulaw(i)] = shift;
  printf("int ulaw_maxshift[%d] = {", USIZE);
  for(i = 0; i < USIZE - 1; i++)
    printf("%d,", tab[i]);
  printf("%d};\n\n", tab[USIZE - 1]);

  for(shift = 0; shift < SHIFTSIZE; shift++) {
    int nused;
  
    nused = 0;
    for(i = 255; i >= 128; i--)
      if(tab[i] >= shift) forwardmap[shift][i] = nused++;
    for(i = 255; i >= 128; i--)
      if(tab[i] < shift) forwardmap[shift][i] = nused++;
  
    nused = -1;
    for(i = 126; i >= 0; i--)
      if(tab[i] >= shift) forwardmap[shift][i] = nused--;
    forwardmap[shift][127] = nused--;
    for(i = 126; i >= 0; i--)
      if(tab[i] < shift) forwardmap[shift][i] = nused--;

    for(i = 0; i < USIZE; i++)
      reversemap[shift][forwardmap[shift][i] + HUSIZE] = i;
  }

  for(shift = 0; shift < SHIFTSIZE; shift++)
    for(i = 0; i < USIZE; i++)
      if(forwardmap[shift][reversemap[shift][i]] != i - HUSIZE)
	fprintf(stderr, "identity maping failed for shift: %d\tindex: %d\n",
		shift, i);
  
  printf("int ulaw_inward[%d][%d] = {\n", SHIFTSIZE, USIZE);
  for(shift = 0; shift < SHIFTSIZE; shift++) {
    printf("{");
    for(i = 0; i < USIZE - 1; i++)
      printf("%d,", forwardmap[shift][i]);
    if(shift != SHIFTSIZE - 1)
      printf("%d},\n", forwardmap[shift][USIZE - 1]);
    else
      printf("%d}\n};\n", forwardmap[shift][USIZE - 1]);
  }
  printf("\n");

  printf("int ulaw_outward[%d][%d] = {\n", SHIFTSIZE, USIZE);
  for(shift = 0; shift < SHIFTSIZE; shift++) {
    printf("{");
    for(i = 0; i < USIZE - 1; i++)
      printf("%d,", reversemap[shift][i]);
    if(shift != SHIFTSIZE - 1)
      printf("%d},\n", reversemap[shift][USIZE - 1]);
    else
      printf("%d}\n};\n", reversemap[shift][USIZE - 1]);
  }
  return(0);
}
