/******************************************************************************

Copyright (C) 1992,1993 Tony Robinson

Permission is granted to use this software for non-commercial purposes.  It
may be copied and distributed freely, provided that this notice is copied and
distributed with it.  Modified versions may be distributed with the same
permissions and restrictions, provided that clear notice of the alterations
is given.  This software carries no warranty, expressed or implied.  The user
assumes all risks, known or unknown, direct or indirect, which involve this
software in any way.

Dr Tony Robinson
Cambridge University Engineering Department
Trumpington Street, Cambridge, CB2 1PZ, UK.
ajr@eng.cam.ac.uk     voice: +44-223-332815

******************************************************************************/

# include <stdio.h>
# include <setjmp.h>
# include "shorten.h"
extern char *argv0;

jmp_buf	exitenv;
char	*exitmessage;

void usage_exit_ss(exitcode, string0, string1) int exitcode; char *string0;
     char *string1; {
  if(exitmessage == NULL) {
    fprintf(stderr, "%s: ", argv0);
    fprintf(stderr, string0, string1);
  }
  else
    sprintf(exitmessage, string0, string1);

  usage_exit(exitcode);
}

void usage_exit_sd(exitcode, string, value) int exitcode; char *string;
     int value; {
  if(exitmessage == NULL) {
    fprintf(stderr, "%s: ", argv0);
    fprintf(stderr, string, value);
  }
  else
    sprintf(exitmessage, string, value);

  usage_exit(exitcode);
}

void usage_exit_s(exitcode, string) int exitcode; char *string; {
  if(exitmessage == NULL)
    fprintf(stderr, "%s: %s", argv0, string);
  else
    strcpy(exitmessage, string);

  usage_exit(exitcode);
}

void usage_exit(exitcode) int exitcode; {
  if(exitmessage == NULL) {
    FILE *stream;

    if(exitcode > 0) stream = stderr;
    else stream = stdout;

    fprintf(stream, "%s: version %d.%s\n",argv0,FORMAT_VERSION,BUGFIX_RELEASE);
    fprintf(stream, "usage: %s [-hx] [-a #byte] [-b #sample] [-c #channel] [-m #block]\n\t\t[-p #delay] [-t filetype] [input file] [output file]\n", argv0);
    fprintf(stream, "\t-a %d\tbytes to skip to align file\n", DEFAULT_NSKIP);
    fprintf(stream, "\t-b %d\tblock size\n", DEFAULT_BLOCK_SIZE); 
    fprintf(stream, "\t-c %d\tnumber of channels\n", DEFAULT_NCHAN); 
    fprintf(stream, "\t-h\thelp\n");
    fprintf(stream, "\t-m %d\tnumber of past block for mean estimation\n",
	    DEFAULT_NMEAN);
    fprintf(stream, "\t-p %d\tmaximum LPC predictor order\n", DEFAULT_MAXNLPC);
    fprintf(stream, "\t-t s16\tfiletype {au,s8,u8,s16,u16,s16x,u16x,s16hl,u16hl,s16lh,u16lh}\n");
    fprintf(stream, "\t-v %d\tformat version number\n", FORMAT_VERSION);
    fprintf(stream, "\t-x\textract (all other options are ignored)\n");
    exit(exitcode < 0 ? 0 : exitcode);
  }
  else
    longjmp(exitenv, exitcode);
}

void update_exit_sd(exitcode, string, value) int exitcode; char *string;
     int value; {
  if(exitmessage == NULL) {
    fprintf(stderr, "%s: ", argv0);
    fprintf(stderr, string, value);
  }
  else
    sprintf(exitmessage, string, value);

  update_exit(exitcode);
}

void update_exit_s(exitcode, string) int exitcode; char *string; {
  if(exitmessage == NULL)
    fprintf(stderr, "%s: %s", argv0, string);
  else
    strcpy(exitmessage, string);

  update_exit(exitcode);
}

void update_exit(exitcode) int exitcode; {
  if(exitmessage == NULL) {
    fprintf(stderr, "%s: version %d.%s\n",argv0,FORMAT_VERSION,BUGFIX_RELEASE);
    fprintf(stderr, "%s: a fatal problem has occured\n", argv0);
    fprintf(stderr, "%s: for an update mail ajr@eng.cam.ac.uk\n", argv0);
    exit(exitcode < 0 ? 0 : exitcode);
  }
  else
    longjmp(exitenv, exitcode);
}
