/*
 * Copyright (c) 1987, 1989 University of Maryland
 * Department of Computer Science.  All rights reserved.
 * Permission to copy for any purpose is hereby granted
 * so long as this copyright notice remains intact.
 */

/*
 * getopt - get option letter from argv
 * (From Henry Spencer @ U of Toronto Zoology, slightly edited)
 */

/* 
 * modiifed by Tony Robinson on 27 March 1993 to remove the call to index()
 * and declare strcmp(); and strlen().
*/

#include <stdio.h>

/* BEGIN AJR MOD */
extern int strcmp(/* char*, char* */);
extern int strlen(/* char* */);
/* END AJR MOD */

char	*optarg;	/* Global argument pointer. */
int	optind;		/* Global argv index. */

static char *scan;	/* Private scan pointer. */

int
getopt(argc, argv, optstring)
	register int argc;
	register char **argv;
	char *optstring;
{
	register int c;
	register char *place;

	optarg = NULL;
	if (scan == NULL || *scan == 0) {
		if (optind == 0)
			optind++;
		if (optind >= argc || argv[optind][0] != '-' ||
		    argv[optind][1] == 0)
			return (EOF);
		if (strcmp(argv[optind], "--") == 0) {
			optind++;
			return (EOF);
		}
		scan = argv[optind] + 1;
		optind++;
	}
	c = *scan++;

	/* BEGIN AJR MOD
	   this used to read:
	   place = index(optstring, c);
	   this code modified from code by Steve Lowe (steve@dragonsys.com)
	*/
	{ char *str = optstring;
	  if(str == NULL) place = NULL;
	  while((*str != '\0') && (*str != c)) str++;
	  if(*str == c) place = str;
	  else place = NULL;
	}
	/* END AJR MOD */

	if (place == NULL || c == ':') {
		fprintf(stderr, "%s: unknown option -%c\n", argv[0], c);
		return ('?');
	}
	place++;
	if (*place == ':') {
		if (*scan != '\0') {
			optarg = scan;
			scan = NULL;
		} else {
			if (optind >= argc) {
				fprintf(stderr,
					"%s: missing argument after -%c\n",
					argv[0], c);
				return ('?');
			}
			optarg = argv[optind];
			optind++;
		}
	}
	return (c);
}
