/******************************************************************
 * MATCH.CMD
 *
 * This program calls the various REXX external functions provided in the FILEREXX DLL.
 *******************************************************************/


/* The FileLoadFuncs loads all the rest of the REXX functions in the FILEREXX DLL. */
/* So, we don't have to make calls to RxFuncAdd to add each one of those functions. Of */
/* course, in order to call FileLoadFuncs, we have to add that one. */
CALL RxFuncAdd 'FileLoadFuncs', 'FILEREXX', 'FileLoadFuncs'
CALL FileLoadFuncs




/* ============================ FileDriveMap ============================ */
/* Get list of all used drives */
err = FileDriveMap()
SAY  "FileDriveMap() =" err



/* ============================ FileDriveInfo ============================ */
/* Get info about current drive */
err = FileDevInfo('Info')
IF err = 0 THEN DO
    SAY 'Bytes Free =' Info.0
    SAY 'Bytes Used =' Info.1
    SAY 'Serial Number =' Info.2
    SAY 'Volume Label =' Info.3
    SAY 'Current drive =' Info
END
ELSE SAY  "FileDevInfo('Info') =" err




/* =========================== FileMatchFile ============================ */
/* Initially set handle to 0 */
Handle = 0

SAY 'Searching for *.cmd'

/* Search for a match to '*.cmd' in current directory. Only check read/write files */
DO UNTIL Handle = 0
    err = FileMatchFile('File', 'Handle', '*.cmd',, 'SIZE|DATE')

    /* No error (ie, another match?) */
    IF err = 0 THEN DO

	/* Print filename */
	SAY File '|' File.0 '|' File.1

    END

    /* An error occurred */
    ELSE IF err <> 18 THEN SAY "FileMatchFile('File', 'Handle', '*.cmd',, 'SIZE|DATE') =" err
END




/* =========================== FileMatchFile ============================ */
/* Initially set handle to 0 */
Handle = 0

SAY 'Searching for directories in current directory'

/* Search for a match to '*.*' in current directory. Only check subdirectories */
DO UNTIL Handle = 0
    err = FileMatchFile('File', 'Handle',, 'DIRONLY')

    /* No error (ie, another match?) */
    IF err = 0 THEN DO

	/* Print filename */
	SAY File

    END

    /* An error occurred */
    ELSE IF err <> 18 THEN SAY	"FileMatchFile('File', 'Handle',, 'DIRONLY') =" err
END




/* =========================== FileMatchFile ============================ */
/* Initially set handle to 0 */
Handle = 0

SAY 'Searching for directories in C:\OS2\'

/* Search for a match to '*.*' in C:\OS2. Only check subdirectories */
DO UNTIL Handle = 0
    err = FileMatchFile('File', 'Handle', 'c:\os2\*.*', 'DIRONLY')

    /* No error (ie, another match?) */
    IF err = 0 THEN DO

	/* Print filename */
	SAY File

    END

    /* An error occurred */
    ELSE IF err <> 18 THEN SAY "FileMatchFile('File', 'Handle', 'c:\os2\*.*', 'DIRONLY') =" err
END



/* =========================== FileMatchFile ============================ */
/* Initially set handle to 0 */
Handle = 0

SAY 'Check for existance of match.cmd'

/* Search for a match to 'match.cmd' in current directory. Allow archived files,
   readonly files, and dirs */
DO UNTIL Handle = 0
    err = FileMatchFile('File', 'Handle', 'match.cmd', 'DIR|ARC|RDO')

    /* No error (ie, another match?) */
    IF err = 0 THEN DO

	/* Print filename */
	SAY File

    END

    /* An error occurred */
    ELSE IF err <> 18 THEN SAY	"FileMatchFile('File', 'Handle', 'match.cmd', 'DIR|ARC|RDO') =" err
END




/* An easier way to check for an existance of a file is to simply FileOpen it as so:
handle = FileOpen('match.cmd', 'rs')
IF handle <> 0 THEN DO
    SAY "File exists"
    CALL FileClose(handle)
END
ELSE SAY "File doesn't exist"
*/



/* =============================================================================== */
/* FileDropFuncs: This unloads all of the functions in the FILEREXX DLL. This is not necessary, and
    we could otherwise leave it open for some other REXX script */
CALL FileDropFuncs
