/******************************************************************
 * PARSE.CMD
 *
 * This program calls the various REXX external functions provided in the FILEREXX DLL.
 *
 * Demonstrates using FileGets' parsing features to parse a file of names and
 * addresses.
 *******************************************************************/


/* The FileLoadFuncs loads all the rest of the REXX functions in the FILEREXX DLL. */
/* So, we don't have to make calls to RxFuncAdd to add each one of those functions. Of */
/* course, in order to call FileLoadFuncs, we have to add that one. */
CALL RxFuncAdd 'FileLoadFuncs', 'FILEREXX', 'FileLoadFuncs'
CALL FileLoadFuncs



/* ================================ FilePuts ================================= */
/** Use FilePuts to create the file of names/addresses. It's assumed that the first line of an entry
      will be the person's name. The next line contains his street address. This could be a P.O. Box
      and a street name, separated by a comma. Or, maybe there's an apartment number in there
      separated from the street name with a comma. The third line contains the city/state/country/zip.
      The city is assumed to be the first item on that line, and separated from the remainder of the
      line with a comma. The zip is assumed to be last, and separated by a space. The state and
      country are between the city and zip, and separated by spaces.
 **/
handle = FileOpen('c:\blort', 'w', 'on')

line.1 = "Jeff Glatt"
line.2 = "6 Sycamore Drive East"
line.3 = "New Hartford, NY 13413"
line.4 = "" /* a blank line before the next person's address */
line.5 = "John Q. Public"
line.6 = "13 Elm Street, Apt. 16"
line.7 = "Anytown, New York   18640"
line.8 = ""
line.9 = "IBM"
line.10 = "OS/2 Square"
line.11 = "End of the world, NY  USA  13500"

DO i=1 TO 11
    err = FilePuts(handle, line.i)
END

err = FileClose(handle)


/* ========================= FileGets with parsing ======================== */
handle = FileOpen('c:\blort')
IF handle <> 0 THEN DO

    person=1
    DO FOREVER
	 /* Get the next person's name. Chop up all the pieces of his name according to space separators. Make it all upper
	     case. */
	 FileGets(handle, 'tsc', ' ')

	 /* No more lines? */
	 IF FileArg.0 = 0 THEN LEAVE

	 /* Was this a blank line? If so, skip it */
	 IF FileArg.0 = 1 & FileArg.1 = "" THEN ITERATE

	 /* Print the person's name */
	 SAY "Person #"person" ========================================="
	 SAY "Name:"
	 DO i = 1 to FileArg.0
	     SAY "Arg #"i"="FileArg.i
	 END

	 /* Get the person's street address. Chop up all the pieces according to comma separators. Make it all upper case. */
	 FileGets(handle, 'tsc', ',')

	 /* No more lines? */
	 IF FileArg.0 = 0 THEN LEAVE

	 /* Print the person's street */
	 SAY "Street Address:"
	 DO i = 1 to FileArg.0
	     SAY "Arg #"i"="FileArg.i
	 END

	 /* Get the person's city/state/country/zip. Chop off the state from the head of the line, according to a comma
	     separator. Chop off the zip from the tail of the line, according to a space. Make it all upper case. Note that
	     the city is FileArg.1 because we specified a rightseparator of ','.  We request step match of right separators with
	     no extending the last separator, so this ensures that we only chop off the street. The zip will be FileArg.2
	     because we specified a leftseparator of ' ', also with step match and no extension. The state/country is FileArg.3
	     because that's what is left of the line after we chop off the args. */
	 FileGets(handle, 'tscrl', ',', ' ')

	 /* No more lines? */
	 IF FileArg.0 = 0 THEN LEAVE

	 /* Print the person's city/state/country/zip */
	 SAY "City/State/Country/Zip:"
	 DO i = 1 to FileArg.0
	     SAY "Arg #"i"="FileArg.i
	 END

	 /* Next person */
	 person = person+1
    END

    /* Close the file */
    err = FileClose(handle)

    /* Delete the file */
    err = FileDeleteFile('c:\blort')

END

ELSE SAY "Error opening file"


/* =============================================================================== */
/* FileDropFuncs: This unloads all of the functions in the FILEREXX DLL. This is not necessary, and
    we could otherwise leave it open for some other REXX script */
CALL FileDropFuncs
