#ifndef EAXREVERB_H
#define EAXREVERB_H

#include "ReverbEffect.h"
#include "sample24.h"

typedef struct {
	int SampleRate;
	int ReverbPreset;
	int OnlyReverb;
	ReverbEffect effect;
	EFXEAXREVERBPROPERTIES properties;
	float floatSamplesOut[REVERB_BUFFERSIZE * OUTPUT_CHANNELS];
} EAXReverb;

#ifdef __cplusplus
extern "C" {
#endif
void EAXReverbInit(EAXReverb *reverb, int rate);
void EAXReverbSetPreset(EAXReverb *reverb, int preset);
const char *EAXReverbGetPresetName(int preset);
void EAXReverbSetOnlyReverb(EAXReverb *reverb, int val);
int EAXReverbGetRate(EAXReverb *reverb);
int EAXReverbGetPreset(EAXReverb *reverb);
int EAXReverbGetOnlyReverb(EAXReverb *reverb);
void EAXReverbGenerateChar(EAXReverb *reverb, uint8_t *buffer, int len);
void EAXReverbGenerateShort(EAXReverb *reverb, int16_t *buffer, int len);
void EAXReverbGenerate24(EAXReverb *reverb, Sample24 *buffer, int len);
void EAXReverbGenerateLong(EAXReverb *reverb, int32_t *buffer, int len);
void EAXReverbGenerateFloat(EAXReverb *reverb, float *buffer, int len);
void EAXReverbClose(EAXReverb *reverb);
#ifdef __cplusplus
}
#endif

#endif // EAXREVERB_H
