#include <string.h>
#include "impulse.h"

void GenerateImpulseChar(uint8_t *buffer, int len)
{
	int i;
	buffer[0] = 255;
	buffer[1] = 255;
	buffer += 2;
	for(i = 0; i < len-1; i++)
	{
		buffer[0] = 128;
		buffer[1] = 128;
		buffer += 2;
	}
}

void GenerateImpulseShort(int16_t *buffer, int len)
{
	int i;
	buffer[0] = 32767;
	buffer[1] = 32767;
	buffer += 2;
	for(i = 0; i < len-1; i++)
	{
		buffer[0] = 0;
		buffer[1] = 0;
		buffer += 2;
	}
}

void GenerateImpulse24(Sample24 *buffer, int len)
{
	int i;
	int32_t sample = 8388607;
	buffer[0].Data[0] = sample & 0xFF;
	buffer[0].Data[1] = (sample >> 8) & 0xFF;
	buffer[0].Data[2] = (sample >> 16) & 0xFF;
	buffer[1].Data[0] = sample & 0xFF;
	buffer[1].Data[1] = (sample >> 8) & 0xFF;
	buffer[1].Data[2] = (sample >> 16) & 0xFF;
	buffer += 2;
	for(i = 0; i < len-1; i++)
	{
		memset(&buffer[0], 0, sizeof(Sample24));
		memset(&buffer[1], 0, sizeof(Sample24));
		buffer += 2;
	}
}

void GenerateImpulseLong(int32_t *buffer, int len)
{
	int i;
	buffer[0] = 2147483647;
	buffer[1] = 2147483647;
	buffer += 2;
	for(i = 0; i < len-1; i++)
	{
		buffer[0] = 0;
		buffer[1] = 0;
		buffer += 2;
	}
}

void GenerateImpulseFloat(float *buffer, int len)
{
	int i;
	buffer[0] = 1;
	buffer[1] = 1;
	buffer += 2;
	for(i = 0; i < len-1; i++)
	{
		buffer[0] = 0;
		buffer[1] = 0;
		buffer += 2;
	}
}
