#include <stdlib.h>
#include <string.h>
#include "impulse.h"
#include "wav_writer.h"

int main(int argc, char *argv[])
{
	WavWriter wr;
	int samplerate;
	int numseconds;
	int numsamples;
	void *samples;
	memset(&wr, 0, sizeof(wr));
	samplerate = 44100;
	numseconds = 20;
	numsamples = samplerate*numseconds;
	samples = malloc(numsamples*2*sizeof(uint8_t));
	WavFileOpen(&wr, "IMPULSE8.WAV", samplerate, 8, 2, 1);
	GenerateImpulseChar((uint8_t *)samples, numsamples);
	WavFileWrite(&wr, samples, numsamples);
	WavFileClose(&wr);
	free(samples);
	samples = malloc(numsamples*2*sizeof(int16_t));
	WavFileOpen(&wr, "IMPULSE16.WAV", samplerate, 16, 2, 1);
	GenerateImpulseShort((int16_t *)samples, numsamples);
	WavFileWrite(&wr, samples, numsamples);
	WavFileClose(&wr);
	free(samples);
	samples = malloc(numsamples*2*sizeof(Sample24));
	WavFileOpen(&wr, "IMPULSE24.WAV", samplerate, 24, 2, 1);
	GenerateImpulse24((Sample24 *)samples, numsamples);
	WavFileWrite(&wr, samples, numsamples);
	WavFileClose(&wr);
	free(samples);
	samples = malloc(numsamples*2*sizeof(int32_t));
	WavFileOpen(&wr, "IMPULSE32.WAV", samplerate, 32, 2, 1);
	GenerateImpulseLong((int32_t *)samples, numsamples);
	WavFileWrite(&wr, samples, numsamples);
	WavFileClose(&wr);
	free(samples);
	samples = malloc(numsamples*2*sizeof(float));
	WavFileOpen(&wr, "IMPULSE32FP.WAV", samplerate, 32, 2, 3);
	GenerateImpulseFloat((float *)samples, numsamples);
	WavFileWrite(&wr, samples, numsamples);
	WavFileClose(&wr);
	free(samples);
	return 0;
}
