#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "EAXReverb.h"
#include "impulse.h"
#include "wav_writer.h"

int main(int argc, char *argv[])
{
	int format;
	int samplerate;
	int numseconds;
	int numsamples;
	void *samples;
	format = 1;
	samplerate = 44100;
	numseconds = 20;
	if (argc >= 2 && argv[1])
	{
		format = atoi(argv[1]);
	}
	if (argc >= 3 && argv[2])
	{
		samplerate = atoi(argv[2]);
	}
	if (argc >= 4 && argv[3])
	{
		numseconds = atoi(argv[3]);
	}
	numsamples = samplerate*numseconds;
	if (format == 1)
	{
		samples = malloc(numsamples*2*sizeof(int16_t));
	}
	else if (format == 2)
	{
		samples = malloc(numsamples*2*sizeof(Sample24));
	}
	else if (format == 3)
	{
		samples = malloc(numsamples*2*sizeof(int32_t));
	}
	else if (format == 4)
	{
		samples = malloc(numsamples*2*sizeof(float));
	}
	else
	{
		samples = malloc(numsamples*2*sizeof(uint8_t));
	}
	for (int i = 0; i < 113; i++)
	{
		char filename[256];
		EAXReverb EAX;
		WavWriter wr;
		memset(filename, 0, sizeof(filename));
		memset(&EAX, 0, sizeof(EAX));
		memset(&wr, 0, sizeof(wr));
		EAXReverbInit(&EAX, samplerate);
		EAXReverbSetOnlyReverb(&EAX, 1);
		printf("%s\n", EAXReverbGetPresetName(i));
		EAXReverbSetPreset(&EAX, i);
		strncpy(filename, EAXReverbGetPresetName(i), sizeof(filename));
		strncat(filename, ".WAV", sizeof(filename));
		if (format == 1)
		{
			WavFileOpen(&wr, filename, samplerate, 16, 2, 1);
			GenerateImpulseShort((int16_t *)samples, numsamples);
			EAXReverbGenerateShort(&EAX, (int16_t *)samples, numsamples);
		}
		else if (format == 2)
		{
			WavFileOpen(&wr, filename, samplerate, 24, 2, 1);
			GenerateImpulse24((Sample24 *)samples, numsamples);
			EAXReverbGenerate24(&EAX, (Sample24 *)samples, numsamples);
		}
		else if (format == 3)
		{
			WavFileOpen(&wr, filename, samplerate, 32, 2, 1);
			GenerateImpulseLong((int32_t *)samples, numsamples);
			EAXReverbGenerateLong(&EAX, (int32_t *)samples, numsamples);
		}
		else if (format == 4)
		{
			WavFileOpen(&wr, filename, samplerate, 32, 2, 3);
			GenerateImpulseFloat((float *)samples, numsamples);
			EAXReverbGenerateFloat(&EAX, (float *)samples, numsamples);
		}
		else
		{
			WavFileOpen(&wr, filename, samplerate, 8, 2, 1);
			GenerateImpulseChar((uint8_t *)samples, numsamples);
			EAXReverbGenerateChar(&EAX, (uint8_t *)samples, numsamples);
		}
		WavFileWrite(&wr, samples, numsamples);
		WavFileClose(&wr);
		EAXReverbClose(&EAX);
	}
	free(samples);
	samples = NULL;
	printf("Done.\n");
	return 0;
}
