#include "resource.h"
#include <windows.h>
#include <tchar.h>
#include <aygshell.h>

#define GSBATMONP_CLASS		_T("GSBATMONP")
#define REG_KEY_BATMON		_T("Software\\GreenSoftware\\GSBatMonPPC")
#define REG_NAME_BATCOUNT	_T("BatteryCount")
#define ID_NOTIFICATION		1
#define ID_TIMER_STATE		1
#define ID_TIMER_STATE_INT	5000
///////////////////////////////////////////////////////////////////////////////
HINSTANCE g_hInst = NULL;
HICON g_hIcon = NULL;
DWORD g_dwUpdate = 0;
DWORD g_dwCount = 0;
DWORD g_dwID = ID_NOTIFICATION;

int g_nHour = -1;
int g_nMin = -1;
SYSTEM_POWER_STATUS_EX g_spse = {0};

// {CFC24712-2A07-4aca-8D8C-46FB8B7C55F5}
static const GUID s_Guid = 
	{ 0xcfc24712, 0x2a07, 0x4aca, { 0x8d, 0x8c, 0x46, 0xfb, 0x8b, 0x7c, 0x55, 0xf5 } };

///////////////////////////////////////////////////////////////////////////////
BOOL InitInstance(HINSTANCE hInst);
LRESULT CALLBACK MainWndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
void OnCreate(HWND hwnd);
void OnClose(HWND hwnd);
void OnTimer(HWND hwnd, UINT uID);
void OnCommand(HWND hwnd, UINT uID);
void GetBatteryCount();
void UpdateBatteryCount();
void UpdateBatteryNotification(HWND hwnd, BOOL fNew);

///////////////////////////////////////////////////////////////////////////////
int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	CreateMutex(NULL, FALSE, GSBATMONP_CLASS);
	if (GetLastError() == ERROR_ALREADY_EXISTS) {
		HWND hwnd = FindWindow(GSBATMONP_CLASS, NULL);
		PostMessage(hwnd, WM_CLOSE, 0, 0);
		return 0;
	}

	if (!InitInstance(hInstance))
		return 0;

	MSG msg;
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return 0;
}

BOOL InitInstance(HINSTANCE hInst)
{
	g_hInst = hInst;

	WNDCLASS	wc;
    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC)MainWndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= g_hInst;
    wc.hIcon			= NULL;
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= GSBATMONP_CLASS;

	if (!RegisterClass(&wc))
		return FALSE;

	HWND hwnd = CreateWindow(GSBATMONP_CLASS, GSBATMONP_CLASS, 0,
		0, 0, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, g_hInst, NULL);

	return hwnd ? TRUE : FALSE;
}

LRESULT CALLBACK MainWndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
		case WM_CREATE:
			OnCreate(hwnd);
			break;
		case WM_CLOSE:
			OnClose(hwnd);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		case WM_TIMER:
			OnTimer(hwnd, wParam);
			break;
		case WM_COMMAND:
			OnCommand(hwnd, LOWORD(wParam));
			break;
		default:
			return DefWindowProc(hwnd, uMsg, wParam, lParam);
	}
	return 0;
}

void OnCreate(HWND hwnd)
{
	GetBatteryCount();
	g_dwUpdate = GetTickCount();
	UpdateBatteryNotification(hwnd, TRUE);
	SetTimer(hwnd, ID_TIMER_STATE, ID_TIMER_STATE_INT, NULL);
}

void OnClose(HWND hwnd)
{
	KillTimer(hwnd, 1);
	SHNotificationRemove(&s_Guid, g_dwID);

	DestroyIcon(g_hIcon);
	DestroyWindow(hwnd);
}

void OnTimer(HWND hwnd, UINT uID)
{
	if (uID == ID_TIMER_STATE) {
		UpdateBatteryNotification(hwnd, FALSE);
	}
}

void OnCommand(HWND hwnd, UINT uID)
{
	if (uID == IDOK) {
		SHNotificationRemove(&s_Guid, g_dwID);
		
		g_dwCount = 0;
		g_nHour = -1;
		g_nMin = -1;
		g_dwUpdate = GetTickCount();
		memset(&g_spse, 0, sizeof(g_spse));
		g_dwID++;
		UpdateBatteryCount();

		UpdateBatteryNotification(hwnd, TRUE);
	}
}

void GetBatteryCount()
{
	HKEY hKey = 0;
	DWORD dwDisposition;
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_BATMON, 
			0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS) {
		DWORD dwBuff;
		DWORD dwType = REG_DWORD;
		DWORD dwDataSize = sizeof(DWORD);
		if (RegQueryValueEx(hKey, REG_NAME_BATCOUNT, 0, &dwType, (LPBYTE)&dwBuff, &dwDataSize) == ERROR_SUCCESS)
			g_dwCount = dwBuff;
		else
			g_dwCount = 0;

		RegCloseKey(hKey);
	}
}

void UpdateBatteryCount()
{
	HKEY hKey = 0;
	DWORD dwDisposition;
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_BATMON, 
			0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS) {
		RegSetValueEx(hKey, REG_NAME_BATCOUNT, 0, REG_DWORD, (LPBYTE)&g_dwCount, sizeof(DWORD));
		RegCloseKey(hKey);
	}
}

void UpdateBatteryNotification(HWND hwnd, BOOL fNew)
{
	TCHAR szFmt[MAX_PATH];
	TCHAR szMessage[MAX_PATH];
	TCHAR szStatus[MAX_PATH];
	SYSTEM_POWER_STATUS_EX spse;
	BOOL fUpdateIcon = FALSE;
	BOOL fUpdateMsg = FALSE;

	GetSystemPowerStatusEx(&spse, TRUE);

	DWORD dwTime = GetTickCount();
	if (dwTime > 20 * 1000) {
		if (spse.ACLineStatus != 1)
			g_dwCount += dwTime - g_dwUpdate;
		else
			g_dwCount = 0;
		UpdateBatteryCount();
		g_dwUpdate = dwTime;
	}

	int nHour = g_dwCount / (1000 * 60 * 60);
	int nMin = (g_dwCount % (1000 * 60 * 60)) / (1000 * 60);

	if (g_spse.ACLineStatus != spse.ACLineStatus ||
		g_spse.BatteryLifePercent != spse.BatteryLifePercent) {
		UINT uID;
		if (spse.ACLineStatus == 1)
			uID = IDI_BATC;
		else if (spse.BatteryLifePercent > 100)
			uID = IDI_BAT0;
		else if (spse.BatteryLifePercent >= 70)
			uID = IDI_BAT4;
		else if (spse.BatteryLifePercent >= 50)
			uID = IDI_BAT3;
		else if (spse.BatteryLifePercent >= 30)
			uID = IDI_BAT2;
		else if (spse.BatteryLifePercent >= 10)
			uID = IDI_BAT1;
		else
			uID = IDI_BAT0;
		DestroyIcon(g_hIcon);
		g_hIcon = (HICON)LoadImage(g_hInst, (LPCTSTR)uID, IMAGE_ICON, 16, 16, 0);
		fUpdateIcon = TRUE;
	}

	if (g_spse.BatteryLifePercent != spse.BatteryLifePercent || 
		g_spse.ACLineStatus != spse.ACLineStatus ||
		g_spse.BatteryFlag != spse.BatteryFlag ||
		g_nHour != nHour || g_nMin != nMin) {
		LoadString(g_hInst, IDS_FMT_INFO, szFmt, MAX_PATH);
		if (spse.ACLineStatus == 1)
			LoadString(g_hInst, (spse.BatteryFlag & 8) ? IDS_CHARGE : IDS_ACLINE, szStatus, MAX_PATH);
		else if (spse.BatteryLifePercent > 100)
			LoadString(g_hInst, IDS_UNKNOWN, szStatus, MAX_PATH);
		else
			szStatus[0] = _T('\0');
		wsprintf(szMessage, szFmt, 
			spse.BatteryLifePercent > 100 ? 0 : spse.BatteryLifePercent, szStatus, nHour, nMin, IDOK);
		
		fUpdateMsg = TRUE;
	}
		
	if (fUpdateIcon || fUpdateMsg) {
		SHNOTIFICATIONDATA shnd;
		memset(&shnd, 0, sizeof(SHNOTIFICATIONDATA));
		shnd.dwID = g_dwID;
		shnd.clsid = s_Guid;
		shnd.npPriority = SHNP_INFORM;
		shnd.csDuration = 0;
		shnd.hwndSink = hwnd;
		shnd.pszHTML = szMessage;
		shnd.hicon = g_hIcon;
		shnd.cbStruct = sizeof(SHNOTIFICATIONDATA);
		shnd.pszTitle = NULL;
		shnd.grfFlags = SHNF_SILENT | SHNF_STRAIGHTTOTRAY;

		DWORD dwUpdate = 0;
		if (fUpdateIcon) dwUpdate |= SHNUM_ICON;
		if (fUpdateMsg) dwUpdate |= SHNUM_HTML;

		if (fNew) {
			TCHAR szTitle[MAX_PATH];
			LoadString(g_hInst, IDS_TITLE, szTitle, MAX_PATH);
			shnd.pszTitle = szTitle;
			SHNotificationAdd(&shnd);
		}
		else
			SHNotificationUpdate(dwUpdate, &shnd);
	}

	g_nHour = nHour;
	g_nMin = nMin;
	g_spse = spse;
}