/*
 *  smclose - change "Smart minimize button" into "Close window button"
 *  Copyright (C) 2003  Y.Nagamidori
 */


#include "smclose.h"

HINSTANCE	g_hInst = NULL;
WNDPROC		g_pOrgProc = NULL;
HWND		g_hwndTaskBar = NULL;

ATOM				RegisterWindowClass(HINSTANCE, LPTSTR);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	MainWndProc(HWND, UINT, WPARAM, LPARAM);
void MainWnd_OnCreate(HWND);
void MainWnd_OnClose(HWND);
LRESULT HHTaskBarHookProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

BOOL IsPocketPC2002()
{
	TCHAR szPlatform[MAX_PATH];
	OSVERSIONINFO osVer;

	GetVersionEx(&osVer);
	if (osVer.dwMajorVersion >= 3) {
		if (SystemParametersInfo(SPI_GETPLATFORMTYPE, sizeof(szPlatform), szPlatform, 0) != 0) {
			if (_tcscmp(szPlatform, _T("PocketPC")) == 0)
				return TRUE;
		}
	}
	return FALSE;
}

BOOL CanCloseWindow(HWND hWnd)
{
	if (!hWnd || !IsWindowVisible(hWnd) || !IsWindowEnabled(hWnd))
		return FALSE;

	TCHAR szClass[64] = _T("");
	GetClassName(hWnd, szClass, 64);

	if (_tcscmp(szClass, _T("HHTaskBar")) == 0 || 
		_tcscmp(szClass, _T("SipWndClass")) == 0 || 
		_tcscmp(szClass, _T("menu_worker")) == 0 || 
		_tcscmp(szClass, _T("Explore")) == 0 || 
		_tcscmp(szClass, _T("Worker")) == 0 || 
		_tcscmp(szClass, _T("DesktopExplorerWindow"))== 0 || 
		_tcscmp(szClass, _T("MSPOutlook")) == 0 ||
		_tcscmp(szClass, _T("MS_SIPBUTTON")) == 0 ||
		_tcscmp(szClass, _T("static")) == 0)
		return FALSE;

	if (GetWindowLong(hWnd, GWL_EXSTYLE) & WS_EX_NOACTIVATE)
		return FALSE;

	if (_tcscmp(szClass, _T("Dialog")) == 0)
		return FALSE;
 
	if (GetWindowLong(hWnd, GWL_EXSTYLE) & 0x80000000)
		return FALSE;
	
	return TRUE;
}

void PostCloseMessage(HWND hWnd)
{
	if (IsWindow(hWnd)) PostMessage(hWnd, WM_CLOSE, 0, 0);
}


int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;

	if (!IsPocketPC2002())
		return 0;

	CreateMutex(NULL, FALSE, SMCLOSE_MUTEX);
	if (GetLastError() == ERROR_ALREADY_EXISTS) {
		HWND hwnd = FindWindow(SMCLOSE_CLASS, NULL);
		PostMessage(hwnd, WM_CLOSE, 0, 0);
		return 0;
	}

	if (!InitInstance (hInstance, nCmdShow)) 
		return FALSE;

	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}

ATOM RegisterWindowClass(HINSTANCE hInstance, LPTSTR pszWindowClass)
{
	WNDCLASS wc;

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = (WNDPROC)MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAIN));
    wc.hCursor = 0;
    wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName	= 0;
    wc.lpszClassName = pszWindowClass;

	return RegisterClass(&wc);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd = NULL;
	g_hInst = hInstance;

	RegisterWindowClass(hInstance, SMCLOSE_CLASS);
	
	hWnd = CreateWindow(SMCLOSE_CLASS, SMCLOSE_TITLE, 0, 0, 0, 0, 0, NULL, NULL, hInstance, NULL);
	if (!hWnd)
		return FALSE;

	return TRUE;
}

LRESULT CALLBACK MainWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_CREATE:
		MainWnd_OnCreate(hWnd);
		break;
	case WM_CLOSE:
		MainWnd_OnClose(hWnd);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, uMsg, wParam, lParam);
   }
   return 0;
}

void MainWnd_OnCreate(HWND hWnd)
{
	g_hwndTaskBar = FindWindow(TASKBAR_CLASS, NULL);
	g_pOrgProc = (WNDPROC)SetWindowLong(g_hwndTaskBar, GWL_WNDPROC, (LONG)HHTaskBarHookProc);
}

void MainWnd_OnClose(HWND hWnd)
{
	if (g_pOrgProc) {
		SetWindowLong(g_hwndTaskBar, GWL_WNDPROC, (LONG)g_pOrgProc);
		g_pOrgProc = NULL;
	}
	DestroyWindow(hWnd);
}

LRESULT HHTaskBarHookProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int x, y;
	RECT rc;
	LRESULT lResult;
	HWND hwndForeground;

	if (uMsg == WM_LBUTTONUP) {
		x = LOWORD(lParam); 
		y = HIWORD(lParam);
		GetWindowRect(hWnd, &rc);

		if ((x >= RECT_WIDTH(&rc) - SM_WIDTH) && x < RECT_WIDTH(&rc) &&
			y >= 0 && y < RECT_HEIGHT(&rc)) {
			
			hwndForeground = GetForegroundWindow();
			if (!CanCloseWindow(hwndForeground))
				return CallWindowProc(g_pOrgProc, hWnd, uMsg, wParam, lParam);

			lResult = CallWindowProc(g_pOrgProc, hWnd, uMsg, wParam, lParam);
			PostCloseMessage(hwndForeground);
			return lResult;
		}
		return CallWindowProc(g_pOrgProc, hWnd, uMsg, wParam, lParam);
	}
	return CallWindowProc(g_pOrgProc, hWnd, uMsg, wParam, lParam);
}
