#include "PocketGnuboy.h"
#include "wce.h"
#include "gx.h"

extern "C" {

#include "defs.h"
#include "fb.h"
#include "hw.h"

void pad_set(byte k, int st);

/*
 * process hardware keys
 */

static int joy_code[JOY_MAX] = {
	0xC3, 0xC4, 0xC1, 0xC2, VK_UP, VK_DOWN, VK_LEFT, VK_RIGHT, 0xC5
};

static GXKeyList gxkl;
static int turboa = 0;
static int turbob = 0;
static int turbosw_a = 0;
static int turbosw_b = 0;
static int vpadstate = VPAD_STATE_NONE;

void joy_init()
{
	GXOpenInput();
#if 0
	gxkl = GXGetDefaultKeys(GX_NORMALKEYS);

	if (!joy_code[0]) {
		joy_code[0] = gxkl.vkUp;
		joy_code[1] = gxkl.vkDown;
		joy_code[2] = gxkl.vkLeft;
		joy_code[3] = gxkl.vkRight;
		joy_code[4] = gxkl.vkA;
		joy_code[5] = gxkl.vkB;
		joy_code[6] = gxkl.vkStart;
		joy_code[7] = gxkl.vkC;
		joy_code[8] = 0;
	}
#endif
}

void joy_close()
{
	GXCloseInput();
}

void joy_process()
{
	BOOL push;
	// A
	if (joy_code[JOY_INDEX_A])
		push = (vpadstate & VPAD_STATE_A) || (GetAsyncKeyState(joy_code[JOY_INDEX_A]) & 0x8000);
	else
		push = (vpadstate & VPAD_STATE_A);
	if (turboa) {
		if (push) {
			pad_set(PAD_A, turbosw_a);
			turbosw_a = !turbosw_a;
		}
		else
			pad_set(PAD_A, 0);
	}
	else pad_set(PAD_A, push);

	// B
	if (joy_code[JOY_INDEX_B])
		push = (vpadstate & VPAD_STATE_B) || (GetAsyncKeyState(joy_code[JOY_INDEX_B]) & 0x8000);
	else
		push = (vpadstate & VPAD_STATE_B);
	if (turbob) {
		if (push) {
			pad_set(PAD_B, turbosw_b);
			turbosw_b = !turbosw_b;
		}
		else
			pad_set(PAD_B, 0);
	}
	else pad_set(PAD_B, push);

	// Select
	if (joy_code[JOY_INDEX_SELECT])
		pad_set(PAD_SELECT, GetAsyncKeyState(joy_code[JOY_INDEX_SELECT]) & 0x8000);

	// Start
	if (joy_code[JOY_INDEX_START])
		pad_set(PAD_START, GetAsyncKeyState(joy_code[JOY_INDEX_START]) & 0x8000);

	// Up
	if (joy_code[JOY_INDEX_UP])
		push = (vpadstate & VPAD_STATE_UP) || (GetAsyncKeyState(joy_code[JOY_INDEX_UP]) & 0x8000);
	else
		push = (vpadstate & VPAD_STATE_UP);
	pad_set(PAD_UP, push);

	// Down
	if (joy_code[JOY_INDEX_DOWN])
		push = (vpadstate & VPAD_STATE_DOWN) || (GetAsyncKeyState(joy_code[JOY_INDEX_DOWN]) & 0x8000);
	else
		push = (vpadstate & VPAD_STATE_DOWN);
	pad_set(PAD_DOWN, push);

	// Left
	if (joy_code[JOY_INDEX_LEFT])
		push = (vpadstate & VPAD_STATE_LEFT) || (GetAsyncKeyState(joy_code[JOY_INDEX_LEFT]) & 0x8000);
	else
		push = (vpadstate & VPAD_STATE_LEFT);
	pad_set(PAD_LEFT, push);

	// Right
	if (joy_code[JOY_INDEX_RIGHT])
		push = (vpadstate & VPAD_STATE_RIGHT) || (GetAsyncKeyState(joy_code[JOY_INDEX_RIGHT]) & 0x8000);
	else
		push = (vpadstate & VPAD_STATE_RIGHT);
	pad_set(PAD_RIGHT, push);
	
	// Pause
	if (joy_code[JOY_INDEX_ESCAPE]) {
		if (GetAsyncKeyState(joy_code[JOY_INDEX_ESCAPE]) & 0x8000)
			Pause();
	}
}

void joy_poll()
{
	/* do nothing here since key events have already been processed */
}

int joy_get_key(int index)
{
	return joy_code[index];
}

void joy_set_key(int index, int key)
{
	joy_code[index] = key;
}

int joy_get_turbo_a()
{
	return turboa;
}

int joy_get_turbo_b()
{
	return turbob;
}

void joy_set_turbo_a(int turbo)
{
	turboa = turbo;
}

void joy_set_turbo_b(int turbo)
{
	turbob = turbo;
}

void joy_set_vpadstate(int state)
{
	vpadstate = state;
}

} // extern "C"
