// zlibce.c
// unzip library for gnuboy for PocketPC
// first author: Y.Nagamidori

#include <stdio.h>
#include "zlib.h"

#if 1
static int romsize_table[256] =
{
	2, 4, 8, 16, 32, 64, 128, 256, 512,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 128, 128, 128
	/* 0, 0, 72, 80, 96  -- actual values but bad to use these! */
};
#endif

int errno;

int check_zip(char* b)
{
	return 
		!((b[0] != 'P') ||
		 (b[1] != 'K') ||
		 (b[2] != 0x03) ||
		 (b[3] != 0x04));		
}

char* inflate_zip(char* b, long* len)
{
	struct z_stream_s zs;
	char bout[16384];
	char* rom = NULL;

	int out, err, size, skip;
	int fnl, exl;
	int init = 1;

	size = out = 0;

	if (*len < 30)
		return NULL;

	if (!check_zip(b))
		return NULL;

	fnl = (b[26])|(b[27]<<8);
	exl = (b[28])|(b[29]<<8);
	skip = fnl + exl + 30;

	if (*len <= skip)
		return NULL;

	memset(&zs, 0, sizeof(zs));
	zs.next_out = bout;
	zs.avail_out = 16384;
	zs.next_in = b + skip;
	zs.avail_in = *len - skip;
	err = Z_OK;

	inflateInit2(&zs, -15);
	while (err != Z_STREAM_END) {
		err = inflate(&zs, Z_PARTIAL_FLUSH);
		if (err != Z_STREAM_END && err != Z_OK)
			return NULL; // error

		if (!rom) {
			rom = malloc(16384);
			size = 16384;
		}
		else if (init && out >= 16384) {
			char *rom_head;
			int romlen;

			rom_head = rom; 
			romlen = romsize_table[rom_head[0x0148]];
			if (!romlen)
				return NULL;
			romlen *= 16384;

			rom = malloc(romlen);
			memcpy(rom, rom_head, out);

			free(rom_head);
			size = romlen;
			init = 0;
		}
	
		if (out + 16384 - zs.avail_out > size)
			return NULL;

		memcpy(rom + out, bout, 16384 - zs.avail_out);
		out += 16384 - zs.avail_out;

		zs.avail_out = 16384;
		zs.next_out = bout;
		zs.next_in = b + (*len - zs.avail_in);

		if (err == Z_STREAM_END)
			break;
	}

	inflateEnd(&zs);
	*len = out;
	return rom;
}