// Header file

typedef struct vgm_file_header
{
	unsigned long lngEOFOffset;
	unsigned long lngVersion;
	unsigned long lngTotalSamples;
	unsigned long lngLoopOffset;
	unsigned long lngLoopSamples;
	unsigned long lngDataOffset;
	unsigned long lngHzYM3812;
	unsigned long lngHzYM3526;
	unsigned long lngHzYMF262;
} VGM_HEADER;
typedef struct vgm_gd3_tag
{
	unsigned long int fccGD3;
	unsigned long int lngVersion;
	unsigned long int lngTagLength;
	wchar_t* strTrackNameE;
	wchar_t* strGameNameE;
	wchar_t* strSystemNameE;
	wchar_t* strAuthorNameE;
	wchar_t* strReleaseDate;
	wchar_t* strCreator;
	wchar_t* strNotes;
} GD3_TAG;

typedef struct fm_instrument_data
{
	unsigned char Operator[0x02][0x5];
	unsigned char FeedbConnect;
	unsigned char Reserved[0x5];
} FM_INSTRUMENT;
typedef struct midi_tempo
{
	signed long int BaseTick;
	unsigned long int Tempo;
	unsigned long int SmplTime;
} MIDI_TEMPO;
typedef struct note_history_data
{
	unsigned char MIDICh;
	bool NoteOn;
	unsigned char Note;
	unsigned char NHeight;
	unsigned char Velocity;
	unsigned char FMChip;
	unsigned char FMChn;
	unsigned char Sustain;		// Bit 0 - Sustain, Bit 1 - Sostenuto
	signed long int Delay;
} NOTE_HISTORY;
typedef struct fm_channel
{
	unsigned char NoteMsk;		// Note Mask for the that play on this FM Channel
								// Bit 0 is used, Bit 1 is used only in Rhythm Mode
	unsigned char MidCh;		// Midi Channel that uses this FM Channel
	unsigned char Ins;			// current FM Instrument on this FM Channel
	unsigned char NoteLast;		// Last Note that was played on this FM Channel
	unsigned short int StnFact;	// Sustain Factor
	signed long int Delay;
} FM_CHN;
typedef struct midi_channel
{
	// General Attributes
	bool IsDrum;				// Is Drum Channel
	unsigned char Ins;			// Instrument
	unsigned char BnkSel[0x02];	// Bank Select (MSB, LSB)
	unsigned char ChnVol[0x02];	// Channel Volume (0x00 - Main Volume, 0x01 - Expression)
	unsigned char Pan;			// Pan Controller
	signed long int Pitch;		// Pitch Bend
	unsigned char ModDepth;		// Modulation Depth (Controller Value)
	unsigned char RPNVal[0x04];	// current RPN/NRPN Setup (MSB, LSB, Data MSB, Data LSB)
	unsigned char PbDepth;		// PitchBend Depth in Semitones
	signed char TuneFine;
	signed char TuneCoarse;
	unsigned char SustainOn;	// Bit 0 - Sustain, Bit 1 - Sostenuto
	
	// Calculation Variables
	unsigned short int ModStep;	// Modulation Step
	signed short int ModPb;		// Modulation Pitch
	signed long int TunePb;		// Tuning Pitch Bend
} MIDI_CHN;

typedef struct cmf_file_header
{
	unsigned long int fccCMF;
	unsigned short int shtVersion;
	unsigned short int shtOffsetInsData;
	unsigned short int shtOffsetMusData;
	unsigned short int shtTickspQuarter;
	unsigned short int shtTickspSecond;
	unsigned short int shtOffsetTitle;
	unsigned short int shtOffsetAuthor;
	unsigned short int shtOffsetComments;
	unsigned char bytChnUsed[0x10];
	unsigned short int shtInstrumentCount;
	unsigned short int shtTempo;
} CMF_HEADER;
typedef struct cmf_instrument_table
{
	unsigned char Character[0x02];
	unsigned char ScaleLevel[0x02];
	unsigned char AttackDecay[0x02];
	unsigned char SustnRelease[0x02];
	unsigned char WaveSelect[0x02];
	unsigned char FeedbConnect;
	unsigned char Reserved[0x5];
} CMF_INSTRUMENT;

typedef struct midi_file_header
{
	unsigned short int shtFormat;
	unsigned short int shtTracks;
	unsigned short int shtResolution;	// Ticks per Quarter
} MID_HEADER;

const unsigned long int FCC_CMF = 0x464D5443;		// 'CTMF'
const unsigned long int FCC_MIDH = 0x6468544D;		// 'MThd'
const unsigned long int FCC_MIDT = 0x6B72544D;		// 'MTrk'
//const unsigned long int FCC_LAA1 = 0x007F4441;	// ('AD' + 0x7F + 0x00)
const unsigned short int TCC_LAA1 = 0x4441;			// 'AD'
const unsigned long int FCC_LAA2 = 0x204C4441;		// 'ADL '

const unsigned char FM_MID = 0x00;
const unsigned char FM_CMF = 0x01;
const unsigned char FM_LAA1 = 0x02;
const unsigned char FM_LAA2 = 0x03;
const unsigned char FM_UNDEF = 0xFF;

// Table from Windows FM Driver
// every entry is used for 4 volume steps
// 00 (minimum) ... 3F (maximum)
const unsigned char midi_fm_vol_table[0x20] =
{	0x00, 0x00, 0x11, 0x15, 0x19, 0x1D, 0x22, 0x24,
	0x26, 0x28, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x34, 0x35, 0x35,
	0x36, 0x36, 0x37, 0x37, 0x38, 0x38, 0x39, 0x39};

// Windows 95 FM Drum Note Table
static const unsigned char WINFM_DRUM_FREQ[0x80] =
{	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0x23, 0x23, 0x34, 0x30, 0x3A,
	0x3C, 0x2F, 0x2B, 0x31, 0x2B, 0x33, 0x2B, 0x36,
	0x39, 0x48, 0x3C, 0x4C, 0x54, 0x24, 0x4C, 0x54,
	0x53, 0x54, 0x18, 0x4D, 0x3C, 0x41, 0x3B, 0x34,
	0x2D, 0x47, 0x3C, 0x3A, 0x35, 0x41, 0x47, 0x3D,
	0x3D, 0x2D, 0x30, 0x45, 0x44, 0x0F, 0x1A, 0x0C,
	0x20, 0x10, 0x15, 0x19, 0x1B, 0x14, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

static const unsigned char volume_table[] = {
	0, 4, 7, 11,
	13, 16, 18, 20,
	22, 24, 26, 27,
	29, 30, 31, 33,
	34, 35, 36, 37,
	38, 39, 40, 41,
	42, 43, 44, 44,
	45, 46, 47, 47,
	48, 49, 49, 50,
	51, 51, 52, 53,
	53, 54, 54, 55,
	55, 56, 56, 57,
	57, 58, 58, 59,
	59, 60, 60, 60,
	61, 61, 62, 62,
	62, 63, 63, 63
};

static const unsigned char MT32toGM[0x80] = {
//	  0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
	  0,   1,   0,   2,   4,   4,   5,   3,  16,  17,  18,  16,  16,  19,  20,  21, // 0x
	  6,   6,   6,   7,   7,   7,   8, 112,  62,  62,  63,  63,  38,  38,  39,  39, // 1x
	 88,  95,  52,  98,  97,  99,  14,  54, 102,  96,  53, 102,  81, 100,  14,  80, // 2x
	 48,  48,  49,  45,  41,  40,  42,  42,  43,  46,  45,  24,  25,  28,  27, 104, // 3x
	 32,  32,  34,  33,  36,  37,  35,  35,  79,  73,  72,  72,  74,  75,  64,  65, // 4x
	 66,  67,  71,  71,  68,  69,  70,  22,  56,  59,  57,  57,  60,  60,  58,  61, // 5x
	 61,  11,  11,  98,  14,   9,  14,  13,  12, 107, 107,  77,  78,  78,  76,  76, // 6x
	 47, 117, 127, 118, 118, 116, 115, 119, 115, 112,  55, 124, 123,   0,  14, 117  // 7x
};

