// Sounds.cpp : Legt die Initialisierungsroutinen fr die DLL fest.
//

#include <windows.h>
#include <stdio.h>
#include <malloc.h>

#include "Stream.h"

//#define WAVEOUT_CALLBACK_THREAD

typedef struct wave_fmt
{
	unsigned short int wFormatTag;
	unsigned short int nChannels;
	unsigned long int nSamplesPerSec;
	unsigned long int nAvgBytesPerSec;
	unsigned short int nBlockAlign;
	unsigned short int wBitsPerSample;
} WAVE_FORMAT;

/*#ifndef WAVEOUT_CALLBACK_THREAD
void CALLBACK WaveOutCallbackFnc(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1,
								 DWORD dwParam2);
#else
DWORD WINAPI WaveOutCallbackThr(void* Arg);
#endif*/
static DWORD WINAPI WaveOutThread(void* Arg);

WAVEFORMATEX WaveFmt;
unsigned long int SampleRate;

unsigned long int BlockLen;
static HWAVEOUT hWaveOut;
static bool WaveOutOpen;
static WAVEHDR WaveHdrOut[AUDIOBUFFERS];
static char BufferOut[AUDIOBUFFERS][BUFFERSIZE + 0x100];
static HANDLE hWaveOutThread;
//static DWORD WaveOutCallbackThrID;
extern bool PauseThread;
extern bool ThreadPauseEnable;
extern bool ThreadPauseConfrm;
static bool CloseThread;

bool SoundLog;
static FILE* hFile;
unsigned long int SndLogLen;

unsigned long int BlocksSent;
unsigned long int BlocksPlayed;

char SoundLogFile[MAX_PATH];

unsigned char SaveFile(unsigned long int FileLen, void* TempData)
{
	//char ResultStr[0x100];
	long int TempVal[0x2];
	
	if (TempData == NULL)
	{
		switch (FileLen)
		{
		/*case 0x80000000:
			SndLogLen = 0;
			hFile = fopen("SoundLog.wav","wb");
			fclose(hFile);
			break;*/
		case 0x00000000:
			SndLogLen = 0;
			//hFile = fopen("SoundLog.wav","wb");
			hFile = fopen(SoundLogFile,"wb");
			if (hFile == NULL)
			{
				// Save Error
				return 0xFF;
			}
			fseek(hFile, 0x00000000, SEEK_SET);
			TempVal[0x0] = 0x46464952;
			TempVal[0x1] = 0x00000000;
			fwrite(&TempVal[0x0], 4, 2, hFile);
			TempVal[0x0] = 0x45564157;
			TempVal[0x1] = 0x20746D66;
			fwrite(&TempVal[0x0], 4, 2, hFile);
			TempVal[0x0] = 0x00000010;
			fwrite(&TempVal[0x0], 4, 1, hFile);
			fwrite(&WaveFmt, TempVal[0x0], 1, hFile);
			TempVal[0x0] = 0x61746164;
			TempVal[0x1] = 0x00000000;
			fwrite(&TempVal[0x0], 4, 2, hFile);
			break;
		case 0xFFFFFFFF:
			TempVal[0x1] = SndLogLen * SAMPLESIZE;
			TempVal[0x0] = TempVal[0x1] + 0x00000024;
			fseek(hFile, 0x0004, SEEK_SET);
			fwrite(&TempVal[0x0], 4, 1, hFile);
			fseek(hFile, 0x0028, SEEK_SET);
			fwrite(&TempVal[0x1], 4, 1, hFile);
			fclose(hFile);
			hFile = NULL;
			break;
		}
	}
	else
	{
		//fseek(hFile, 0x00000000, SEEK_END);
		//TempVal[0x0] = ftell(hFile);
		//TempVal[0x1] = fwrite(TempData, 1, FileLen, hFile);
		SndLogLen += fwrite(TempData, SAMPLESIZE, FileLen, hFile);
		//sprintf(ResultStr, "Position:\t%ld\nBytes written:\t%ld\nFile Length:\t%lu\nPointer:\t%p",
		//		TempVal[0], TempVal[1], FileLen, TempData);
		//AfxMessageBox(ResultStr);
	}
	
	return 0x00;
}

unsigned char SoundLogging(unsigned char Mode)
{
	unsigned char RetVal;
	
	RetVal = (unsigned char)SoundLog;
	switch (Mode)
	{
	case 0x00:
		SoundLog = false;
		break;
	case 0x01:
		SoundLog = true;
		if (WaveOutOpen && hFile == NULL)
		{
			SaveFile(0x00000000, NULL);
		}
		break;
	case 0xFF:
		break;
	default:
		RetVal = 0xA0;
		break;
	}
	
	return RetVal;
}

unsigned char StartStream(unsigned char DeviceID)
{
	if (WaveOutOpen)
		return 0xD0;	// Thread is already active
	
	unsigned short int Cnt;
	unsigned long int RetVal;
	HANDLE WaveOutThreadHandle;
	DWORD WaveOutThreadID;
	//char TestStr[0x80];
	
	// Init Audio
	WaveFmt.wFormatTag = WAVE_FORMAT_PCM;
	WaveFmt.nChannels = 2;
	WaveFmt.nSamplesPerSec = SampleRate;
	WaveFmt.wBitsPerSample = 16;
	WaveFmt.nBlockAlign = WaveFmt.wBitsPerSample * WaveFmt.nChannels / 8;
	WaveFmt.nAvgBytesPerSec = WaveFmt.nSamplesPerSec * WaveFmt.nBlockAlign;
	WaveFmt.cbSize = 0;
	if (DeviceID == 0xFF)
		return 0x00;
	
	PauseThread = true;
	ThreadPauseConfrm = false;
	CloseThread = false;
/*#ifdef WAVEOUT_CALLBACK_THREAD
	WaveOutThreadHandle = CreateThread(NULL, 0x00, &WaveOutCallbackThr, NULL, 0x00,
										&WaveOutCallbackThrID);
	if(WaveOutThreadHandle == NULL)
	{
		return 0xC8;		// CreateThread failed
	}
	CloseHandle(WaveOutThreadHandle);
#endif*/
	
	ThreadPauseEnable = true;
	WaveOutThreadHandle = CreateThread(NULL, 0x00, &WaveOutThread, NULL, 0x00,
										&WaveOutThreadID);
	if(WaveOutThreadHandle == NULL)
	{
		return 0xC8;		// CreateThread failed
	}
	CloseHandle(WaveOutThreadHandle);
	
/*#ifndef WAVEOUT_CALLBACK_THREAD
	RetVal = waveOutOpen(&hWaveOut, ((UINT)DeviceID - 1), &WaveFmt, (DWORD)WaveOutCallbackFnc,
						0x00, CALLBACK_FUNCTION);
#else
	RetVal = waveOutOpen(&hWaveOut, ((UINT)DeviceID - 1), &WaveFmt, WaveOutCallbackThrID,
						0x00, CALLBACK_THREAD);
#endif*/
	RetVal = waveOutOpen(&hWaveOut, ((UINT)DeviceID - 1), &WaveFmt, 0x00, 0x00, CALLBACK_NULL);
	if(RetVal != MMSYSERR_NOERROR)
	{
		CloseThread = true;
		return 0xC0;		// waveOutOpen failed
	}
	WaveOutOpen = true;
	
	//sprintf(TestStr, "Buffer 0,0:\t%p\nBuffer 0,1:\t%p\nBuffer 1,0:\t%p\nBuffer 1,1:\t%p\n",
	//		&BufferOut[0][0], &BufferOut[0][1], &BufferOut[1][0], &BufferOut[1][1]);
	//AfxMessageBox(TestStr);
	for (Cnt = 0x00; Cnt < AUDIOBUFFERS; Cnt ++)
	{
		WaveHdrOut[Cnt].lpData = BufferOut[Cnt];	// &BufferOut[Cnt][0x00];
		WaveHdrOut[Cnt].dwBufferLength = BUFFERSIZE;
		WaveHdrOut[Cnt].dwBytesRecorded = 0x00;
		WaveHdrOut[Cnt].dwUser = 0x00;
		WaveHdrOut[Cnt].dwFlags = 0x00;
		WaveHdrOut[Cnt].dwLoops = 0x00;
		WaveHdrOut[Cnt].lpNext = NULL;
		WaveHdrOut[Cnt].reserved = 0x00;
		RetVal = waveOutPrepareHeader(hWaveOut, &WaveHdrOut[Cnt], sizeof(WAVEHDR));
		WaveHdrOut[Cnt].dwFlags |= WHDR_DONE;
	}
	
	if (SoundLog)
	{
		SaveFile(0x00000000, NULL);
	}
	
	PauseThread = false;
	
	return 0x00;
}

unsigned char StopStream(void)
{
	if (! WaveOutOpen)
		return 0xD8;	// Thread is not active
	
	unsigned long int RetVal;
	unsigned short int Cnt;
	
	CloseThread = true;
	for (Cnt = 0; Cnt < 100; Cnt ++)
	{
		Sleep(1);
		if (hWaveOutThread == NULL)
			break;
	}
	if (hFile != NULL)
	{
		SaveFile(0xFFFFFFFF, NULL);
	}
	WaveOutOpen = false;
	
	RetVal = waveOutReset(hWaveOut);
	for (Cnt = 0x00; Cnt < AUDIOBUFFERS; Cnt ++)
	{
		RetVal = waveOutUnprepareHeader(hWaveOut, &WaveHdrOut[Cnt], sizeof(WAVEHDR));
	}
	RetVal = waveOutClose(hWaveOut);
	if(RetVal != MMSYSERR_NOERROR)
	{
		return 0xC4;		// waveOutClose failed  -- but why ???
	}
	
	return 0x00;
}

void PauseStream(bool PauseOn)
{
	if (! WaveOutOpen)
		return;	// Thread is not active
	
	unsigned long int RetVal;
	
	switch(PauseOn)
	{
	case true:
		RetVal = waveOutPause(hWaveOut);
		break;
	case false:
		RetVal = waveOutRestart(hWaveOut);
		break;
	}
	
	return;
}

//void FillBuffer(WAVE_16BS* Buffer, unsigned long int BufferSize)
// moved to VGMPlay.cpp

/*#ifndef WAVEOUT_CALLBACK_THREAD
void CALLBACK WaveOutCallbackFnc(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1,
								 DWORD dwParam2)
{
	switch(uMsg)
	{
	case WOM_OPEN:
		break;
	case WOM_DONE:
		((WAVEHDR*)dwParam1)->dwUser &= ~0x00000001;	// set Buffer free
		BlocksPlayed ++;
		break;
	case WOM_CLOSE:
		break;
	}
	
	return;
}
#endif

#ifdef WAVEOUT_CALLBACK_THREAD
DWORD WINAPI WaveOutCallbackThr(void* Arg)
{
	MSG Msg;
	unsigned long int RetVal;
	
	RetVal = SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_TIME_CRITICAL);
	if (! RetVal)
	{
		// Error by setting priority
	}
	while(GetMessage(&Msg, NULL, 0, 0))
	{
		if (Msg.message == MM_WOM_DONE)
		{
			((WAVEHDR*)Msg.lParam)->dwUser &= ~0x00000001;	// set Buffer free
			BlocksPlayed ++;
		}
		else if (Msg.message == MM_WOM_CLOSE)
		{
			break;
		}
	}
	
	return 0x00000000;
}
#endif*/

static DWORD WINAPI WaveOutThread(void* Arg)
{
#ifdef NDEBUG
	unsigned long int RetVal;
#endif
	unsigned short int CurBuf;
	WAVE_16BS* TempBuf;
	//char TestStr[0x80];
	
	hWaveOutThread = GetCurrentThread();
#ifdef NDEBUG
	RetVal = SetThreadPriority(hWaveOutThread, THREAD_PRIORITY_TIME_CRITICAL);
	if (! RetVal)
	{
		// Error by setting priority
		// try a lower priority, because too low priorities cause sound stuttering
		RetVal = SetThreadPriority(hWaveOutThread, THREAD_PRIORITY_HIGHEST);
	}
#endif
	
	BlocksSent = 0x00;
	BlocksPlayed = 0x00;
	while (! CloseThread)
	{
		while (PauseThread && ! CloseThread)
		{
			ThreadPauseConfrm = true;
			Sleep(1);
		}
		if (CloseThread)
			break;
		
		for (CurBuf = 0x00; CurBuf < AUDIOBUFFERS; CurBuf ++)
		{
			//if (! (WaveHdrOut[CurBuf].dwUser & 0x00000001))
			if (WaveHdrOut[CurBuf].dwFlags & WHDR_DONE)
			{
				BlocksPlayed ++;
				
				TempBuf = (WAVE_16BS*)WaveHdrOut[CurBuf].lpData;
				
				FillBuffer(TempBuf, SMPL_P_BUFFER);
				//WaveHdrOut[CurBuf].dwUser = 0x00000001;	// Buffer belegt markieren
				waveOutWrite(hWaveOut, &WaveHdrOut[CurBuf], sizeof(WAVEHDR));
				if (SoundLog && hFile != NULL)
					SaveFile(SMPL_P_BUFFER, TempBuf);
				BlocksSent ++;
				//CurBuf = 0x00;
				//break;
			}
			if (CloseThread)
				break;
		}
		Sleep(1);
	}
	
	hWaveOutThread = NULL;
	return 0x00000000;
}
