// Sounds.h : Haupt-Header-Datei fr die Sounds-DLL
//

#include <mmsystem.h>

typedef struct waveform_16bit_stereo
{
	signed short int Left;
	signed short int Right;
} WAVE_16BS;

typedef struct waveform_32bit_stereo
{
	signed long int Left;
	signed long int Right;
} WAVE_32BS;

const unsigned long int SAMPLESIZE = sizeof(WAVE_16BS);
const unsigned long int BUFFERSIZE = 0x06E4;	// Gre Soundcard Buffer in Bytes
const unsigned short int AUDIOBUFFERS = 10;	// Anzahl Soundcard Buffer, Minimum ist 2
//			1 Audio-Buffer = 10 msec, Min: 5
//const unsigned long int SMPL_P_BUFFER = BUFFERSIZE / SAMPLESIZE;
#define SMPL_P_BUFFER	(BUFFERSIZE / SAMPLESIZE)
//	Optimal:	Buffersize:		0x400
//				Buffercount:	0x10

unsigned char SaveFile(unsigned long int FileLen, void* TempData);
unsigned char SoundLogging(unsigned char Mode);
unsigned char StartStream(unsigned char DeviceID);
unsigned char StopStream(void);
void PauseStream(bool PauseOn);
void FillBuffer(WAVE_16BS* Buffer, unsigned long int BufferSize);

extern char SoundLogFile[MAX_PATH];