#include <stdio.h>
#include <stdlib.h>
#include "resampler.h"
#include "wav_header.h"

static int fileexists(const char * filename)
{
	FILE *check;
	if (check = fopen(filename, "r"))
	{
		fclose(check);
		return 1;
	}
	return 0;
}

int main(int argc, char *argv[])
{
	int numsamples;
	int numsamples_new;
	short *samples;
	short *samples_new;
	int samplerate_new;
	int size;
	FILE *in;
	FILE *out;
	wav_header head;
	void *resampler;
	int bufpos;
	if (argc != 4)
	{
		printf("Usage: %s [input].wav [output].wav [new sample rate].\n", argv[0]);
		return 0;
	}
	if (fileexists(argv[1]) == 0)
	{
		printf("%s doesn't exist.\n", argv[1]);
		return 0;
	}
	if (fileexists(argv[2]) == 1)
	{
		printf("%s already exists.\n", argv[2]);
		return 0;
	}
	in = fopen(argv[1], "rb");
	if (in == NULL)
	{
		printf("Failed to open %s.\n", argv[1]);
		return 0;
	}
	fread(&head, sizeof(head), 1, in);
	if (head.fmt_chunk_size != 16)
	{
		printf("%s Isn't a valid PCM WAV file.\n", argv[1]);
		return 0;
	}
	if (head.audio_format != 1)
	{
		printf("%s Isn't a valid PCM WAV file.\n", argv[1]);
		return 0;
	}
	if (head.num_channels != 2)
	{
		printf("%s Isn't a stereo WAV file.\n", argv[1]);
		return 0;
	}
	if (head.bit_depth != 16)
	{
		printf("%s Isn't a 16 bit WAV file.\n", argv[1]);
		return 0;
	}
	if (head.sample_alignment != 4)
	{
		printf("%s Isn't a stereo 16 bit WAV file.\n", argv[1]);
		return 0;
	}
	samples = malloc(head.data_bytes);
	numsamples = head.data_bytes / 4;
	fread(samples, 4, numsamples, in);
	fclose(in);
	out = fopen(argv[2], "wb");
	if (out == NULL)
	{
		printf("Failed to open %s.\n", argv[2]);
		return 0;
	}
	fwrite(&head, sizeof(head), 1, out);
	samplerate_new = atoi(argv[3]);
	numsamples_new = (int) numsamples / (head.sample_rate / 1000.f) * (samplerate_new / 1000.f) + 0.5f;
	samples_new = malloc(numsamples_new*4);
	printf("Resampling.\n");
	resampler = resampler_create();
	bufpos = 0;
	if (resampler)
	{
		resampler_set_rate(resampler, (double)head.sample_rate / (double)samplerate_new);
		for (int i = 0; i < numsamples_new; i++)
		{
			sample_t ls, rs;
			int to_write = resampler_get_min_fill(resampler);
			for (int j = 0; j < to_write; j++)
			{
				resampler_write_pair(resampler, samples[bufpos], samples[bufpos+1]);
				bufpos += 2;
				if (bufpos >= numsamples*2)
				{
					bufpos = numsamples*2 - 2;
				}
			}
			resampler_peek_pair(resampler, &ls, &rs);
			resampler_read_pair(resampler, &ls, &rs);
			if ((ls + 0x8000) & 0xFFFF0000) ls = (ls >> 31) ^ 0x7FFF;
			if ((rs + 0x8000) & 0xFFFF0000) rs = (rs >> 31) ^ 0x7FFF;
			samples_new[0] = (short)ls;
			samples_new[1] = (short)rs;
			samples_new += 2;
		}
		samples_new -= numsamples_new*2;
		resampler_clear(resampler);
		resampler_destroy(resampler);
	}
	head.sample_rate = samplerate_new;
	head.byte_rate = 4*samplerate_new;
	fwrite(samples_new, 4, numsamples_new, out);
	free(samples_new);
	free(samples);
	size = ftell(out);
	head.wav_size = size-8;
	head.data_bytes = size-sizeof(head);
	fseek(out, 0, SEEK_SET);
	fwrite(&head, sizeof(head), 1, out);
	fclose(out);
	printf("Done.\n");
	return 0;
}
