typedef struct call_stack
{
    unsigned long edi;
    unsigned long esi;
    unsigned long ebp;
    unsigned long res;
    unsigned long ebx;
    unsigned long edx;
    unsigned long ecx;
    unsigned long eax;
    unsigned int  flags;
    unsigned int  es;
    unsigned int  ds;
    unsigned int  fs;		// should be zero
    unsigned int  gs;           // should be zero

    unsigned int  ip;
    unsigned int  cs;
    unsigned int  sp;
    unsigned int  ss;
};

typedef struct
{
    unsigned char buffer[128];
    unsigned int flags;
} CapStr ;

typedef struct
{
    unsigned char minor, major;
    unsigned int flags;
    unsigned int processor;
    unsigned char PIC_Master, PIC_Slave;
} VerStr ;

int get_version( VerStr *vs );
unsigned long GetBaseAddress( unsigned int sel );
int call_real_mode(void *func);
int get_capabilities( CapStr *cs );
int MapConventional_Memory( unsigned long handle, unsigned long base_offset, unsigned long num_pages, unsigned long lin_addr );
int AllocLinMemBlock( unsigned long *handle, unsigned long block_size, unsigned long flags, unsigned long *lin_addr );
int MapDevice_Memory( unsigned long handle, unsigned long base_offset, unsigned long num_pages, unsigned long lin_addr );
