/*

    TiMidity -- Experimental MIDI to WAVE converter
    Copyright (C) 1995 Tuukka Toivonen <titoivon@snakemail.hut.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    dumb_ctl.c
   
    */
#define TIMID_VERSION	" 0.2"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <conio.h>

#include "config.h"
#include "common.h"
#include "output.h"
#include "controls.h"
static int  last_x=0;
static int  last_y=0;

static void ctl_refresh(void);
static void ctl_total_time(int tt);
static void ctl_master_volume(int mv);
static void ctl_file_name(char *name);
static void ctl_current_time(int ct);
static void ctl_note(int v);
static void ctl_program(int ch, int val);
static void ctl_volume(int channel, int val);
static void ctl_expression(int channel, int val);
static void ctl_panning(int channel, int val);
static void ctl_sustain(int channel, int val);
static void ctl_pitch_bend(int channel, int val);
static void ctl_reset(void);
static int ctl_open(int using_stdin, int using_stdout);
static void ctl_close(void);
static int ctl_read(int32 *valp);
static int cmsg(int type, int verbosity_level, char *fmt, ...);

/**********************************/
/* export the interface functions */

#define ctl dumb_control_mode

ControlMode ctl=
{
  "dumb interface", 'd',
  1,0,0,
  ctl_open, ctl_close, ctl_read, cmsg,
  ctl_refresh, ctl_reset, ctl_file_name, ctl_total_time, ctl_current_time,
  ctl_note,
  ctl_master_volume, ctl_program, ctl_volume, 
  ctl_expression, ctl_panning, ctl_sustain, ctl_pitch_bend
};

//static FILE *infp=stdin, *outfp=stdout; /* infp isn't actually used yet */
static FILE *infp, *outfp=NULL; /* infp isn't actually used yet */

void ctl_head(void)
{
    char title[]="(C) 1995 Tuukka Toivonen <titoivon@snakemail.hut.fi>";
    char title2[]="Gert-Jan de Jonge <gertjan@saturnus.nl>";
    gotoxy( 1, 1 ); cprintf( "TiMidity v" TIMID_VERSION);
    gotoxy( 1, 2 ); cprintf( "Dos Version" );

    gotoxy( 80-strlen( title ), 1 ); cprintf( title );
    gotoxy( 80-strlen( title2 ), 2); cprintf( title2 );
}

static int ctl_open(int using_stdin, int using_stdout)
{
  clrscr();
  ctl_head();

  ctl.opened=1;
  return 0;
}

static void ctl_close(void)
{
  clrscr();
  ctl.opened=0;
}

static void ctl_help_mode(void)
{
    static int ctl_helpmode=0;
    if (ctl_helpmode)
    {
	ctl_helpmode=0;

/*
 * Clear the head zone and reprint head message.
 */
	gotoxy( 1, 1 ); clreol();
	gotoxy( 1, 2 ); clreol();
	ctl_head();
    }
    else
    {
	ctl_helpmode=1;
	gotoxy(1,1); clreol();
	cprintf( "V=Louder    b=Skip back      n=Next file      r=Restart file");
	gotoxy(1,2); clreol();
	cprintf( "v=Softer    f=Skip forward   p=Previous file  q=Quit program");
    }
}



static int ctl_read(int32 *valp)
{
  int c;
  if( kbhit() )
  while ((c=getch()))
    {
      switch(c)
	{
	case 'h':
	case '?':
	  ctl_help_mode();
	  return RC_NONE;

	case 'V':
	  *valp=10;
	  return RC_CHANGE_VOLUME;
	case 'v':
	  *valp=-10;
	  return RC_CHANGE_VOLUME;
	case 'q':
	  return RC_QUIT;
	case 'n':
	  return RC_NEXT;
	case 'p':
	  return RC_REALLY_PREVIOUS;
	case 'r':
	  return RC_RESTART;

	case 'f':
	  *valp=play_mode->rate;
	  return RC_FORWARD;
	case 'b':
	  *valp=play_mode->rate;
	  return RC_BACK;
	  /* case ' ':
	     return RC_TOGGLE_PAUSE; */
	}
    }
  return RC_NONE;
}

static int cmsg(int type, int verbosity_level, char *fmt, ...)
{
    va_list ap;
    char buffer[1024];
    static int  msg_x=6;

    if ((type==CMSG_TEXT || type==CMSG_INFO || type==CMSG_WARNING) &&
	ctl.verbosity<verbosity_level)
    return 0;

// print the line, anyway what happens
    gotoxy( 1, msg_x );
    va_start( ap, fmt );
    vsprintf( buffer, fmt, ap);
    buffer[79]=0;
    cprintf( buffer );
    va_end(ap);
    msg_x++;

    if( msg_x==26 )
    {
	msg_x--;
	movetext( 1, 7, 80, 25, 1, 6 );
	gotoxy( 1, 25 );
	cprintf( "                                                                               " );
	gotoxy( 1, 25 );
    }
    return 0;
}

static void ctl_refresh(void) { }

static void ctl_total_time(int tt)
{
  int mins, secs;
//  if (ctl.trace_playing)
  last_x=wherex();
  last_y=wherey();
  gotoxy( 20, 3 );	// tweede regel
    {
      secs=tt/play_mode->rate;
      mins=secs/60;
      secs-=mins*60;
      cprintf( "Total playing time: %3d min %02d s", mins, secs);
    }
  gotoxy( last_x, last_y );

}

static void ctl_master_volume(int mv)
{
  last_x=wherex();
  last_y=wherey();
  gotoxy( 1, 4 );	// tweede regel
    {
      cprintf( "Volume : %3d %%", mv );
    }
  gotoxy( last_x, last_y );
}

static void ctl_file_name(char *name)
{
  last_x=wherex();
  last_y=wherey();
  gotoxy( 20, 4 );	// eerste regel
  cprintf( "Playing " );
  textcolor( WHITE );
  cprintf( "%-70s", name);
  gotoxy( 1, 5 );
  cprintf( "--------------------------------------------------------------------------------" );
  textcolor( LIGHTGRAY );
  gotoxy( last_x, last_y );
}

static void ctl_current_time(int ct)
{
  int mins, secs;

  //if (ctl.trace_playing)
  last_x=wherex();
  last_y=wherey();
  gotoxy( 1, 3 );	// tweede regel
  cprintf( "time:" );
    {
      secs=ct/play_mode->rate;
      mins=secs/60;
      secs-=mins*60;
      textcolor(WHITE);
      cprintf( "%3d:%02d", mins, secs);
      textcolor( LIGHTGRAY);
    }
  gotoxy(last_x,last_y);
}

static void ctl_note(int v) {}

static void ctl_program(int ch, int val) {}

static void ctl_volume(int channel, int val) {}

static void ctl_expression(int channel, int val) {}

static void ctl_panning(int channel, int val) {}

static void ctl_sustain(int channel, int val) {}

static void ctl_pitch_bend(int channel, int val) {}

static void ctl_reset(void) {}

