#include <windows.h>
#include <alloc.h>
#include <stdio.h>
#include "dpmi.h"

void FAR __export test_func( void );

int get_version( VerStr *vs )
{
    _AX=0x400;
    _asm int 31h
    _asm jc Vers_Err
    vs->minor=_AL;
    vs->major=_AH;
    vs->flags=_BX;
    vs->processor=_CL;
    vs->PIC_Slave=_DL;
    vs->PIC_Master=_DH;
    return 0;
Vers_Err:
    return -1;
}

typedef struct tagErrStr
{
    unsigned int error;
    char *error_str;
}tagErrStr;
tagErrStr Errs[]={
	{ 0x8001, "Unsupported function" },
	{ 0x8002, "Invalid state" },
	{ 0x8003, "System integrity" },
	{ 0x8004, "Dead lock" },
	{ 0x8005, "Request canceled" },
	{ 0x8010, "Resource unavailable" },
	{ 0x8011, "Descriptor unavailable" },
	{ 0x8012, "Linear memory unavailable" },
	{ 0x8013, "Physical memory unavailable" },
	{ 0x8014, "Backing store unavailable" },
	{ 0x8015, "Callback unavailable" },
	{ 0x8016, "handle Unavailable" },
	{ 0x8017, "Lock count exceeded" },
	{ 0x8018, "Resource owned exclusively" },
	{ 0x8019, "Resource owned shared" },
	{ 0x8021, "Invalid value" },
	{ 0x8022, "Invalid selector" },
	{ 0x8023, "Invalid handle" },
	{ 0x8024, "Invalid callback" },
	{ 0x8025, "Invalid linear address" },
	{ 0x8026, "Invalid request" }
};
int numerrs=sizeof(Errs)/sizeof(tagErrStr);

void CheckError(unsigned int err)
{
    int tel;
    for( tel=0;tel<=numerrs; tel++ )
	if( Errs[tel].error==err )
	    printf( "Error : %s\n", Errs[tel].error_str );
}

int get_capabilities( CapStr *cs )
{
    _asm {  uses eax, ebx, ecx, edx }

    _AX=0x401;
#ifdef __FLAT__
    // no selector shit;
    // _ES=FP_SEG( cs->buffer );
    _EDI=(unsigned long )cs->buffer;
#else
    _ES=FP_SEG( cs->buffer );
    _DI=FP_OFF( cs->buffer );
#endif
    _asm int 31h
    _asm jc Cap_Err
    cs->flags=_AX;

    return 0;
Cap_Err:
    return -1;
}

CapStr cs;
VerStr vs;
static int initialized=0;
static int has_cs;
static int has_vs;
void InitCs(void)
{
    if( !initialized )
    {
	if( get_version( &vs ) )
	{
	    printf( "Error dpmi version\n" );
	    has_vs=1;
	}
	else
	{
	    if( get_capabilities( &cs ) )
		printf( "error capabilities\n" );
	    else
		has_cs=1;
	}
	initialized=1;
    }
}

int  CanMap_ConvMem(void)
{
    InitCs();
/*
    if( get_version( &vs ) )
	printf( "Error dpmi version\n" );
    else
    {
	printf( "Dpmi versie : %d.%d\n", vs.major, vs.minor );
	printf( "Processor   : %d (2=286, 3=386, 4=486)\n", vs.processor );
	if( vs.flags&1 )
	    printf( "\tThis is a 32 bit implementation.\n" );
	else
	    printf( "\tThis is a 16 bit implementation.\n" );
	if( vs.flags&2 )
	    printf( "\tReflected interrupts returned to real.\n" );
	else
	    printf( "\tReflected interrupts returned to virtual V86.\n" );
	if( vs.flags&4 )
	    printf( "\tVirtual memory supported.\n\n" );
	else
	    printf( "\tVirtual memory not supported.\n\n" );

	if( get_capabilities( &cs ) )
	    printf( "Error capabilities\n" );
	else
	{
	    printf( "Extended :\n" );
	    printf( "Dpmi versie : %d.%d\n", cs.buffer[0], cs.buffer[1] );
	    printf( "Name        : %s\n", cs.buffer+2 );
	    if( cs.flags&1 )
		printf( "\tPaged Accessed/Dirty capability supported\n" );
	    else
		printf( "\tPaged Accessed/Dirty capability NOT supported\n" );
	    if( cs.flags&2 )
		printf( "\tExceptions restartability capability supported\n" );
	    else
		printf( "\tExceptions restartability capability not supported\n" );
	    if( cs.flags&4 )
		printf( "\tDevice mapping capability supported\n" );
	    else
		printf( "\tDevice mapping capability NOT supported\n" );
	    if( cs.flags&8 )
		printf( "\tConventional memory mapping capability supported\n" );
	    else
		printf( "\tConventional memory mapping capability NOT supported\n" );
	    if( cs.flags&16 )
		printf( "\tdemand Zero-fill capability supported\n" );
	    else
		printf( "\tdemand Zero-fill capability NOT supported\n" );
	    if( cs.flags&32 )
		printf( "\tWrite protect client capability supported\n" );
	    else
		printf( "\tWrite protect client capability NOT supported\n" );
	    if( cs.flags&64 )
		printf( "\tWrite protect host capability supported\n" );
	    else
		printf( "\tWrite protect host capability NOT supported\n" );
	}
*/
    if( has_cs )
	return cs.flags&8;
    else
	return 0;
}
